from typing import Iterable, Optional

from django.contrib.auth import get_user_model

from lms.courses.models import Course, CourseVisibility

User = get_user_model()


class AvailableCoursesPayloadMixin:
    def generate_payload(self, user: Optional[User] = None) -> Iterable[dict]:
        for course in (
            Course.objects
            .active(user)
            .exclude(id__in=CourseVisibility.objects.unavailable_for(user))
        ):
            yield {'course_id': course.id, 'limit': 100}
