from itertools import cycle
from typing import Iterable

from tqdm import tqdm


class BaseFactory:
    def __init__(self, host: str, tape_length: int):
        self.host = host
        self.tape_length = tape_length

    def generate(self, progress: bool = False) -> Iterable[str]:
        raise NotImplementedError("Method 'generate' not implemented")


class ChunkedBaseFactory(BaseFactory):
    def generate(self, progress: bool = False) -> Iterable[str]:
        generator = enumerate(cycle(self.generate_chunk()))
        generator = tqdm(generator, total=self.tape_length) if progress else generator
        for i, ammo in generator:
            yield ammo
            if i == self.tape_length:
                return

    def generate_chunk(self) -> Iterable[str]:
        raise NotImplementedError("Method 'generate_chunk' not implemented")
