from typing import Iterable, Optional

from django.contrib.auth import get_user_model

from ..ammo.base import BaseAmmo
from ..auth.base import BaseAmmoAuth
from .base import ChunkedBaseFactory

User = get_user_model()


class BaseAmmoFactory(ChunkedBaseFactory):
    ammo_class: BaseAmmo

    def __init__(self, host: str, tape_length: int, auth_class: BaseAmmoAuth.__class__, **kwargs):
        self.auth_class = auth_class
        self.auth_params = kwargs.pop('auth_params')
        super().__init__(host=host, tape_length=tape_length)

    def generate_users(self) -> Iterable[User]:
        yield None

    def generate_payload(self, user: Optional[User] = None) -> Iterable[dict]:
        yield {}

    def generate_chunk(self) -> Iterable[str]:
        for user in self.generate_users():
            auth = self.auth_class(user, **self.auth_params) if user else None
            for payload in self.generate_payload(user):
                yield self.ammo_class(host=self.host, payload=payload, auth=auth).generate()


class UsersWithUidBaseAmmoFactory(BaseAmmoFactory):
    def generate_users(self) -> Iterable[User]:
        return User.objects.filter(yauid__isnull=False)
