from typing import Iterable, Optional

from django.contrib.auth import get_user_model

from lms.courses.models import Course, CourseVisibility

from ..ammo.course_slug import CoursesSlugAmmo
from .base_ammo import UsersWithUidBaseAmmoFactory

User = get_user_model()


class CoursesSlugAmmoFactory(UsersWithUidBaseAmmoFactory):
    ammo_class = CoursesSlugAmmo

    def generate_payload(self, user: Optional[User] = None) -> Iterable[dict]:
        for course in (
            Course.objects
                .active(user)
                .exclude(id__in=CourseVisibility.objects.unavailable_for(user))
        ):
            yield {'slug': course.slug}
