from itertools import chain
from typing import Iterable

from django.contrib.auth import get_user_model

from .base import ChunkedBaseFactory
from .course_categories_list import CoursesCategoriesAmmoFactory
from .course_detail import CoursesDetailAmmoFactory
from .course_enrollments_list import CoursesEnrollmentsAmmoFactory
from .course_groups_list import CourseGroupsListAmmoFactory
from .course_list import CoursesListAmmoFactory
from .course_slug import CoursesSlugAmmoFactory
from .enrollment_detail import EnrollmentDetailAmmoFactory
from .my_course_permissions import MyCoursePermissionsAmmoFactory
from .my_enroll import MyEnrollAmmoFactory
from .my_permissions import MyPermissionsAmmoFactory
from .my_profile import MyProfileAmmoFactory

User = get_user_model()

FACTORIES = [
    MyEnrollAmmoFactory,
    MyCoursePermissionsAmmoFactory,
    MyProfileAmmoFactory,
    CoursesListAmmoFactory,
    CoursesDetailAmmoFactory,
    CourseGroupsListAmmoFactory,
    CoursesSlugAmmoFactory,
    CoursesEnrollmentsAmmoFactory,
    CoursesCategoriesAmmoFactory,
    MyCoursePermissionsAmmoFactory,
    EnrollmentDetailAmmoFactory,
    MyPermissionsAmmoFactory
]


class MixedFactory(ChunkedBaseFactory):
    def __init__(self, *args, **kwargs):
        self_args = dict(args)
        self_kwargs = dict(kwargs)
        self_kwargs.pop('auth_class')
        self_kwargs.pop('auth_params')
        super().__init__(*self_args, **self_kwargs)

        self.factory_args = args
        self.factory_kwargs = kwargs

        self.factories = [
            factory(*self.factory_args, **self.factory_kwargs)
            for factory in FACTORIES
        ]

    def generate_chunk(self) -> Iterable[str]:
        for ammo in chain(*zip(*[factory.generate_chunk() for factory in self.factories])):
            yield ammo
