from django.core.management.base import BaseCommand

from ...auth.tvm_debug import TVMDebugAmmoAuth
from ...factories import (
    CourseGroupsListAmmoFactory, CoursesCategoriesAmmoFactory, CoursesDetailAmmoFactory, CoursesEnrollmentsAmmoFactory,
    CoursesListAmmoFactory, CoursesSlugAmmoFactory, EnrollmentDetailAmmoFactory, MixedFactory,
    MyCoursePermissionsAmmoFactory, MyEnrollAmmoFactory, MyPermissionsAmmoFactory, MyProfileAmmoFactory,
)
from ...services import write_tape

FACTORY_MAP = {
    'MyProfileAmmoFactory': MyProfileAmmoFactory,
    'CoursesListAmmoFactory': CoursesListAmmoFactory,
    'MyEnrollAmmoFactory': MyEnrollAmmoFactory,
    'MyPermissionsAmmoFactory': MyPermissionsAmmoFactory,
    'CoursesDetailAmmoFactory': CoursesDetailAmmoFactory,
    'CourseGroupsListAmmoFactory': CourseGroupsListAmmoFactory,
    'CoursesSlugAmmoFactory': CoursesSlugAmmoFactory,
    'CoursesEnrollmentsAmmoFactory': CoursesEnrollmentsAmmoFactory,
    'CoursesCategoriesAmmoFactory': CoursesCategoriesAmmoFactory,
    'MyCoursePermissionsAmmoFactory': MyCoursePermissionsAmmoFactory,
    'EnrollmentDetailAmmoFactory': EnrollmentDetailAmmoFactory,

    'MixedFactory': MixedFactory,
}


class Command(BaseCommand):
    def generate_ammos(self, options):
        filename = options.get('filename')
        with open(filename, 'w') as stream:
            write_tape(
                ammo_factory=FACTORY_MAP[options.get('factory')](
                    host=options.get('host'),
                    auth_class=TVMDebugAmmoAuth,
                    auth_params={'tvm_client_id': options.get('tvm_client_id')},
                    tape_length=options.get('tape_length'),
                ),
                stream=stream,
                progress=options.get('progress', False),
            )

    def add_arguments(self, parser):
        parser.add_argument(
            '--host', dest='host', type=str, required=True,
            help='Host to shoot to',
        )
        parser.add_argument(
            '--factory', dest='factory', type=str, choices=FACTORY_MAP.keys(), required=True,
            help='Factory of ammos',
        )
        parser.add_argument(
            '--tvm-client-id', dest='tvm_client_id', type=int, required=True,
            help='TVM to requests from',
        )
        parser.add_argument(
            '--tape-length', '-l', dest='tape_length', type=int, required=True,
            help='Tape of ammos length',
        )
        parser.add_argument(
            '--file', '-f', dest='filename', type=str, required=True,
            help='File to write generated ammos to',
        )
        parser.add_argument(
            '--progress', action='store_true', dest='progress',
            help='Output generator progress',
        )

    def handle(self, *args, **options):
        self.generate_ammos(options)

        self.stdout.write("Done\n")
