from django_admin_listfilter_dropdown.filters import RelatedOnlyDropdownFilter

from django.contrib import admin

from lms.tags.models import Tag, UserTag


@admin.register(Tag)
class TagAdmin(admin.ModelAdmin):
    search_fields = (
        'id', 'normalized_name',
    )

    list_display = ('name', 'normalized_name', 'created', 'modified',)

    fields = ('name', 'normalized_name',)
    readonly_fields = ('normalized_name',)


@admin.register(UserTag)
class UserTagAdmin(admin.ModelAdmin):
    search_fields = (
        'id', 'tag__id', 'tag__name', 'user__id', 'user__username',
    )

    list_filter = (
        ('user', RelatedOnlyDropdownFilter),
    )
    list_select_related = ('tag', 'user',)
    list_display = ('tag', 'user',)

    fields = ('tag', 'user',)
    raw_id_fields = ('user',)
