from django_filters import rest_framework as filters
from drf_spectacular.utils import extend_schema

from django.utils.translation import gettext

from lms.core.views.pagination import LimitOffsetAllPagination
from lms.core.views.viewsets import LabModelViewSet

from ..filtersets import TagLabFilterSet
from ..models import Tag
from ..serializers import TagCreateLabSerializer, TagDetailLabSerializer, TagListLabSerializer, TagUpdateLabSerializer


class TagLabViewSet(LabModelViewSet):
    serializer_class = TagListLabSerializer
    serializer_classes = {
        'create': TagCreateLabSerializer,
        'update': TagUpdateLabSerializer,
        'partial_update': TagUpdateLabSerializer,
        'retrieve': TagDetailLabSerializer,
    }
    queryset = Tag.objects.all()
    filter_backends = [filters.DjangoFilterBackend]
    filterset_class = TagLabFilterSet
    pagination_class = LimitOffsetAllPagination

    @extend_schema(
        responses={200: TagListLabSerializer},
        summary=gettext("Список тегов")
    )
    def list(self, request, *args, **kwargs):
        return super().list(request, *args, **kwargs)

    @extend_schema(
        responses={200: TagDetailLabSerializer},
        summary=gettext("Информация о теге")
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)

    @extend_schema(
        request=TagCreateLabSerializer,
        responses={201: TagDetailLabSerializer},
        summary=gettext("Создание тега"),
    )
    def create(self, request, *args, **kwargs):
        return super().create(request, *args, **kwargs)

    @extend_schema(
        request=TagUpdateLabSerializer,
        responses={200: TagDetailLabSerializer},
        summary=gettext("Обновление тега"),
    )
    def update(self, request, *args, **kwargs):
        return super().update(request, *args, **kwargs)

    @extend_schema(
        request=TagUpdateLabSerializer,
        responses={200: TagDetailLabSerializer},
        summary=gettext("Частичное обновление тега"),
    )
    def partial_update(self, request, *args, **kwargs):
        return super().partial_update(request, *args, **kwargs)

    @extend_schema(
        summary=gettext("Удаление тега"),
    )
    def destroy(self, request, *args, **kwargs):
        return super().destroy(request, *args, **kwargs)
