# Generated by Django 2.2.13 on 2020-08-20 14:35

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('enrollments', '0003_fix_json_fields'),
        ('tracker', '0002_enrollsurveyform_description'),
    ]

    operations = [
        migrations.CreateModel(
            name='EnrollmentTrackerQueue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('name', models.CharField(max_length=255, verbose_name='имя очереди')),
                ('is_default', models.BooleanField(verbose_name='очередь по умолчанию')),
                ('summary', models.CharField(max_length=255, verbose_name='заголовок тикета')),
                ('description', models.TextField(verbose_name='описание тикета')),
                ('issue_type', models.CharField(max_length=255, verbose_name='тип тикета')),
                ('accepted_status', models.CharField(default='accepted', max_length=255, verbose_name='статус для подтверждения заявки')),
                ('rejected_status', models.CharField(default='rejected', max_length=255, verbose_name='статус для отклонения заявки')),
                ('enrollment', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='tracker_queues', to='enrollments.Enrollment', verbose_name='зачисление')),
            ],
            options={
                'verbose_name': 'очередь в трекере',
                'verbose_name_plural': 'очереди в трекере',
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='EnrollmentTrackerIssue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('issue_number', models.IntegerField(blank=True, null=True, verbose_name='номер тикета')),
                ('got_status_from_startrek', models.DateTimeField(blank=True, null=True, verbose_name='дата получения статуса из стартрека')),
                ('status', models.CharField(blank=True, max_length=255, verbose_name='статус')),
                ('status_processed', models.BooleanField(default=False, verbose_name='статус обработан')),
                ('enrolled_user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='enrollment_tracker_issues', to='enrollments.EnrolledUser', verbose_name='заявка на зачисление')),
                ('queue', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='enrollment_tracker_issues', to='tracker.EnrollmentTrackerQueue', verbose_name='очередь')),
            ],
            options={
                'verbose_name': 'тикет на зачисление',
                'verbose_name_plural': 'тикеты на зачисление',
                'unique_together': {('enrolled_user', 'queue')},
            },
        ),
    ]
