# Generated by Django 2.2.15 on 2020-10-13 06:42

from django.db import migrations
from django_celery_beat.models import (
    MINUTES
)

create_tickets_task_name = 'Create issue in tracker'
create_tickets_task_path = 'lms.tracker.tasks.create_tickets_task'

receive_ticket_statuses_task_name = 'Receive issue status from tracker'
receive_ticket_statuses_task_path = 'lms.tracker.tasks.receive_ticket_statuses_task'


def forward(apps, schema_editor):
    IntervalSchedule = apps.get_model('django_celery_beat', 'IntervalSchedule')
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    interval, _ = IntervalSchedule.objects.get_or_create(
        period=MINUTES,
        every=1,
    )

    task1, _ = PeriodicTask.objects.get_or_create(
        name=create_tickets_task_name,
        defaults={
            'task': create_tickets_task_path,
            'interval': interval,
            'kwargs': {"time_limit": 30},
        },
    )

    task2, _ = PeriodicTask.objects.get_or_create(
        name=receive_ticket_statuses_task_name,
        defaults={
            'task': receive_ticket_statuses_task_path,
            'interval': interval,
            'kwargs': {"time_limit": 30},
        },
    )


def backward(apps, schema_editor):
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    PeriodicTask.objects.filter(
        name=create_tickets_task_name,
    ).delete()

    PeriodicTask.objects.filter(
        name=receive_ticket_statuses_task_name,
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('django_celery_beat', '0006_auto_20180210_1226'),
        ('tracker', '0004_auto_20200824_0649'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
