# Generated by Django 2.2.15 on 2020-12-15 14:23

from django.db import migrations
from django_celery_beat.models import (
    HOURS
)

create_tracker_enrollment_issues_bulk_task_name = 'Create enrollment issue in tracker (bulk)'
create_tracker_enrollment_issues_bulk_task_path = 'lms.tracker.tasks.create_tracker_enrollment_issues_bulk_task'


def forward(apps, schema_editor):
    IntervalSchedule = apps.get_model('django_celery_beat', 'IntervalSchedule')
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    interval, _ = IntervalSchedule.objects.get_or_create(
        period=HOURS,
        every=1,
    )

    task1, _ = PeriodicTask.objects.get_or_create(
        name=create_tracker_enrollment_issues_bulk_task_name,
        defaults={
            'task': create_tracker_enrollment_issues_bulk_task_path,
            'interval': interval,
        },
    )


def backward(apps, schema_editor):
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    PeriodicTask.objects.filter(
        name=create_tracker_enrollment_issues_bulk_task_name,
    ).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('django_celery_beat', '0006_auto_20180210_1226'),
        ('tracker', '0007_default_false_for_is_default'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
