# Generated by Django 2.2.15 on 2021-01-22 16:09

from django.db import migrations
from django_celery_beat.models import (
    HOURS
)

process_tracker_hook_event_bulk_task_task_name = 'Process tracker hook event (bulk task)'
process_tracker_hook_event_bulk_task_task_path = 'lms.tracker.tasks.process_tracker_hook_event_bulk_task'


def forward(apps, schema_editor):
    IntervalSchedule = apps.get_model('django_celery_beat', 'IntervalSchedule')
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    interval, _ = IntervalSchedule.objects.get_or_create(
        period=HOURS,
        every=1,
    )

    task1, _ = PeriodicTask.objects.get_or_create(
        name=process_tracker_hook_event_bulk_task_task_name,
        defaults={
            'task': process_tracker_hook_event_bulk_task_task_path,
            'interval': interval,
        },
    )


def backward(apps, schema_editor):
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    PeriodicTask.objects.filter(
        name=process_tracker_hook_event_bulk_task_task_name,
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('django_celery_beat', '0006_auto_20180210_1226'),
        ('tracker', '0013_tracker_hook'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
