# Generated by Django 3.0.11 on 2021-03-10 07:32

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('classrooms', '0003_studentslot'),
        ('tracker', '0014_process_tracker_hook_event_bulk_task'),
    ]

    operations = [
        migrations.CreateModel(
            name='TrackerQueue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(blank=True, max_length=255, verbose_name='имя настройки')),
                ('queue_name', models.CharField(max_length=255, verbose_name='имя очереди')),
                ('summary', models.CharField(default='{course} - {first_name} {last_name} ({login})', help_text='Доступны параметры: course - название курса, first_name - имя, last_name - фамилия, login - логин', max_length=255, verbose_name='заголовок тикета')),
                ('description', models.TextField(blank=True, verbose_name='описание тикета')),
                ('issue_type', models.CharField(max_length=255, verbose_name='тип тикета')),
                ('initial_state', models.CharField(blank=True, max_length=255, verbose_name='начальный статус тикета')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
            ],
            options={
                'verbose_name': 'очередь в трекере',
                'verbose_name_plural': 'очереди в трекере',
            },
        ),
        migrations.CreateModel(
            name='ClassroomTrackerQueue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('classroom', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tracker_queues', to='classrooms.Classroom', verbose_name='занятие с расписанием')),
                ('queue', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='classrooms', to='tracker.TrackerQueue', verbose_name='очередь')),
            ],
            options={
                'verbose_name': 'очередь занятия с расписанием',
                'verbose_name_plural': 'очереди занятий с расписанием',
            },
        ),
        migrations.CreateModel(
            name='StudentSlotTrackerIssue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('issue_number', models.IntegerField(blank=True, null=True, verbose_name='номер тикета')),
                ('queue', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='students_slots', to='tracker.ClassroomTrackerQueue', verbose_name='очередь занятия с расписанием')),
                ('slot', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='queues', to='classrooms.StudentSlot', verbose_name='запись на слот')),
            ],
            options={
                'verbose_name': 'тикет на слот',
                'verbose_name_plural': 'тикеты на слоты',
                'unique_together': {('slot', 'queue')},
            },
        ),
    ]
