# Generated by Django 3.0.11 on 2021-05-21 10:38

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('classrooms', '0004_tracker_history'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('enrollments', '0018_enrollment_history'),
        ('tracker', '0016_enrollment_tracker_queue_verbose_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalTrackerQueue',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(blank=True, max_length=255, verbose_name='имя настройки')),
                ('queue_name', models.CharField(max_length=255, verbose_name='имя очереди')),
                ('summary', models.CharField(default='{course} - {first_name} {last_name} ({login})', help_text='Доступны параметры: course - название курса, first_name - имя, last_name - фамилия, login - логин', max_length=255, verbose_name='заголовок тикета')),
                ('description', models.TextField(blank=True, verbose_name='описание тикета')),
                ('issue_type', models.CharField(max_length=255, verbose_name='тип тикета')),
                ('initial_state', models.CharField(blank=True, max_length=255, verbose_name='начальный статус тикета')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical очередь в трекере',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalEnrollmentTrackerQueue',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, verbose_name='имя очереди')),
                ('is_default', models.BooleanField(default=False, verbose_name='очередь по умолчанию')),
                ('summary', models.CharField(default='{course} - {first_name} {last_name} ({login})', help_text='Доступны параметры: course - название курса, first_name - имя, last_name - фамилия, login - логин', max_length=255, verbose_name='заголовок тикета')),
                ('description', models.TextField(blank=True, verbose_name='описание тикета')),
                ('issue_type', models.CharField(max_length=255, verbose_name='тип тикета')),
                ('accepted_status', models.CharField(blank=True, default='accepted', max_length=255, null=True, verbose_name='статус для подтверждения заявки')),
                ('rejected_status', models.CharField(blank=True, default='rejected', max_length=255, null=True, verbose_name='статус для отклонения заявки')),
                ('cancelled_status', models.CharField(blank=True, default='cancelled', max_length=255, null=True, verbose_name='статус для отмены заявки')),
                ('tracker_pulling_enabled', models.BooleanField(default=True, help_text='Периодически опрашиваем трекер на наличие изменений статуса по тикетам (long-polling)', verbose_name='запрашивать статусы из трекера')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('enrollment', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enrollments.Enrollment', verbose_name='зачисление')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical очередь для зачисления',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalClassroomTrackerQueue',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('classroom', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='classrooms.Classroom', verbose_name='занятие с расписанием')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('queue', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='tracker.TrackerQueue', verbose_name='очередь')),
            ],
            options={
                'verbose_name': 'historical очередь занятия с расписанием',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
