# Generated by Django 3.0.11 on 2021-05-26 14:31

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('tracker', '0017_tracker_history'),
    ]

    operations = [
        migrations.CreateModel(
            name='TicketTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('summary', models.TextField(verbose_name='название тикета')),
                ('description', models.TextField(blank=True, verbose_name='описание тикета')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
            ],
            options={
                'verbose_name': 'шаблон тикета',
                'verbose_name_plural': 'шаблоны тикетов',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='TicketFieldTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('field_name', models.CharField(max_length=500, verbose_name='название поля')),
                ('value', models.TextField(blank=True, verbose_name='значение')),
                ('is_active', models.BooleanField(default=True, verbose_name='активно')),
                ('template', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fields', to='tracker.TicketTemplate', verbose_name='шаблон тикета')),
            ],
            options={
                'verbose_name': 'шаблон для поля тикета',
                'verbose_name_plural': 'шаблоны для полей тикетов',
                'ordering': ('field_name',),
                'unique_together': {('template', 'field_name')},
            },
        ),
    ]
