# Generated by Django 3.0.11 on 2021-07-07 19:10

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import lms.tracker.models
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('classrooms', '0004_tracker_history'),
        ('tracker', '0022_delete_studentslottrackerissue'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClassroomQueue',
            fields=[
                ('trackerqueue_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='tracker.TrackerQueue')),
            ],
            options={
                'verbose_name': 'очередь для оффлайн-занятий',
                'verbose_name_plural': 'очереди для оффлайн-занятий',
            },
            bases=('tracker.trackerqueue',),
        ),
        migrations.RemoveField(
            model_name='historicaltrackerqueue',
            name='description',
        ),
        migrations.RemoveField(
            model_name='historicaltrackerqueue',
            name='name',
        ),
        migrations.RemoveField(
            model_name='historicaltrackerqueue',
            name='summary',
        ),
        migrations.RemoveField(
            model_name='trackerqueue',
            name='description',
        ),
        migrations.RemoveField(
            model_name='trackerqueue',
            name='name',
        ),
        migrations.RemoveField(
            model_name='trackerqueue',
            name='summary',
        ),
        migrations.AddField(
            model_name='historicaltrackerqueue',
            name='template',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='tracker.TicketTemplate', verbose_name='шаблон тикета'),
        ),
        migrations.AddField(
            model_name='trackerqueue',
            name='template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='tracker_queues', to='tracker.TicketTemplate', verbose_name='шаблон тикета'),
        ),
        migrations.RenameField(
            model_name='historicaltrackerqueue',
            old_name='queue_name',
            new_name='name',
        ),
        migrations.RenameField(
            model_name='trackerqueue',
            old_name='queue_name',
            new_name='name',
        ),
        migrations.CreateModel(
            name='TrackerIssue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('queue_type', models.CharField(blank=True, choices=[('enrollments__enrolleduser', 'Зачисление на курс'), ('classrooms__studentslot', 'Слоты для оффлайн-занятий')], max_length=50, verbose_name='тип очереди')),
                ('issue_key', models.CharField(db_index=True, max_length=255, verbose_name='номер тикета')),
                ('issue_status', models.CharField(blank=True, max_length=255, verbose_name='статус тикета')),
                ('status', models.CharField(choices=[('pending', 'Ожидает'), ('success', 'Обработан'), ('error', 'Ошибка')], default='pending', max_length=20, verbose_name='статус')),
                ('queue', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='issues', to='tracker.TrackerQueue', verbose_name='очередь')),
            ],
            options={
                'verbose_name': 'тикет в трекере',
                'verbose_name_plural': 'тикеты в трекере',
                'ordering': ('queue', '-created'),
            },
        ),
        migrations.CreateModel(
            name='ClassroomTracker',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('classroom', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='tracker', to='classrooms.Classroom', verbose_name='занятие с расписанием')),
                ('queue', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tracker', to='tracker.ClassroomQueue', verbose_name='очередь в трекере')),
            ],
            options={
                'verbose_name': 'настройки очереди для оффлайн-занятия',
                'verbose_name_plural': 'настройки очередей для оффлайн-занятий',
            },
        ),
        migrations.CreateModel(
            name='StudentSlotTrackerIssue',
            fields=[
                ('trackerissue_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='tracker.TrackerIssue')),
                ('slot', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='queues', to='classrooms.StudentSlot', verbose_name='запись на слот')),
            ],
            options={
                'verbose_name': 'тикет на слот в оффлайн-занятии',
                'verbose_name_plural': 'тикеты на слоты в оффлайн-занятиях',
            },
            bases=('tracker.trackerissue',),
        ),
        migrations.CreateModel(
            name='TrackerHook',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False,
                                                                verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False,
                                                                      verbose_name='modified')),
                ('id',
                 model_utils.fields.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, verbose_name='данные запроса')),
                ('action', models.CharField(blank=True, max_length=255, verbose_name='действие')),
                ('status',
                 models.CharField(choices=[('pending', 'В обработке'), ('success', 'Обработан'), ('error', 'Ошибка')],
                                  default='pending', max_length=20, verbose_name='статус')),
                ('result', models.TextField(blank=True, verbose_name='результат')),
                ('issue', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                            related_name='hooks', to='tracker.TrackerIssue', verbose_name='тикет')),
            ],
            options={
                'verbose_name': 'Событие из трекера',
                'verbose_name_plural': 'События из трекера',
            },
        ),
    ]
