# Generated by Django 3.0.11 on 2021-09-13 18:05

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('enrollments', '0019_enroll_completion_dates'),
        ('tracker', '0026_import_export_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='EnrollmentQueue',
            fields=[
                ('trackerqueue_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='tracker.TrackerQueue')),
            ],
            options={
                'verbose_name': 'очередь для заявок',
                'verbose_name_plural': 'очереди для заявок',
            },
            bases=('tracker.trackerqueue',),
        ),
        migrations.AddField(
            model_name='trackerhook',
            name='tracker_hook_event',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tracker_hooks', to='tracker.TrackerHookEvent', verbose_name='старый хук'),
        ),
        migrations.CreateModel(
            name='EnrollmentTracker',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_default', models.BooleanField(default=False, verbose_name='очередь по умолчанию')),
                ('enrollment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tracker', to='enrollments.Enrollment', verbose_name='механизм зачисления')),
                ('enrollment_tracker_queue', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='enrolled_user_tracker_queues', to='tracker.EnrollmentTrackerQueue', verbose_name='старая очередь на зачисление')),
                ('queue', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tracker', to='tracker.EnrollmentQueue', verbose_name='очередь в трекере')),
            ],
            options={
                'verbose_name': 'настройки очереди для заявок',
                'verbose_name_plural': 'настройки очередей для заявок',
            },
        ),
        migrations.CreateModel(
            name='EnrolledUserTrackerIssue',
            fields=[
                ('trackerissue_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='tracker.TrackerIssue')),
                ('enrolled_user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='issues', to='enrollments.EnrolledUser', verbose_name='заявка')),
                ('enrollment_tracker_issue', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='enrolled_user_tracker_issues', to='tracker.EnrollmentTrackerIssue', verbose_name='старый тикет на зачисление')),
            ],
            options={
                'verbose_name': 'тикет на заявку',
                'verbose_name_plural': 'тикеты на заявки',
            },
            bases=('tracker.trackerissue',),
        ),
    ]
