# Generated by Django 3.0.11 on 2022-02-15 10:06

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('tracker', '0032_classroomqueue_cancel_fields'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalEnrollmentQueue',
            fields=[
                ('trackerqueue_ptr', models.ForeignKey(auto_created=True, blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, parent_link=True, related_name='+', to='tracker.TrackerQueue')),
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='Должно соответствовать очереди в Трекере', max_length=255, verbose_name='имя очереди')),
                ('display_name', models.CharField(blank=True, help_text='Название этой очереди внутри LMS', max_length=255, verbose_name='название очереди')),
                ('issue_type', models.CharField(max_length=255, verbose_name='тип тикета')),
                ('initial_state', models.CharField(blank=True, max_length=255, verbose_name='начальный статус тикета')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('template', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='tracker.TicketTemplate', verbose_name='шаблон тикета')),
            ],
            options={
                'verbose_name': 'historical очередь для заявок',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalClassroomQueue',
            fields=[
                ('trackerqueue_ptr', models.ForeignKey(auto_created=True, blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, parent_link=True, related_name='+', to='tracker.TrackerQueue')),
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='Должно соответствовать очереди в Трекере', max_length=255, verbose_name='имя очереди')),
                ('display_name', models.CharField(blank=True, help_text='Название этой очереди внутри LMS', max_length=255, verbose_name='название очереди')),
                ('issue_type', models.CharField(max_length=255, verbose_name='тип тикета')),
                ('initial_state', models.CharField(blank=True, max_length=255, verbose_name='начальный статус тикета')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('cancel_transition', models.CharField(help_text='Переход, который должен выполниться при отмене заявки сотрудником', max_length=255, verbose_name='переход при отмене')),
                ('cancel_comment', models.TextField(help_text='Комментарий, при отмене заявки сотрудником', verbose_name='комментарий при отмене')),
                ('cancel_tags', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=list, help_text='Список тегов, который нужно выставить при отмене заявки сотрудником', verbose_name='теги при отмене')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('template', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='tracker.TicketTemplate', verbose_name='шаблон тикета')),
            ],
            options={
                'verbose_name': 'historical очередь для оффлайн-занятий',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
