from django.conf import settings

from rest_framework.permissions import BasePermission


class StartrekTokenPermission(BasePermission):
    def has_permission(self, request, view):
        header_name = 'HTTP_AUTHORIZATION'
        valid_token = f'Bearer {settings.STARTREK_HOOK_TOKEN}'
        return valid_token and request.META.get(header_name, '') == valid_token

    def has_object_permission(self, request, view, obj):
        return self.has_permission(request, view)
