import logging

from drf_spectacular.utils import extend_schema

from django.utils.translation import gettext

from lms.core.views.viewsets import APIModelViewSet

from ..models import TrackerHook, TrackerHookEvent
from ..permissions import StartrekTokenPermission
from ..serializers import (
    TrackerHookCreateSerializer, TrackerHookDetailSerializer, TrackerHookEventCreateSerializer,
    TrackerHookEventDetailSerializer,
)

log = logging.getLogger(__name__)


class TrackerHookView(APIModelViewSet):
    queryset = TrackerHookEvent
    serializer_class = TrackerHookEventDetailSerializer
    serializer_classes = {
        'create': TrackerHookEventCreateSerializer,
    }
    permission_classes = [
        StartrekTokenPermission,
    ]

    @extend_schema(
        request=dict,
        responses={201: TrackerHookEventDetailSerializer},
        summary=gettext("Обработка хука трекера"),
    )
    def create(self, request, *args, **kwargs):
        return super().create(request, *args, **kwargs)

    def perform_create(self, serializer):
        serializer.save(request_body=self.request.data)


class TrackerHookV2View(APIModelViewSet):
    """
    Новый обработчик для хуков трекера

    """
    queryset = TrackerHook
    serializer_class = TrackerHookDetailSerializer
    serializer_classes = {
        'create': TrackerHookCreateSerializer,
    }
    permission_classes = [
        StartrekTokenPermission,
    ]

    @extend_schema(
        request=dict,
        responses={201: TrackerHookCreateSerializer},
        summary=gettext("Обработка хука трекера"),
    )
    def create(self, request, *args, **kwargs):
        return super().create(request, *args, **kwargs)

    def perform_create(self, serializer):
        serializer.save(data=self.request.data)
