from django.core.exceptions import ImproperlyConfigured
from django.utils.deprecation import MiddlewareMixin

from .signals import user_is_present


class UserPresenceMiddleware(MiddlewareMixin):
    """
    Миддлварь, которая управляет событием присутствия пользователя.
    """
    def process_request(self, request):
        if not hasattr(request, 'user'):
            raise ImproperlyConfigured(
                "The UserPresenceMiddleware required to be placed after other authentication middleware."
                " Check your MIDDLEWARE setting.")

        user = request.user

        if user.is_authenticated:
            user_is_present.send(sender=user.__class__, request=request, user=user)
