from lms.core.views.permissions import AllowedTVMServiceBasePermission
from lms.users.models import ServiceAccount


class IsTVMAuthenticated(AllowedTVMServiceBasePermission):
    @staticmethod
    def _has_permission(request) -> bool:
        tvm_service_id = getattr(request, 'tvm_service_id', None)
        if not tvm_service_id:
            return False
        return (ServiceAccount.objects
                .active()
                .filter(tvm_id=tvm_service_id)
                .exists())

    def has_permission(self, request, view):
        return self._has_permission(request)
