from datetime import timedelta

from django.conf import settings
from django.contrib.auth import get_user_model
from django.dispatch import receiver
from django.utils import timezone

from .signals import user_is_present

USERS_PRESENCE_UPDATE_TIME = getattr(settings, 'USERS_PRESENCE_UPDATE_TIME', 3600)

User = get_user_model()


@receiver(signal=user_is_present, dispatch_uid='update_user_last_login')
def update_last_login(sender, user: User, **kwargs) -> None:
    """
    Обработчик присутствия пользователя.

    Обновляем last_login, при наличие запросов от пользователя,
    через определенный интервал времении (по умолчанию: 1 час)
    """
    now = timezone.now()
    last_login = getattr(user, 'last_login', None)
    if not last_login or last_login < (now - timedelta(seconds=USERS_PRESENCE_UPDATE_TIME)):
        user.last_login = now
        user.save(update_fields=['last_login'])
