import os
import uuid
from typing import Iterable


def uuid_filename(filename):
    return '{}_{}'.format(uuid.uuid4().hex, filename)


def make_upload_path(folder, filename):
    return os.path.join(folder, uuid_filename(filename))


def chunks(it: Iterable, chunk_size: int) -> Iterable[Iterable[int]]:
    collector = []
    for i, item in enumerate(it):
        if i % chunk_size == 0 and collector:
            yield collector
            collector = []
        collector.append(item)

    if collector:
        yield collector
