
def evaluate_code(expression, allowed_names=None, **kwargs):
    code = compile(expression, "<string>", "eval")

    if not allowed_names:
        allowed_names = []

    for name in code.co_names:
        if name not in allowed_names:
            raise NameError(f"The use of {name} is not allowed")

    return eval(code, {"__builtins__": {}}, kwargs)  # nosec
