from django.utils.deprecation import MiddlewareMixin


class FixEmptyHostMiddleware(MiddlewareMixin):
    def process_request(self, request):
        http_host = request.META.get('HTTP_HOST', None)

        if not http_host or http_host.startswith(':'):
            request.META['HTTP_HOST'] = 'localhost'
