# encoding: utf-8
from __future__ import unicode_literals


class OAuthException(Exception):
    pass


class StaffException(Exception):
    """Базовый класс для ошибок от staff"""


class StaffInvalidInternalLogin(StaffException):
    """status_code == 400 - сейчас это только не верный логин"""


class StaffError(StaffException):
    """status_code >= 400 кроме 400, 403, 404"""


class StaffInvalidApp(StaffException):
    """
    status_code == 404 раз ручка не найдена,
    значит мы ее дернули с неправильным приложением
    """



class StaffForbidden(StaffException):
    """
    status_code == 403 нехватило прав.
    Скорее всего у пользователя нет прав.
    """
