"""
Django settings for login_linker project.

Generated by 'django-admin startproject' using Django 1.8.13.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os

try:
    execfile('/etc/secret_settings.py')
except IOError:
    pass


import blackbox
from django_yauth.settings import *
YAUTH_TYPE = 'intranet'
YAUTH_USE_SITES = False
YAUTH_PASSPORT_FIELDS = [blackbox.FIELD_LANGUAGE, blackbox.FIELD_LOGIN]

DEBUG = True

OAUTH_URL = 'https://oauth.yandex.ru/'
OAUTH_GET_TOKEN_URL = (
    '{oauth_url}authorize?response_type=code&client_id={id}'.format(
        oauth_url=OAUTH_URL,
        id=EXTERNAL_OAUTH_ID,
    )
)
YANDEX_LOGIN_URL = 'https://login.yandex.ru/'
YANDEX_LOGIN_INFO_URL = '{url}info'.format(url=YANDEX_LOGIN_URL)

import yenv

if yenv.type == 'production':
    DEBUG = False
    STAFF_HOST = 'https://staff.yandex-team.ru'
else:
    DEBUG = bool(int(os.getenv('DJANGO_DEBUG', 1)))
    STAFF_HOST = 'https://staff.test.yandex-team.ru'

STAFF_TIMEOUT = 5  # seconds

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

from pythonjsonlogger.jsonlogger import JsonFormatter
class DeployJsonFormatter(JsonFormatter):
    def process_log_record(self, log_record):
        return {
            'msg': log_record.pop('message'),
            'stackTrace': log_record.pop('exc_info'),
            '@fields': log_record,
        }

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': DeployJsonFormatter,
            'format': '%(name)s %(created)s %(message)s %(levelno)d %(levelname)d %(pathname)s %(funcName)s %(lineno)s %(exc_info)s',
        },
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'default',
        },
    },
    'loggers': {
        'django': {
            'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
            'handlers': ['console'],
            'propagate': True,
        },
        'requests': {
            'level': 'ERROR',
            'handlers': ['console'],
            'propagate': True,
        },
        'py.warnings': {
            'level': 'ERROR',
            'handlers': ['console'],
            'propagate': True,
        },
    },
    'root': {
        'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
        'handlers': ['console'],
    },
}


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/


ALLOWED_HOSTS = [
    '.yandex-team.ru',
    '.yandex.net',
    '.yandex.ru',
]

# Application definition

INSTALLED_APPS = (
    'django_yauth',
    'login_linker',
    # 'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    # 'django.contrib.sessions',
    # 'django.contrib.messages',
    'django.contrib.staticfiles',
)

MIDDLEWARE_CLASSES = (
    # 'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'login_linker.middleware.PingMiddleware',
    # 'django.middleware.csrf.CsrfViewMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    # 'django.contrib.auth.middleware.AuthenticationMiddleware',
    # 'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    # 'django.contrib.messages.middleware.MessageMiddleware',
    # 'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
)

ROOT_URLCONF = 'login_linker.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        # 'DIRS': ['templates/'],
        'APP_DIRS': True,
        # 'OPTIONS': {
        #     'context_processors': [
        #         'django.template.context_processors.debug',
        #         'django.template.context_processors.request',
        #         'django.contrib.auth.context_processors.auth',
        #         'django.contrib.messages.context_processors.messages',
        #     ],
        # },
    },
]

WSGI_APPLICATION = 'login_linker.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

# DATABASES = {
#     'default': {
#         'ENGINE': 'django.db.backends.sqlite3',
#         'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
#     }
# }


# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

# STATIC_URL = '/static/'
