# encoding: utf-8
from __future__ import unicode_literals

from django.conf import settings
from django.shortcuts import redirect
from django.shortcuts import render

from django_yauth.decorators import yalogin_required

from login_linker.controller import OAuthController
from login_linker import exceptions


@yalogin_required
def begin(request, int_login):
    observer_uid = request.yauser.uid
    controller = OAuthController(
        observer_uid=observer_uid, int_login=int_login
    )
    return redirect(controller.redirect_url)


def split_int_login(int_login):
    is_staff = False
    if int_login.startswith('*'):
        int_login = int_login.strip('*')
        is_staff = True
    return is_staff, int_login


@yalogin_required
def unlink(request, int_login):
    observer_uid = request.yauser.uid

    is_staff, int_login = split_int_login(int_login)

    result = {
        'status': 200,
        'dictionary': {'text': 'Вы успешно отвязали логины.'},
    }

    try:
        OAuthController(
            observer_uid=observer_uid, int_login=int_login
        ).unlink()
    except exceptions.StaffInvalidInternalLogin:
        result = {
            'status': 400,
            'dictionary': {'text': 'Указанный внутренний логин не найден.'},
        }
    except exceptions.StaffForbidden:
        result = {
            'status': 403,
            'dictionary': {'text': 'У вас недостаточно прав для этой операции.'},
        }
    except (exceptions.StaffError, exceptions.StaffInvalidApp):
        result = {
            'status': 500,
            'dictionary': {'text': 'Что-то пошло не так. Попробуйте повторить попытку позднее.'},
        }

    if is_staff:
        return redirect('%s/%s/' % (settings.STAFF_HOST, int_login))
    else:
        return render(request, 'page.html', **result)


@yalogin_required
def complete(request):
    observer_uid = request.yauser.uid
    int_login = request.GET.get('state')
    is_staff, int_login = split_int_login(int_login)
    controller = OAuthController(
        observer_uid=observer_uid, int_login=int_login
    )
    oauth_data = request.GET

    error_exceptions = (
        exceptions.StaffError,
        exceptions.StaffInvalidApp,
        exceptions.OAuthException,
        exceptions.StaffInvalidInternalLogin,
    )

    result = {
        'status': 200,
        'context': {'text': 'Вы успешно связали логины.'},
    }

    try:
        controller.process_complete(oauth_data)
    except exceptions.StaffInvalidInternalLogin:
        result = {
            'status': 400,
            'context': {'text': 'Указанный внутренний логин не найден.'},
        }
    except exceptions.StaffForbidden:
        result = {
            'status': 403,
            'context': {'text': 'У вас недостаточно прав для этой операции.'},
        }
    except error_exceptions:
        result = {
            'status': 500,
            'context': {'text': 'Что-то пошло не так. Попробуйте повторить попытку позднее.'},
        }

    if is_staff:
        return redirect('%s/%s/' % (settings.STAFF_HOST, int_login))
    else:
        return render(request, 'page.html', **result)
