var BEMHTML;

(function(global) {
    function buildBemXjst(__bem_xjst_libs__) {
        var exports = {};

        /// -------------------------------------
/// --------- BEM-XJST Runtime Start ----
/// -------------------------------------
var BEMHTML = function(module, exports) {
(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.bemhtml = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
var inherits = require('inherits');
var Match = require('../bemxjst/match').Match;
var BemxjstEntity = require('../bemxjst/entity').Entity;

/**
 * @class Entity
 * @param {BEMXJST} bemxjst
 * @param {String} block
 * @param {String} elem
 * @param {Array} templates
 */
function Entity(bemxjst) {
  this.bemxjst = bemxjst;

  this.jsClass = null;

  // "Fast modes"
  this.tag = new Match(this, 'tag');
  this.attrs = new Match(this, 'attrs');
  this.mod = new Match(this);
  this.js = new Match(this, 'js');
  this.mix = new Match(this, 'mix');
  this.bem = new Match(this, 'bem');
  this.cls = new Match(this, 'cls');

  BemxjstEntity.apply(this, arguments);
}

inherits(Entity, BemxjstEntity);
exports.Entity = Entity;

Entity.prototype.init = function init(block, elem) {
  this.block = block;
  this.elem = elem;

  // Class for jsParams
  this.jsClass = this.bemxjst.classBuilder.build(this.block, this.elem);
};

Entity.prototype._initRest = function _initRest(key) {
  if (key === 'default') {
    this.rest[key] = this.def;
  } else if (key === 'tag' ||
    key === 'attrs' ||
    key === 'js' ||
    key === 'mix' ||
    key === 'bem' ||
    key === 'cls' ||
    key === 'content') {
    this.rest[key] = this[key];
  } else {
    if (!this.rest.hasOwnProperty(key))
      this.rest[key] = new Match(this, key);
  }
};

Entity.prototype.defaultBody = function defaultBody(context) {
  var tag = this.tag.exec(context);

  var js;
  if (context.ctx.js !== false)
    js = this.js.exec(context);

  var bem = this.bem.exec(context);
  var cls = this.cls.exec(context);
  var mix = this.mix.exec(context);
  var attrs = this.attrs.exec(context);
  var content = this.content.exec(context);

  return this.bemxjst.render(context,
                             this,
                             tag,
                             js,
                             bem,
                             cls,
                             mix,
                             attrs,
                             content);
};

},{"../bemxjst/entity":5,"../bemxjst/match":8,"inherits":11}],2:[function(require,module,exports){
var inherits = require('inherits');
var utils = require('../bemxjst/utils');
var Entity = require('./entity').Entity;
var BEMXJST = require('../bemxjst');

function BEMHTML(options) {
  BEMXJST.apply(this, arguments);

  var xhtml = typeof options.xhtml === 'undefined' ? true : options.xhtml;
  this._shortTagCloser = xhtml ? '/>' : '>';

  this._elemJsInstances = options.elemJsInstances;
}

inherits(BEMHTML, BEMXJST);
module.exports = BEMHTML;

BEMHTML.prototype.Entity = Entity;

BEMHTML.prototype.runMany = function runMany(arr) {
  var out = '';
  var context = this.context;
  var prevPos = context.position;
  var prevNotNewList = context._notNewList;

  if (prevNotNewList) {
    context._listLength += arr.length - 1;
  } else {
    context.position = 0;
    context._listLength = arr.length;
  }
  context._notNewList = true;

  if (this.canFlush) {
    for (var i = 0; i < arr.length; i++)
      out += context._flush(this._run(arr[i]));
  } else {
    for (var i = 0; i < arr.length; i++)
      out += this._run(arr[i]);
  }

  if (!prevNotNewList)
    context.position = prevPos;

  return out;
};

BEMHTML.prototype.render = function render(context,
                                           entity,
                                           tag,
                                           js,
                                           bem,
                                           cls,
                                           mix,
                                           attrs,
                                           content) {
  var ctx = context.ctx;

  if (tag === undefined)
    tag = 'div';

  if (!tag)
    return this.renderNoTag(context, js, bem, cls, mix, attrs, content);

  var out = '<' + tag;

  var ctxJS = ctx.js;
  if (ctxJS !== false) {
    if (js === true)
      js = {};

    if (js && js !== ctx.js) {
      if (ctxJS !== true)
        js = utils.extend(ctxJS, js);
    }  else if (ctxJS === true) {
      js = {};
    }
  }

  var jsParams;
  if (js) {
    jsParams = {};
    jsParams[entity.jsClass] = js;
  }

  var isBEM = bem;
  if (isBEM === undefined) {
    if (ctx.bem === undefined)
      isBEM = entity.block || entity.elem;
    else
      isBEM = ctx.bem;
  }
  isBEM = !!isBEM;

  if (cls === undefined)
    cls = ctx.cls;

  var addJSInitClass = jsParams && (
    this._elemJsInstances ?
      (entity.block || entity.elem) :
      (entity.block && !entity.elem)
  );

  if (!isBEM && !cls) {
    return this.renderClose(out, context, tag, attrs, isBEM, ctx, content);
  }

  out += ' class="';
  if (isBEM) {
    var mods = entity.elem ? context.elemMods : context.mods;

    out += entity.jsClass;
    out += this.buildModsClasses(entity.block, entity.elem, mods);

    if (ctx.mix && mix && mix !== ctx.mix)
      mix = [].concat(mix, ctx.mix);

    if (mix) {
      var m = this.renderMix(entity, mix, jsParams, addJSInitClass);
      out += m.out;
      jsParams = m.jsParams;
      addJSInitClass = m.addJSInitClass;
    }

    if (cls)
      out += ' ' + (typeof cls === 'string' ?
                    utils.attrEscape(cls).trim() : cls);
  } else {
    if (cls)
      out += cls.trim ? utils.attrEscape(cls).trim() : cls;
  }

  if (addJSInitClass)
    out += ' i-bem"';
  else
    out += '"';

  if (isBEM && jsParams)
    out += ' data-bem=\'' + utils.jsAttrEscape(JSON.stringify(jsParams)) + '\'';

  return this.renderClose(out, context, tag, attrs, isBEM, ctx, content);
};

BEMHTML.prototype.renderClose = function renderClose(prefix,
                                                     context,
                                                     tag,
                                                     attrs,
                                                     isBEM,
                                                     ctx,
                                                     content) {
  var out = prefix;
  var isObj = function isObj(val) {
    return val && typeof val === 'object' && !Array.isArray(val) &&
      val !== null;
  };

  // NOTE: maybe we need to make an array for quicker serialization
  if (isObj(attrs) || isObj(ctx.attrs)) {
    attrs = utils.extend(attrs, ctx.attrs);

    /* jshint forin : false */
    for (var name in attrs) {
      var attr = attrs[name];
      if (attr === undefined || attr === false || attr === null)
        continue;

      if (attr === true)
        out += ' ' + name;
      else
        out += ' ' + name + '="' +
          utils.attrEscape(utils.isSimple(attr) ?
                           attr :
                           this.context.reapply(attr)) +
                           '"';
    }
  }

  if (utils.isShortTag(tag)) {
    out += this._shortTagCloser;
    if (this.canFlush)
      out = context._flush(out);
  } else {
    out += '>';
    if (this.canFlush)
      out = context._flush(out);

    // TODO(indutny): skip apply next flags
    if (content || content === 0)
      out += this.renderContent(content, isBEM);

    out += '</' + tag + '>';
  }

  if (this.canFlush)
    out = context._flush(out);
  return out;
};

BEMHTML.prototype.renderMix = function renderMix(entity,
                                                 mix,
                                                 jsParams,
                                                 addJSInitClass) {
  var visited = {};
  var context = this.context;
  var js = jsParams;
  var addInit = addJSInitClass;

  visited[entity.jsClass] = true;

  // Transform mix to the single-item array if it's not array
  if (!utils.isArray(mix))
    mix = [ mix ];

  var classBuilder = this.classBuilder;

  var out = '';
  for (var i = 0; i < mix.length; i++) {
    var item = mix[i];
    if (!item)
      continue;
    if (typeof item === 'string')
      item = { block: item, elem: undefined };

    var hasItem = false;

    if (item.elem) {
      hasItem = item.elem !== entity.elem && item.elem !== context.elem ||
        item.block && item.block !== entity.block;
    } else if (item.block) {
      hasItem = !(item.block === entity.block && item.mods) ||
        item.mods && entity.elem;
    }

    var block = item.block || item._block || context.block;
    var elem = item.elem || item._elem || context.elem;
    var key = classBuilder.build(block, elem);

    var classElem = item.elem ||
                    item._elem ||
                    (item.block ? undefined : context.elem);
    if (hasItem)
      out += ' ' + classBuilder.build(block, classElem);

    out += this.buildModsClasses(block, classElem,
      (item.elem || !item.block && (item._elem || context.elem)) ?
        item.elemMods : item.mods);

    if (item.js) {
      if (!js)
        js = {};

      js[classBuilder.build(block, item.elem)] =
          item.js === true ? {} : item.js;
      if (!addInit)
        addInit = block && !item.elem;
    }

    // Process nested mixes
    if (!hasItem || visited[key])
      continue;

    visited[key] = true;
    var nestedEntity = this.entities[key];
    if (!nestedEntity)
      continue;

    var oldBlock = context.block;
    var oldElem = context.elem;
    var nestedMix = nestedEntity.mix.exec(context);
    context.elem = oldElem;
    context.block = oldBlock;

    if (!nestedMix)
      continue;

    for (var j = 0; j < nestedMix.length; j++) {
      var nestedItem = nestedMix[j];
      if (!nestedItem) continue;

      if (!nestedItem.block &&
          !nestedItem.elem ||
          !visited[classBuilder.build(nestedItem.block, nestedItem.elem)]) {
        if (nestedItem.block) continue;

        nestedItem._block = block;
        nestedItem._elem = elem;
        mix = mix.slice(0, i + 1).concat(
          nestedItem,
          mix.slice(i + 1)
        );
      }
    }
  }

  return {
    out: out,
    jsParams: js,
    addJSInitClass: addInit
  };
};

BEMHTML.prototype.buildModsClasses = function buildModsClasses(block,
                                                               elem,
                                                               mods) {
  if (!mods)
    return '';

  var res = '';

  var modName;

  /*jshint -W089 */
  for (modName in mods) {
    if (!mods.hasOwnProperty(modName) || modName === '')
      continue;

    var modVal = mods[modName];
    if (!modVal && modVal !== 0) continue;
    if (typeof modVal !== 'boolean')
      modVal += '';

    var builder = this.classBuilder;
    res += ' ' + (elem ?
                  builder.buildElemClass(block, elem, modName, modVal) :
                  builder.buildBlockClass(block, modName, modVal));
  }

  return res;
};

BEMHTML.prototype.renderNoTag = function renderNoTag(context,
                                                     js,
                                                     bem,
                                                     cls,
                                                     mix,
                                                     attrs,
                                                     content) {

  // TODO(indutny): skip apply next flags
  if (content || content === 0)
    return this._run(content);
  return '';
};

},{"../bemxjst":7,"../bemxjst/utils":10,"./entity":1,"inherits":11}],3:[function(require,module,exports){
function ClassBuilder(options) {
  this.modDelim = options.mod || '_';
  this.elemDelim = options.elem || '__';
}
exports.ClassBuilder = ClassBuilder;

ClassBuilder.prototype.build = function build(block, elem) {
  if (!elem)
    return block;
  else
    return block + this.elemDelim + elem;
};

ClassBuilder.prototype.buildModPostfix = function buildModPostfix(modName,
                                                                  modVal) {
  var res = this.modDelim + modName;
  if (modVal !== true) res += this.modDelim + modVal;
  return res;
};

ClassBuilder.prototype.buildBlockClass = function buildBlockClass(name,
                                                                  modName,
                                                                  modVal) {
  var res = name;
  if (modVal) res += this.buildModPostfix(modName, modVal);
  return res;
};

ClassBuilder.prototype.buildElemClass = function buildElemClass(block,
                                                                name,
                                                                modName,
                                                                modVal) {
  var res = this.buildBlockClass(block) + this.elemDelim + name;
  if (modVal) res += this.buildModPostfix(modName, modVal);
  return res;
};

ClassBuilder.prototype.split = function split(key) {
  return key.split(this.elemDelim, 2);
};

},{}],4:[function(require,module,exports){
var utils = require('./utils');

function Context(bemxjst) {
  this._bemxjst = bemxjst;

  this.ctx = null;
  this.block = '';

  // Save current block until the next BEM entity
  this._currBlock = '';

  this.elem = null;
  this.mods = {};
  this.elemMods = {};

  this.position = 0;
  this._listLength = 0;
  this._notNewList = false;

  // (miripiruni) this will be changed in next major release
  this.escapeContent = bemxjst.options.escapeContent === true;

  // Used in `OnceMatch` check to detect context change
  this._onceRef = {};
}
exports.Context = Context;

Context.prototype._flush = null;
Context.prototype.isArray = utils.isArray;

Context.prototype.isSimple = utils.isSimple;

Context.prototype.isShortTag = utils.isShortTag;
Context.prototype.extend = utils.extend;
Context.prototype.identify = utils.identify;

Context.prototype.xmlEscape = utils.xmlEscape;
Context.prototype.attrEscape = utils.attrEscape;
Context.prototype.jsAttrEscape = utils.jsAttrEscape;

Context.prototype.isFirst = function isFirst() {
  return this.position === 1;
};

Context.prototype.isLast = function isLast() {
  return this.position === this._listLength;
};

Context.prototype.generateId = function generateId() {
  return utils.identify(this.ctx);
};

Context.prototype.reapply = function reapply(ctx) {
  return this._bemxjst.run(ctx);
};

},{"./utils":10}],5:[function(require,module,exports){
var utils = require('./utils');
var Match = require('./match').Match;
var tree = require('./tree');
var Template = tree.Template;
var PropertyMatch = tree.PropertyMatch;
var CompilerOptions = tree.CompilerOptions;

function Entity(bemxjst, block, elem, templates) {
  this.bemxjst = bemxjst;

  this.block = null;
  this.elem = null;

  // Compiler options via `xjstOptions()`
  this.options = {};

  // `true` if entity has just a default renderer for `def()` mode
  this.canFlush = true;

  // "Fast modes"
  this.def = new Match(this);
  this.content = new Match(this, 'content');

  // "Slow modes"
  this.rest = {};

  // Initialize
  this.init(block, elem);
  this.initModes(templates);
}
exports.Entity = Entity;

Entity.prototype.init = function init(block, elem) {
  this.block = block;
  this.elem = elem;
};

function contentMode() {
  return this.ctx.content;
}

Entity.prototype.initModes = function initModes(templates) {
  /* jshint maxdepth : false */
  for (var i = 0; i < templates.length; i++) {
    var template = templates[i];

    for (var j = template.predicates.length - 1; j >= 0; j--) {
      var pred = template.predicates[j];
      if (!(pred instanceof PropertyMatch))
        continue;

      if (pred.key !== '_mode')
        continue;

      template.predicates.splice(j, 1);
      this._initRest(pred.value);

      // All templates should go there anyway
      this.rest[pred.value].push(template);
      break;
    }

    if (j === -1)
      this.def.push(template);

    // Merge compiler options
    for (var j = template.predicates.length - 1; j >= 0; j--) {
      var pred = template.predicates[j];
      if (!(pred instanceof CompilerOptions))
        continue;

      this.options = utils.extend(this.options, pred.options);
    }
  }
};

Entity.prototype.prepend = function prepend(other) {
  // Prepend to the slow modes, fast modes are in this hashmap too anyway
  var keys = Object.keys(this.rest);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!other.rest[key])
      continue;

    this.rest[key].prepend(other.rest[key]);
  }

  // Add new slow modes
  keys = Object.keys(other.rest);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (this.rest[key])
      continue;

    this._initRest(key);
    this.rest[key].prepend(other.rest[key]);
  }
};

// NOTE: This could be potentially compiled into inlined invokations
Entity.prototype.run = function run(context) {
  if (this.def.count !== 0)
    return this.def.exec(context);

  return this.defaultBody(context);
};

Entity.prototype.setDefaults = function setDefaults() {
  // Default .content() template for applyNext()
  if (this.content.count !== 0)
    this.content.push(new Template([], contentMode));

  // .def() default
  if (this.def.count !== 0) {
    this.canFlush = this.options.flush || false;
    var self = this;
    this.def.push(new Template([], function defaultBodyProxy() {
      return self.defaultBody(this);
    }));
  }
};

},{"./match":8,"./tree":9,"./utils":10}],6:[function(require,module,exports){
function BEMXJSTError(msg, func) {
  this.name = 'BEMXJSTError';
  this.message = msg;

  if (Error.captureStackTrace)
    Error.captureStackTrace(this, func || this.constructor);
  else
    this.stack = (new Error()).stack;
}

BEMXJSTError.prototype = Object.create(Error.prototype);
BEMXJSTError.prototype.constructor = BEMXJSTError;

exports.BEMXJSTError = BEMXJSTError;

},{}],7:[function(require,module,exports){
var inherits = require('inherits');

var Tree = require('./tree').Tree;
var PropertyMatch = require('./tree').PropertyMatch;
var Context = require('./context').Context;
var ClassBuilder = require('./class-builder').ClassBuilder;
var utils = require('./utils');

function BEMXJST(options) {
  this.options = options || {};

  this.entities = null;
  this.defaultEnt = null;

  // Current tree
  this.tree = null;

  // Current match
  this.match = null;

  // Create new Context constructor for overriding prototype
  this.contextConstructor = function ContextChild(bemxjst) {
    Context.call(this, bemxjst);
  };
  inherits(this.contextConstructor, Context);
  this.context = null;

  this.classBuilder = new ClassBuilder(this.options.naming || {});

  // Execution depth, used to invalidate `applyNext` bitfields
  this.depth = 0;

  // Do not call `_flush` on overridden `def()` mode
  this.canFlush = false;

  // oninit templates
  this.oninit = null;

  // Initialize default entity (no block/elem match)
  this.defaultEnt = new this.Entity(this, '', '', []);
  this.defaultElemEnt = new this.Entity(this, '', '', []);
}
module.exports = BEMXJST;

BEMXJST.prototype.locals = Tree.methods
    .concat('local', 'applyCtx', 'applyNext', 'apply');

BEMXJST.prototype.compile = function compile(code) {
  var self = this;

  function applyCtx() {
    return self._run(self.context.ctx);
  }

  function applyCtxWrap(ctx, changes) {
    // Fast case
    if (!changes)
      return self.local({ ctx: ctx }, applyCtx);

    return self.local(changes, function() {
      return self.local({ ctx: ctx }, applyCtx);
    });
  }

  function apply(mode, changes) {
    return self.applyMode(mode, changes);
  }

  function localWrap(changes) {
    return function localBody(body) {
      return self.local(changes, body);
    };
  }

  var tree = new Tree({
    refs: {
      applyCtx: applyCtxWrap,
      local: localWrap
    }
  });

  // Yeah, let people pass functions to us!
  var templates = this.recompileInput(code);

  var out = tree.build(templates, [
    localWrap,
    applyCtxWrap,
    function applyNextWrap(changes) {
      if (changes)
        return self.local(changes, applyNextWrap);
      return self.applyNext();
    },
    apply
  ]);

  // Concatenate templates with existing ones
  // TODO(indutny): it should be possible to incrementally add templates
  if (this.tree) {
    out = {
      templates: out.templates.concat(this.tree.templates),
      oninit: this.tree.oninit.concat(out.oninit)
    };
  }
  this.tree = out;

  // Group block+elem entities into a hashmap
  var ent = this.groupEntities(out.templates);

  // Transform entities from arrays to Entity instances
  ent = this.transformEntities(ent);

  this.entities = ent;
  this.oninit = out.oninit;
};

BEMXJST.prototype.recompileInput = function recompileInput(code) {
  var args = BEMXJST.prototype.locals;
  // Reuse function if it already has right arguments
  if (typeof code === 'function' && code.length === args.length)
    return code;

  var out = code.toString();

  // Strip the function
  out = out.replace(/^function[^{]+{|}$/g, '');

  // And recompile it with right arguments
  out = new Function(args.join(', '), out);

  return out;
};

BEMXJST.prototype.groupEntities = function groupEntities(tree) {
  var res = {};
  for (var i = 0; i < tree.length; i++) {
    // Make sure to change only the copy, the original is cached in `this.tree`
    var template = tree[i].clone();
    var block = null;
    var elem;

    elem = undefined;
    for (var j = 0; j < template.predicates.length; j++) {
      var pred = template.predicates[j];
      if (!(pred instanceof PropertyMatch))
        continue;

      if (pred.key === 'block')
        block = pred.value;
      else if (pred.key === 'elem')
        elem = pred.value;
      else
        continue;

      // Remove predicate, we won't much against it
      template.predicates.splice(j, 1);
      j--;
    }

    if (block === null) {
      var msg = 'block(…) subpredicate is not found.\n' +
      '    See template with subpredicates:\n     * ';

      for (var j = 0; j < template.predicates.length; j++) {
        var pred = template.predicates[j];

        if (j !== 0)
          msg += '\n     * ';

        if (pred.key === '_mode') {
          msg += pred.value + '()';
        } else {
          if (Array.isArray(pred.key)) {
            msg += pred.key[0].replace('mods', 'mod')
              .replace('elemMods', 'elemMod') +
              '(\'' + pred.key[1] + '\', \'' + pred.value + '\')';
          } else if (!pred.value || !pred.key) {
            msg += 'match(…)';
          } else {
            msg += pred.key + '(\'' + pred.value + '\')';
          }
        }
      }

      msg += '\n    And template body: \n    (' +
        (typeof template.body === 'function' ?
          template.body :
          JSON.stringify(template.body)) + ')';

      if (typeof BEMXJSTError === 'undefined') {
        BEMXJSTError = require('./error').BEMXJSTError;
      }

      throw new BEMXJSTError(msg);
    }

    var key = this.classBuilder.build(block, elem);

    if (!res[key])
      res[key] = [];
    res[key].push(template);
  }
  return res;
};

BEMXJST.prototype.transformEntities = function transformEntities(entities) {
  var wildcardElems = [];

  var keys = Object.keys(entities);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];

    // TODO(indutny): pass this values over
    var parts = this.classBuilder.split(key);
    var block = parts[0];
    var elem = parts[1];

    if (elem === '*')
      wildcardElems.push(block);

    entities[key] = new this.Entity(
      this, block, elem, entities[key]);
  }

  // Merge wildcard block templates
  if (entities.hasOwnProperty('*')) {
    var wildcard = entities['*'];
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      if (key === '*')
        continue;

      entities[key].prepend(wildcard);
    }
    this.defaultEnt.prepend(wildcard);
    this.defaultElemEnt.prepend(wildcard);
  }

  // Merge wildcard elem templates
  for (var i = 0; i < wildcardElems.length; i++) {
    var block = wildcardElems[i];
    var wildcardKey = this.classBuilder.build(block, '*');
    var wildcard = entities[wildcardKey];
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      if (key === wildcardKey)
        continue;

      var entity = entities[key];
      if (entity.block !== block)
        continue;

      if (entity.elem === undefined)
        continue;

      entities[key].prepend(wildcard);
    }
    this.defaultElemEnt.prepend(wildcard);
  }

  // Set default templates after merging with wildcard
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    entities[key].setDefaults();
    this.defaultEnt.setDefaults();
    this.defaultElemEnt.setDefaults();
  }

  return entities;
};

BEMXJST.prototype._run = function _run(context) {
  var res;
  if (context === undefined || context === '' || context === null)
    res = this.runEmpty();
  else if (utils.isArray(context))
    res = this.runMany(context);
  else if (
    context.html &&
    typeof context.html === 'string' &&
    !context.tag &&
    typeof context.block === 'undefined' &&
    typeof context.elem === 'undefined' &&
    typeof context.cls === 'undefined' &&
    typeof context.attrs === 'undefined'
  )
    res = this.runUnescaped(context.html);
  else if (utils.isSimple(context))
    res = this.runSimple(context);
  else
    res = this.runOne(context);
  return res;
};

BEMXJST.prototype.run = function run(json) {
  var match = this.match;
  var context = this.context;

  this.match = null;
  this.context = new this.contextConstructor(this);
  this.canFlush = this.context._flush !== null;
  this.depth = 0;
  var res = this._run(json);

  if (this.canFlush)
    res = this.context._flush(res);

  this.match = match;
  this.context = context;

  return res;
};


BEMXJST.prototype.runEmpty = function runEmpty() {
  this.context._listLength--;
  return '';
};

BEMXJST.prototype.runUnescaped = function runUnescaped(context) {
  this.context._listLength--;
  return '' + context;
};

BEMXJST.prototype.runSimple = function runSimple(simple) {
  this.context._listLength--;
  var res = '';
  if (simple && simple !== true || simple === 0) {
    res += typeof simple === 'string' && this.context.escapeContent ?
      utils.xmlEscape(simple) :
      simple;
  }
  return res;
};

BEMXJST.prototype.runOne = function runOne(json) {
  var context = this.context;

  var oldCtx = context.ctx;
  var oldBlock = context.block;
  var oldCurrBlock = context._currBlock;
  var oldElem = context.elem;
  var oldMods = context.mods;
  var oldElemMods = context.elemMods;

  if (json.block || json.elem)
    context._currBlock = '';
  else
    context._currBlock = context.block;

  context.ctx = json;
  if (json.block) {
    context.block = json.block;

    if (json.mods)
      context.mods = json.mods;
    else if (json.block !== oldBlock || !json.elem)
      context.mods = {};
  } else {
    if (!json.elem)
      context.block = '';
    else if (oldCurrBlock)
      context.block = oldCurrBlock;
  }

  context.elem = json.elem;
  if (json.elemMods)
    context.elemMods = json.elemMods;
  else
    context.elemMods = {};

  var block = context.block || '';
  var elem = context.elem;

  // Control list position
  if (block || elem)
    context.position++;
  else
    context._listLength--;

  // To invalidate `applyNext` flags
  this.depth++;

  var key = this.classBuilder.build(block, elem);

  var restoreFlush = false;
  var ent = this.entities[key];
  if (ent) {
    if (this.canFlush && !ent.canFlush) {
      // Entity does not support flushing, do not flush anything nested
      restoreFlush = true;
      this.canFlush = false;
    }
  } else {
    // No entity - use default one
    ent = this.defaultEnt;
    if (elem !== undefined)
      ent = this.defaultElemEnt;
    ent.init(block, elem);
  }

  var res = ent.run(context);
  context.ctx = oldCtx;
  context.block = oldBlock;
  context.elem = oldElem;
  context.mods = oldMods;
  context.elemMods = oldElemMods;
  context._currBlock = oldCurrBlock;
  this.depth--;
  if (restoreFlush)
    this.canFlush = true;

  return res;
};

BEMXJST.prototype.renderContent = function renderContent(content, isBEM) {
  var context = this.context;
  var oldPos = context.position;
  var oldListLength = context._listLength;
  var oldNotNewList = context._notNewList;

  context._notNewList = false;
  if (isBEM) {
    context.position = 0;
    context._listLength = 1;
  }

  var res = this._run(content);

  context.position = oldPos;
  context._listLength = oldListLength;
  context._notNewList = oldNotNewList;

  return res;
};

BEMXJST.prototype.local = function local(changes, body) {
  var keys = Object.keys(changes);
  var restore = [];
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var parts = key.split('.');

    var value = this.context;
    for (var j = 0; j < parts.length - 1; j++)
      value = value[parts[j]];

    restore.push({
      parts: parts,
      value: value[parts[j]]
    });
    value[parts[j]] = changes[key];
  }

  var res = body.call(this.context);

  for (var i = 0; i < restore.length; i++) {
    var parts = restore[i].parts;
    var value = this.context;
    for (var j = 0; j < parts.length - 1; j++)
      value = value[parts[j]];

    value[parts[j]] = restore[i].value;
  }

  return res;
};

BEMXJST.prototype.applyNext = function applyNext() {
  return this.match.exec(this.context);
};

BEMXJST.prototype.applyMode = function applyMode(mode, changes) {
  var match = this.match.entity.rest[mode];
  if (!match)
    return this.context.ctx[mode];

  if (!changes)
    return match.exec(this.context);

  var self = this;

  // Allocate function this way, to prevent allocation at the top of the
  // `applyMode`
  var fn = function localBody() {
    return match.exec(self.context);
  };
  return this.local(changes, fn);
};

BEMXJST.prototype.exportApply = function exportApply(exports) {
  var self = this;
  exports.apply = function apply(context) {
    return self.run(context);
  };

  // Add templates at run time
  exports.compile = function compile(templates) {
    return self.compile(templates);
  };

  var sharedContext = {};

  exports.BEMContext = this.contextConstructor;
  sharedContext.BEMContext = exports.BEMContext;

  for (var i = 0; i < this.oninit.length; i++) {
    var oninit = this.oninit[i];

    oninit(exports, sharedContext);
  }
};

},{"./class-builder":3,"./context":4,"./error":6,"./tree":9,"./utils":10,"inherits":11}],8:[function(require,module,exports){
var utils = require('./utils');
var tree = require('./tree');
var PropertyMatch = tree.PropertyMatch;
var OnceMatch = tree.OnceMatch;
var WrapMatch = tree.WrapMatch;
var PropertyAbsent = tree.PropertyAbsent;
var CustomMatch = tree.CustomMatch;

function MatchProperty(template, pred) {
  this.template = template;
  this.key = pred.key;
  this.value = pred.value;
}

MatchProperty.prototype.exec = function exec(context) {
  return context[this.key] === this.value;
};

function MatchNested(template, pred) {
  this.template = template;
  this.keys = pred.key;
  this.value = pred.value;
}

MatchNested.prototype.exec = function exec(context) {
  var val = context;
  for (var i = 0; i < this.keys.length - 1; i++) {
    val = val[this.keys[i]];
    if (!val)
      return false;
  }

  return val[this.keys[i]] === this.value;
};

function MatchAbsent(template, pred) {
  this.template = template;
  this.key = pred.key;
}

MatchAbsent.prototype.exec = function exec(context) {
  return !context[this.key];
};

function MatchCustom(template, pred) {
  this.template = template;
  this.body = pred.body;
}

MatchCustom.prototype.exec = function exec(context) {
  return this.body.call(context, context, context.ctx);
};

function MatchOnce(template) {
  this.template = template;
  this.once = null;
}

MatchOnce.prototype.exec = function exec(context) {
  var res = this.once !== context._onceRef;
  this.once = context._onceRef;
  return res;
};

function MatchWrap(template) {
  this.template = template;
  this.wrap = null;
}

MatchWrap.prototype.exec = function exec(context) {
  var res = this.wrap !== context.ctx;
  this.wrap = context.ctx;
  return res;
};

function MatchTemplate(mode, template) {
  this.mode = mode;
  this.predicates = new Array(template.predicates.length);
  this.body = template.body;

  var postpone = [];

  for (var i = 0, j = 0; i < this.predicates.length; i++, j++) {
    var pred = template.predicates[i];
    if (pred instanceof PropertyMatch) {
      if (utils.isArray(pred.key))
        this.predicates[j] = new MatchNested(this, pred);
      else
        this.predicates[j] = new MatchProperty(this, pred);
    } else if (pred instanceof PropertyAbsent) {
      this.predicates[j] = new MatchAbsent(this, pred);
    } else if (pred instanceof CustomMatch) {
      this.predicates[j] = new MatchCustom(this, pred);

      // Push OnceMatch and MatchWrap later, they should not be executed first.
      // Otherwise they will set flag too early, and body might not be executed
    } else if (pred instanceof OnceMatch) {
      j--;
      postpone.push(new MatchOnce(this));
    } else if (pred instanceof WrapMatch) {
      j--;
      postpone.push(new MatchWrap(this));
    } else {
      // Skip
      j--;
    }
  }

  // Insert late predicates
  for (var i = 0; i < postpone.length; i++, j++)
    this.predicates[j] = postpone[i];

  if (this.predicates.length !== j)
    this.predicates.length = j;
}
exports.MatchTemplate = MatchTemplate;

function Match(entity, modeName) {
  this.entity = entity;
  this.modeName = modeName;
  this.bemxjst = this.entity.bemxjst;
  this.templates = [];

  // applyNext mask
  this.mask = [ 0 ];

  // We are going to create copies of mask for nested `applyNext()`
  this.maskSize = 0;
  this.maskOffset = 0;

  this.count = 0;
  this.depth = -1;

  this.thrownError = null;
}
exports.Match = Match;

Match.prototype.clone = function clone(entity) {
  var res = new Match(entity, this.modeName);

  res.templates = this.templates.slice();
  res.mask = this.mask.slice();
  res.maskSize = this.maskSize;
  res.count = this.count;

  return res;
};

Match.prototype.prepend = function prepend(other) {
  this.templates = other.templates.concat(this.templates);
  this.count += other.count;

  while (Math.ceil(this.count / 31) > this.mask.length)
    this.mask.push(0);

  this.maskSize = this.mask.length;
};

Match.prototype.push = function push(template) {
  this.templates.push(new MatchTemplate(this, template));
  this.count++;

  if (Math.ceil(this.count / 31) > this.mask.length)
    this.mask.push(0);

  this.maskSize = this.mask.length;
};

Match.prototype.tryCatch = function tryCatch(fn, ctx) {
  try {
    return fn.call(ctx, ctx, ctx.ctx);
  } catch (e) {
    this.thrownError = e;
  }
};

Match.prototype.exec = function exec(context) {
  var save = this.checkDepth();

  var template;
  var bitIndex = this.maskOffset;
  var mask = this.mask[bitIndex];
  var bit = 1;
  for (var i = 0; i < this.count; i++) {
    if ((mask & bit) === 0) {
      template = this.templates[i];
      for (var j = 0; j < template.predicates.length; j++) {
        var pred = template.predicates[j];

        /* jshint maxdepth : false */
        if (!pred.exec(context))
          break;
      }

      // All predicates matched!
      if (j === template.predicates.length)
        break;
    }

    if (bit === 0x40000000) {
      bitIndex++;
      mask = this.mask[bitIndex];
      bit = 1;
    } else {
      bit <<= 1;
    }
  }

  if (i === this.count)
    return context.ctx[this.modeName];

  var oldMask = mask;
  var oldMatch = this.bemxjst.match;
  this.mask[bitIndex] |= bit;
  this.bemxjst.match = this;

  this.thrownError = null;

  var out;
  if (typeof template.body === 'function')
    out = this.tryCatch(template.body, context);
  else
    out = template.body;

  this.mask[bitIndex] = oldMask;
  this.bemxjst.match = oldMatch;
  this.restoreDepth(save);

  var e = this.thrownError;
  if (e !== null) {
    this.thrownError = null;
    throw e;
  }

  return out;
};

Match.prototype.checkDepth = function checkDepth() {
  if (this.depth === -1) {
    this.depth = this.bemxjst.depth;
    return -1;
  }

  if (this.bemxjst.depth === this.depth)
    return this.depth;

  var depth = this.depth;
  this.depth = this.bemxjst.depth;

  this.maskOffset += this.maskSize;

  while (this.mask.length < this.maskOffset + this.maskSize)
    this.mask.push(0);

  return depth;
};

Match.prototype.restoreDepth = function restoreDepth(depth) {
  if (depth !== -1 && depth !== this.depth)
    this.maskOffset -= this.maskSize;
  this.depth = depth;
};

},{"./tree":9,"./utils":10}],9:[function(require,module,exports){
var assert = require('minimalistic-assert');
var inherits = require('inherits');

function Template(predicates, body) {
  this.predicates = predicates;

  this.body = body;
}
exports.Template = Template;

Template.prototype.wrap = function wrap() {
  var body = this.body;
  for (var i = 0; i < this.predicates.length; i++) {
    var pred = this.predicates[i];
    body = pred.wrapBody(body);
  }
  this.body = body;
};

Template.prototype.clone = function clone() {
  return new Template(this.predicates.slice(), this.body);
};

function MatchBase() {
}
exports.MatchBase = MatchBase;

MatchBase.prototype.wrapBody = function wrapBody(body) {
  return body;
};

function Item(tree, children) {
  this.conditions = [];
  this.children = [];

  for (var i = children.length - 1; i >= 0; i--) {
    var arg = children[i];
    if (arg instanceof MatchBase)
      this.conditions.push(arg);
    else if (arg === tree.boundBody)
      this.children[i] = tree.queue.pop();
    else
      this.children[i] = arg;
  }
}

function OnceMatch() {
  MatchBase.call(this);
}
inherits(OnceMatch, MatchBase);
exports.OnceMatch = OnceMatch;

function WrapMatch(refs) {
  MatchBase.call(this);

  this.refs = refs;
}
inherits(WrapMatch, MatchBase);
exports.WrapMatch = WrapMatch;

WrapMatch.prototype.wrapBody = function wrapBody(body) {
  var applyCtx = this.refs.applyCtx;

  if (typeof body !== 'function') {
    return function inlineAdaptor() {
      return applyCtx(body);
    };
  }

  return function wrapAdaptor() {
    return applyCtx(body.call(this, this, this.ctx));
  };
};

function ReplaceMatch(refs) {
  MatchBase.call(this);

  this.refs = refs;
}
inherits(ReplaceMatch, MatchBase);
exports.ReplaceMatch = ReplaceMatch;

ReplaceMatch.prototype.wrapBody = function wrapBody(body) {
  var applyCtx = this.refs.applyCtx;

  if (typeof body !== 'function') {
    return function inlineAdaptor() {
      return applyCtx(body);
    };
  }

  return function replaceAdaptor() {
    return applyCtx(body.call(this, this, this.ctx));
  };
};

function ExtendMatch(refs) {
  MatchBase.call(this);

  this.refs = refs;
}
inherits(ExtendMatch, MatchBase);
exports.ExtendMatch = ExtendMatch;

ExtendMatch.prototype.wrapBody = function wrapBody(body) {
  var applyCtx = this.refs.applyCtx;
  var local = this.refs.local;

  if (typeof body !== 'function') {
    return function inlineAdaptor() {
      var changes = {};

      var keys = Object.keys(body);
      for (var i = 0; i < keys.length; i++)
        changes['ctx.' + keys[i]] = body[keys[i]];

      return local(changes)(function preApplyCtx() {
        return applyCtx(this.ctx);
      });
    };
  }

  return function localAdaptor() {
    var changes = {};

    var obj = body.call(this);
    var keys = Object.keys(obj);
    for (var i = 0; i < keys.length; i++)
      changes['ctx.' + keys[i]] = obj[keys[i]];

    return local(changes)(function preApplyCtx() {
      return applyCtx(this.ctx);
    });
  };
};

function CompilerOptions(options) {
  MatchBase.call(this);
  this.options = options;
}
inherits(CompilerOptions, MatchBase);
exports.CompilerOptions = CompilerOptions;

function PropertyMatch(key, value) {
  MatchBase.call(this);

  this.key = key;
  this.value = value;
}
inherits(PropertyMatch, MatchBase);
exports.PropertyMatch = PropertyMatch;

function PropertyAbsent(key) {
  MatchBase.call(this);

  this.key = key;
}
inherits(PropertyAbsent, MatchBase);
exports.PropertyAbsent = PropertyAbsent;

function CustomMatch(body) {
  MatchBase.call(this);

  this.body = body;
}
inherits(CustomMatch, MatchBase);
exports.CustomMatch = CustomMatch;

function Tree(options) {
  this.options = options;
  this.refs = this.options.refs;

  this.boundBody = this.body.bind(this);

  var methods = this.methods('body');
  for (var i = 0; i < methods.length; i++) {
    var method = methods[i];
    // NOTE: method.name is empty because of .bind()
    this.boundBody[Tree.methods[i]] = method;
  }

  this.queue = [];
  this.templates = [];
  this.initializers = [];
}
exports.Tree = Tree;

Tree.methods = [
  'match', 'once', 'wrap', 'block', 'elem', 'mode', 'mod',
  'elemMod', 'def', 'tag', 'attrs', 'cls', 'js',
  'bem', 'mix', 'content', 'replace', 'extend', 'oninit',
  'xjstOptions'
];

Tree.prototype.build = function build(templates, apply) {
  var methods = this.methods('global').concat(apply);
  methods[0] = this.match.bind(this);

  templates.apply({}, methods);

  return {
    templates: this.templates.slice().reverse(),
    oninit: this.initializers
  };
};

function methodFactory(self, kind, name) {
  var method = self[name];
  var boundBody = self.boundBody;

  if (kind !== 'body') {
    if (name === 'replace' || name === 'extend' || name === 'wrap') {
      return function wrapExtended() {
        return method.apply(self, arguments);
      };
    }

    return function wrapNotBody() {
      method.apply(self, arguments);
      return boundBody;
    };
  }

  return function wrapBody() {
    var res = method.apply(self, arguments);

    // Insert body into last item
    var child = self.queue.pop();
    var last = self.queue[self.queue.length - 1];
    last.conditions = last.conditions.concat(child.conditions);
    last.children = last.children.concat(child.children);

    if (name === 'replace' || name === 'extend' || name === 'wrap')
      return res;
    return boundBody;
  };
}

Tree.prototype.methods = function methods(kind) {
  var out = new Array(Tree.methods.length);

  for (var i = 0; i < out.length; i++) {
    var name = Tree.methods[i];
    out[i] = methodFactory(this, kind, name);
  }

  return out;
};

// Called after all matches
Tree.prototype.flush = function flush(conditions, item) {
  var subcond;

  if (item.conditions)
    subcond = conditions.concat(item.conditions);
  else
    subcond = item.conditions;

  for (var i = 0; i < item.children.length; i++) {
    var arg = item.children[i];

    // Go deeper
    if (arg instanceof Item) {
      this.flush(subcond, item.children[i]);

    // Body
    } else {
      var template = new Template(conditions, arg);
      template.wrap();
      this.templates.push(template);
    }
  }
};

Tree.prototype.body = function body() {
  var children = new Array(arguments.length);
  for (var i = 0; i < arguments.length; i++)
    children[i] = arguments[i];

  var child = new Item(this, children);
  this.queue[this.queue.length - 1].children.push(child);

  if (this.queue.length === 1)
    this.flush([], this.queue.shift());

  return this.boundBody;
};

Tree.prototype.match = function match() {
  var children = new Array(arguments.length);
  for (var i = 0; i < arguments.length; i++) {
    var arg = arguments[i];
    if (typeof arg === 'function')
      arg = new CustomMatch(arg);
    assert(arg instanceof MatchBase, 'Wrong .match() argument');
    children[i] = arg;
  }

  this.queue.push(new Item(this, children));

  return this.boundBody;
};

Tree.prototype.once = function once() {
  if (arguments.length)
    throw new Error('Predicate once() should not have arguments');
  return this.match(new OnceMatch());
};

Tree.prototype.applyMode = function applyMode(args, mode) {
  if (args.length) {
    throw new Error('Predicate should not have arguments but ' +
      JSON.stringify(args) + ' passed');
  }

  return this.mode(mode);
};

Tree.prototype.wrap = function wrap() {
  return this.def.apply(this, arguments).match(new WrapMatch(this.refs));
};

Tree.prototype.xjstOptions = function xjstOptions(options) {
  this.queue.push(new Item(this, [
    new CompilerOptions(options)
  ]));
  return this.boundBody;
};

Tree.prototype.block = function block(name) {
  return this.match(new PropertyMatch('block', name));
};

Tree.prototype.elem = function elem(name) {
  return this.match(new PropertyMatch('elem', name));
};

Tree.prototype.mode = function mode(name) {
  return this.match(new PropertyMatch('_mode', name));
};

Tree.prototype.mod = function mod(name, value) {
  return this.match(new PropertyMatch([ 'mods', name ], value));
};

Tree.prototype.elemMod = function elemMod(name, value) {
  return this.match(new PropertyMatch([ 'elemMods', name ], value));
};

Tree.prototype.def = function def() {
  return this.applyMode(arguments, 'default');
};

Tree.prototype.tag = function tag() {
  return this.applyMode(arguments, 'tag');
};

Tree.prototype.attrs = function attrs() {
  return this.applyMode(arguments, 'attrs');
};

Tree.prototype.cls = function cls() {
  return this.applyMode(arguments, 'cls');
};

Tree.prototype.js = function js() {
  return this.applyMode(arguments, 'js');
};

Tree.prototype.bem = function bem() {
  return this.applyMode(arguments, 'bem');
};

Tree.prototype.mix = function mix() {
  return this.applyMode(arguments, 'mix');
};

Tree.prototype.content = function content() {
  return this.applyMode(arguments, 'content');
};

Tree.prototype.replace = function replace() {
  return this.def.apply(this, arguments).match(new ReplaceMatch(this.refs));
};

Tree.prototype.extend = function extend() {
  return this.def.apply(this, arguments).match(new ExtendMatch(this.refs));
};

Tree.prototype.oninit = function oninit(fn) {
  this.initializers.push(fn);
};

},{"inherits":11,"minimalistic-assert":12}],10:[function(require,module,exports){
var toString = Object.prototype.toString;

exports.isArray = Array.isArray;
if (!exports.isArray) {
  exports.isArray = function isArrayPolyfill(obj) {
    return toString.call(obj) === '[object Array]';
  };
}

exports.xmlEscape = function(str) {
  return (str + '')
    .replace(/&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;');
};
exports.attrEscape = function(str) {
  return (str + '')
    .replace(/&/g, '&amp;')
    .replace(/"/g, '&quot;');
};
exports.jsAttrEscape = function(str) {
  return (str + '')
    .replace(/&/g, '&amp;')
    .replace(/'/g, '&#39;');
};

exports.extend = function extend(o1, o2) {
  if (!o1 || !o2)
    return o1 || o2;

  var res = {};
  var n;

  for (n in o1)
    if (o1.hasOwnProperty(n))
      res[n] = o1[n];
  for (n in o2)
    if (o2.hasOwnProperty(n))
      res[n] = o2[n];
  return res;
};

var SHORT_TAGS = { // хэш для быстрого определения, является ли тэг коротким
  area: 1, base: 1, br: 1, col: 1, command: 1, embed: 1, hr: 1, img: 1,
  input: 1, keygen: 1, link: 1, meta: 1, param: 1, source: 1, wbr: 1
};

exports.isShortTag = function isShortTag(t) {
  return SHORT_TAGS.hasOwnProperty(t);
};

exports.isSimple = function isSimple(obj) {
  if (!obj || obj === true) return true;
  if (!obj.block &&
      !obj.elem &&
      !obj.tag &&
      !obj.cls &&
      !obj.attrs &&
      obj.hasOwnProperty('html') &&
      isSimple(obj.html))
  return true;
  return typeof obj === 'string' || typeof obj === 'number';
};

var uniqCount = 0;
var uniqId = +new Date();
var uniqExpando = '__' + uniqId;
var uniqPrefix = 'uniq' + uniqId;

function getUniq() {
  return uniqPrefix + (++uniqCount);
}
exports.getUniq = getUniq;

exports.identify = function identify(obj, onlyGet) {
  if (!obj)
    return getUniq();
  if (onlyGet || obj[uniqExpando])
    return obj[uniqExpando];

  var u = getUniq();
  obj[uniqExpando] = u;
  return u;
};

},{}],11:[function(require,module,exports){
if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}

},{}],12:[function(require,module,exports){
module.exports = assert;

function assert(val, msg) {
  if (!val)
    throw new Error(msg || 'Assertion failed');
}

assert.equal = function assertEqual(l, r, msg) {
  if (l != r)
    throw new Error(msg || ('Assertion failed: ' + l + ' != ' + r));
};

},{}]},{},[2])(2)
});;
  return module.exports ||
      exports.BEMHTML;
}({}, {});
/// -------------------------------------
/// --------- BEM-XJST Runtime End ------
/// -------------------------------------

var api = new BEMHTML({});
/// -------------------------------------
/// ------ BEM-XJST User-code Start -----
/// -------------------------------------
api.compile(function(match, once, wrap, block, elem, mode, mod, elemMod, def, tag, attrs, cls, js, bem, mix, content, replace, extend, oninit, xjstOptions, local, applyCtx, applyNext, apply) {
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/__link/b-page__link.bemhtml.js */
block('b-page').elem('link')(
    bem()(false),

    tag()('link'),

    attrs()(function() {
        return {
            rel: this.ctx.rel,
            type: this.ctx.type,
            href: this.ctx.url,
            sizes: this.ctx.sizes,
            title: this.ctx.title
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/__link/b-page__link.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/__cc/b-page__cc.bemhtml.js */
block('b-page').elem('cc')(
    tag()(false),

    content()(function() {
        var others = this.ctx.others,
            negation = this.ctx.condition.indexOf('!') > -1;

        return [
            '<!--[if ' + this.ctx.condition + ']>',
            others ? '<!' : '',
            (negation || others) ? '-->' : '',
            this.ctx.content,
            (negation || others) ? '<!--' : '',
            '<![endif]-->'
        ];
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/__cc/b-page__cc.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/blocks/external/wiki-txt/wiki-txt.bemhtml.js */
block('wiki-txt').replace()(function() {
    var string = this.ctx['wiki-attrs'].txt;

    string = this.ctx.noEscape ? string : this.xmlEscape(string);

    return string;
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/blocks/external/wiki-txt/wiki-txt.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-statcounter/b-statcounter.bemhtml.js */
block('b-statcounter').tag()('i');

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-statcounter/b-statcounter.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-statcounter/__services/b-statcounter__services.bemhtml.js */
/* istanbul ignore next: deprecated */
/* Это файл раньше генерировался автоматически (см. services2bemhtml.xsl в romochka) */
block('b-statcounter').match(function() { return !this._services; })
    .def()(function() {
        return applyNext({
            _services: {
                gemius: {
                    morda: {
                        ua: '.FiadjwiP9UYHyKfnAdx9rR2Pw1yqHsEeo4qE539Jrb.d7',
                        by: 'nG5KUUCPDxt5ugMoPnW8F8Q8T.Ry8PiaZF58FwOq98P.67'
                    },
                    serp: {
                        ua: 'ApiQcuNuY7w0rQGVoQOIALR2P4NyqHropLkKqJsj5fb.E7',
                        by: 'nG5KUUCPDxrZ8U2PJjJwA8Q8.jhy8SM6BNrOY9udjNr.U7'
                    },
                    mail: {
                        ua: 'oktF.vNu2Rsvqe8efbpW.5PafZuip2MgOijdfB6Nbe7.R7',
                        by: 'nG5Aq0CPM0tzo2X4nTm0JsPc7MpyMThZBMTiDVsHTBv.f7'
                    },
                    fotki: {
                        ua: 'okrlPPNuySwvX_98NSdul5SsfbuiXmMwBN835Et7rb..K7',
                        by: 'nAfg60BtI8pzszYSnTB8wqSf.jiiPiM6ZD3uq4sVz.f.L7'
                    },
                    moikrug: {
                        ua: 'outFXvL_2Zs5e6V5VcAag5RMfZuibmMg2lzd_k6uxYv.c7',
                        by: 'AqHgjecHI4DUV5xy68I368Pc7OpyMThpmqBMDP5qh0r.a7'
                    },
                    direct: {
                        ua: 'dvaQbcbtYvNUdJa3E1UGfNTJP1IN43uSkZZw4VCYA6n.r7',
                        by: '0tTglGdBI4EPpzapFxC8YresPxOwiAd78iP_LJKg_Tj.Z7'
                    },
                    uslugi: {
                        ua: 'd1aQy8dtYzv_lFviy8bZhNVp354NI7s1t1Pq71fpVsL.Z7',
                        by: 'zNFAUrAcM8rkEywMsn5HjZcP33Lg1kdWvMxobPeHSaD.o7'
                    },
                    money: {
                        ua: 'zNtATbvKsxz_nWuWjP5wdsbi.j6wAcdrZdHew21UiWf.j7',
                        by: 'zU.qjyNp.2OlLR2XXqQ0JJbxzUrgyg9SUr5_n9o0pB3.Z7'
                    },
                    market: {
                        ua: 'nFFL_0vjNElzO86U0EXtQoYhHZJFD6LvXxaNNa0pvQ..y7',
                        by: 'AkhArecpM4HUW2a2awS0D3ZJ7Op18zhptTvi7_geTLf.D7'
                    },
                    wow: {
                        ua: '.FtF.Tvz2ePtXI8xsHm2QpR63_mit7tH2trqcPXgqp7.w7',
                        by: 'AqhAS_epM8t_wGZms4y0t3Xp7FR1Mzh13vbiMD1_dF7.r7'
                    },
                    tv: {
                        ua: 'nFDrOUvjJFnT0mhCuJwym4XBHXJFH6Lfv6_tDVW6fRf.c7',
                        by: 'nAfg60BtI8pzGTYSVT30Y6SfT.SiPfia_jl8F9XZ98P.h7'
                    },
                    afisha: {
                        ua: 'ourr2PL_JNo5285ynWf9spRMfZuibmMg2rM39fZMBVX.07',
                        by: 'nG3qj0CP.2Nz3dNB1Y50_8Pc.hhyMSMqOqLuzS6AdBL.27'
                    },
                    weather: {
                        ua: '.FtL_zvzNElD7M40eIPl05R6P32it3uU2rsaIHXdwsT.K7',
                        by: 'AqJKT_cHD_R0EU2Po3H468Pc.q5yMSMemiXuiKYkzAX.w7'
                    },
                    video: {
                        ua: '.FtL_TvzNBHtvG6nsFDNDpPa33Oip7tjOl7qpEYAUl..K7',
                        by: 'AkHg7eeHIwDUxvxNMyLHE8PcXfdyMeNuZO3_DoLHJJP.r7'
                    },
                    music: {
                        ua: 'bQqQy09xYzwpf1viMB7ZhNU7354N2rs1t2Hq79gmVsL.d7',
                        by: '0tVKVmdBD_S5ck12lzE4_resfQWwiO8e8lq1FGn7pAr.B7'
                    },
                    news: {
                        ua: 'nFDlP0vjyWN9.aT5cOmiGoYhfZtFD2Mgv69XPf25xe..u7',
                        by: 'nAhKsUBtD5t59gN4hgA8.6Rt.jiixyM6ZKXuq2N4TA3.c7'
                    },
                    maps: {
                        ua: '.FtL_TvzNBJD7M3ysOdlS5PafZuip2MgOkm9scZuBQH.g7',
                        by: 'AkJKT_eHD_Qe8U1NoxRwfMQ8TBRy8PiqOqzyk1XYfNz.77'
                    },
                    slovari: {
                        ua: '.FtFXTvz2WRD7O_8MDPeqJR6fbuit2Mw2oW9IPaRLUL.H7',
                        by: 'AqfgjeepI4F_xfx.61zHQnZJTBR18viqtVwS22h0vFH.P7'
                    },
                    images: {
                        ua: 'ourr2PL_JNqPr84S1R31y5RM33OibrtjOgFA9Z6GP7X.47',
                        by: 'Aqfqj_ep.2LUix1nM3iwx3YX7Op1fDhp3x7i7xU2TB..t7'
                    },
                    blogs: {
                        ua: 'nFDlP0vjyWN9.e__OEVmxoYh33NFD7tjv3lgPVVbJzn.B7',
                        by: 'Akfgi_cpI0p0uvv9I1nPqsRqXmFyOuN6Ogr_T64EpFb.E7'
                    },
                    auto: {
                        ua: 'nLrlPUvgySxzIQUkmL86OoaTHZJF1qLvX66tfQT.fbf..7',
                        by: 'AkJKr_eHD2R0GwN420i8b8Q8.hhy8SMqmpXuzP32dBL.e7'
                    },
                    games: {
                        ua: 'nLtFXUvg2WR9k6U38KmSDIaTP31F1nuUv4b62H2y2kD.P7',
                        by: 'AkHqkeeH.5oekdNBo4P8Y8Pc7MpyMThZBMTiDbOV9Cn.f7'
                    },
                    yaca: {
                        ua: '.FrlPTvzySxDTKT5eBSikpPaP32ip3uUOimQNx41b7n.27',
                        by: 'AqHqj_cH.2N0sR1nI2e4J8Q8XkFy8eNqOq10Ci6keUz.A7'
                    },
                    rasp: {
                        ua: 'okrr2vNuJBGP3wf2HV_q65SsP32iXnuU2p2QNvYF76P.k7',
                        by: 'nGhArU.tM4J5IGa2vmU8d6RtTBSixviqxBLyk7OZJJP.j7'
                    },
                    rabota: {
                        ua: 'AjrgG_LAo_4KlMup_qzUlKbkjzLgqptUYqR6s1odIm..n7',
                        by: 'nSA1ZLOt_RzUykUXMVXMdbbuDmywPMOAVPMU7W1ZRcD.y7'
                    },
                    realty: {
                        ua: 'dw.ldsd6yaNUd6WSSy_ilbdMjw6wyJrWzCUd2d7FDuT.U7',
                        by: 'B22QdCtD4w6uR2wGjbjbWJYU7FlF7zizTwM.TGTJjDD.97'
                    },
                    lego: {
                        ua: 'uacode',
                        by: 'bycode'
                    }
                },
                metrika: {
                    mail: '316002',
                    zakladki: '723085',
                    fotki: '149814',
                    moikrug: '723019',
                    direct: '34',
                    money: '152220',
                    lenta: '723182',
                    market: '160656',
                    wow: '723021',
                    tv: '146686',
                    afisha: '115081',
                    calendar: '723179',
                    nahodki: '723082',
                    weather: '115080',
                    kuda: '',
                    video: '722884',
                    music: '',
                    'music-partner': '',
                    www: '722545',
                    search: '731962',
                    news: '722818',
                    maps: '114208',
                    'maps-wiki': '912227',
                    probki: '114208',
                    slovari: '115079',
                    images: '722889',
                    blogs: '722825',
                    auto: '722874',
                    adresa: '114208',
                    games: '',
                    yaca: '722622',
                    rasp: '99704',
                    pvo: '723177',
                    online: '723158',
                    books: '722938',
                    site: '723122',
                    bar: '139765',
                    widgets: '816290',
                    wdgt: '464613',
                    interests: '723187',
                    kraski: '',
                    local: '723183',
                    museums: '',
                    collection: '723203',
                    company: '723139',
                    tests: '',
                    referats: '',
                    terms: '',
                    tune: '',
                    api: '146685',
                    punto: '723162',
                    opinion: '',
                    perevod: '',
                    rabota: '',
                    ege: '946192',
                    advertising: '191494',
                    'direct.market': '',
                    ba: '',
                    partners: '38',
                    metrika: '101500',
                    balance: '',
                    wordstat: '',
                    webmaster: '723120',
                    stat: '723152',
                    mobile: '83907',
                    help: '723245',
                    feedback: '115569',
                    start: '',
                    cityday: '',
                    openid: '',
                    nano: '',
                    partnersearch: '',
                    goroda: '723193',
                    toster: '',
                    love: '',
                    rk: '',
                    lost: '',
                    soft: '413990',
                    opera: '780511',
                    browser: '1635717',
                    passport: '',
                    wiki: '153432',
                    staff: '156784',
                    jira: '1065347',
                    maillists: '445887',
                    statface: '657309',
                    doc: '811196',
                    job: '',
                    otrs: '',
                    planner: '153440',
                    jabber: '',
                    bond: '330896',
                    diary: '1004067',
                    jing: '193857',
                    lunapark: '',
                    'intranet-passport': '',
                    blogmon: '',
                    videoteka: '',
                    gap: '',
                    libra: '193850',
                    admins: '',
                    'jams-arm': '',
                    subs: '',
                    center: '',
                    all: '',
                    lego: '123456'
                }
            }
        });
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-statcounter/__services/b-statcounter__services.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-bem/__i18n/i-bem__i18n.bemhtml.js */
block('i-bem').elem('i18n').def()(function() {
    if(!this.ctx) {
        return '';
    }

    var ctx = this.ctx,
        keyset = ctx.keyset,
        key = ctx.key,
        params = ctx.params || {};

    if(!(keyset || key)) {
        return '';
    }

    /**
     * Consider `content` is a reserved param that contains
     * valid bemjson data
     */
    ctx.content && (params.content = this.reapply(ctx.content));

    // Для bem-xjst 1.x applyCtx нужен, чтобы записать в _buf
    return applyCtx(BEM.I18N(keyset, key, params));
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-bem/__i18n/i-bem__i18n.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-services/m-head-services.bemhtml.js */
block('m-head-services').elem('icon')(
    tag()('i'),
    attrs()(function() {
        return {
            style: ('background-image: url(data:image/svg+xml;base64,' + this.ctx.icon + ')')
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-services/m-head-services.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/util/util.bemhtml.js */
oninit(function(exports) {
    exports.BEMContext.prototype.util || (exports.BEMContext.prototype.util = {});
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/util/util.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/__box/input__box.bemhtml.js */
block('input').elem('box')(
    tag()('span'),

    content()(function() {
        return [
            this._iconLeft && {
                elem: 'icon',
                icon: this._iconLeft,
                elemMods: {side: 'left'}
            },
            this._iconRight && {
                elem: 'icon',
                icon: this._iconRight,
                elemMods: {side: 'right'}
            },
            !this.mods.clear && {
                elem: 'clear',
                elemMods: this._value ? {visibility: 'visible'} : undefined,
                content: '&nbsp;'
            },
            this.ctx.content
        ].filter(Boolean);
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/__box/input__box.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/__control/input__control.bemhtml.js */
block('input').elem('control')(
    tag()('input'),

    attrs()(function() {
        var a = this.extend({
            id: this._inputId,
            name: this._name,
            placeholder: this._placeholder
        }, this.ctx.controlAttrs);

        (this._value || this._value === 0) && (a.value = this._value);
        this.mods.disabled && (a.disabled = 'disabled');

        if(this._live) {
            a.autocomplete = 'off';
        }
        a['aria-labelledby'] = this._labelId + ' ' + this._hintId;

        return a;
    }),

    wrap()(function() {
        return [
            this._placeholder ? {elem: 'hint', elemMods: {fallback: 'yes'}, content: this._placeholder} : '',
            {elem: 'box', content: this.ctx}
        ];
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/__control/input__control.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-userpic/m-userpic.bemhtml.js */
block('m-userpic')(
    tag()('span'),
    match(function() {
        return this.ctx.url;
    })(
        tag()('a'),
        attrs()(function() {
            return {
                href: this.ctx.url
            };
        })
    ),
    content()(function() {
        return {
            elem: 'img',
            tag: 'img',
            login: this.ctx.login,
            size: this.ctx.size
        };
    }),
    elem('img').attrs()(
        match(function() {
            return true;
        })(function() {
            return {
                src: ('//center.yandex-team.ru/api/v1/user/' + this.ctx.login + '/avatar.jpg')
            };
        }),
        match(function() {
            return this.ctx.size;
        })(function() {
            return {
                src: ('//center.yandex-team.ru/api/v1/user/' + this.ctx.login + '/avatar/' + this.ctx.size + '.jpg')
            };
        })
    )
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-userpic/m-userpic.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button2/__text/button2__text.bemhtml.js */
block('button2').elem('text').tag()('span');

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button2/__text/button2__text.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-username/m-username.bemhtml.js */
block('m-username')(
    tag()(function() {
        return this.ctx.url ? 'a' : 'span';
    }),
    attrs()(function() {
        var a = {
            href: this.ctx.url
        };
        this.ctx.counter && (a.onmousedown = this.ctx.counter);
        return a;
    }),
    content()(function() {
        return [{
            elem: 'first-letter',
            content: this.ctx.content.charAt(0)
        }, this.ctx.content.slice(1)];
    }),
    elem('first-letter').tag()('span')
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-username/m-username.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/footer/footer.bemhtml.js */
block('footer')(
    def()(function() {
        return applyNext({_inFooter: true});
    }),

    mix()(function() {
        return [{block: 'clearfix'}];
    }),

    attrs()(function() {
        return {role: 'contentinfo'};
    }),

    match(function() { return !this.ctx.content; })
        .content()(function() {
            /* jshint ignore:line *//* jscs:ignore */(/*%%%ISLDEBUG%%%*/+0 && console.assert(typeof this.ctx.tld === 'string', 'footer: не передан обязательный строковый параметр tld'));

            var leftColumnContent = [],
                rightColumnContent = [];

            leftColumnContent.push({
                elem: 'link',
                url: BEM.I18N('footer', 'apps-url'),
                content: BEM.I18N('footer', 'apps')
            });

            var isKubr = this.ctx.tld.indexOf('com') === -1;

            isKubr && rightColumnContent.push({
                elem: 'link',
                url: BEM.I18N('footer', 'advert-url'),
                content: BEM.I18N('footer', 'advert')
            });

            // TODO: Возможно стоит перенести statUrl куда-то поближе к i-services
            isKubr && this.ctx.statUrl && rightColumnContent.push({
                elem: 'link',
                url: this.ctx.statUrl,
                content: BEM.I18N('footer', 'stat')
            });

            rightColumnContent.push({
                elem: 'link',
                url: BEM.I18N('footer', 'termsofuse-url'),
                content: BEM.I18N('footer', 'termsofuse')
            });

            rightColumnContent.push({
                elem: 'link',
                url: BEM.I18N('footer', 'about-url'),
                content: BEM.I18N('footer', 'about')
            });

            rightColumnContent.push({
                block: 'copyright',
                elemLinkMix: {
                    block: this.block,
                    elem: 'link'
                },
                start: this.ctx.start
            });

            return [
                {
                    elem: 'column',
                    content: leftColumnContent
                },
                {
                    elem: 'column',
                    elemMods: {side: 'right'},
                    content: rightColumnContent
                }
            ];
        })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/footer/footer.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/copyright/copyright.bemhtml.js */
block('copyright')(
    /* istanbul ignore next: overrided */
    mode('wrapLink')(function() {
        var ctx = this.ctx;

        return {
            block: 'i-bem',
            elem: 'i18n',
            keyset: 'copyright',
            key: 'link',
            content: {
                block: 'copyright',
                elem: 'link',
                mix: ctx.elemLinkMix,
                url: ctx.url === undefined ? this['i-services'].serviceUrl('www') : ctx.url
            }
        };
    }),

    content()(function() {
        return [
            '&copy;&nbsp;',
            {
                elem: 'dates',
                start: this.ctx.start
            },
            '&nbsp;&nbsp;',
            this.ctx.content || apply('wrapLink')
        ];
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/copyright/copyright.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/copyright/__link/copyright__link.bemhtml.js */
block('copyright').elem('link')(
    tag()(false),

    match(function() { return this.ctx.url; })(
        tag()('a'),

        attrs()(function() {
            return {href: this.ctx.url};
        })
    ),

    content()(function() {
        return this.ctx.content || BEM.I18N('copyright', 'yandex');
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/copyright/__link/copyright__link.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/copyright/__dates/copyright__dates.bemhtml.js */
block('copyright').elem('dates')(
    tag()('span'),
    content()(function() {
        var start = this.ctx.start,
            currentYear = (new Date()).getFullYear();
        return [
            start && start !== currentYear && (start + '–'),
            currentYear
        ];
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/copyright/__dates/copyright__dates.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-global/i-global.bemhtml.js */
oninit(function(exports) {
    var ctxProto = exports.BEMContext.prototype,
        // Параметры по умолчанию
        glob = exports['i-global'] = ctxProto['i-global'] = ctxProto.extend({
            lang: 'ru',
            tld: 'ru',
            'content-region': 'ru',
            'click-host': '//clck.yandex.ru',
            'passport-host': 'https://passport.yandex.ru',
            'pass-host': 'https://pass.yandex.ru',
            'social-host': 'https://social.yandex.ru',
            'export-host': 'https://export.yandex.ru',
            login: '',
            'lego-static-host': 'https://yastatic.net/lego/2.10-142'
        }, ctxProto['i-global']);

    // Параметры доступные в JS
    glob._public = {
        id: true,
        lang: true,
        tld: true,
        'content-region': true,
        'user-region': true,
        login: true,
        displayName: true,
        index: true,
        yandexuid: true,
        'passport-host': true,
        'pass-host': true,
        'passport-msg': true,
        'static-host': true,
        'lego-static-host': true,
        'social-host': true,
        clck: true,
        'click-host': true,
        'export-host': true,
        'i-host': true,
        'social-retpath': true,
        'lego-path': true,
        sid: true,
        retpath: true,
        uid: true
    };

    /**
     * Делает один или несколько параметров доступными или недоступными в JS.
     *
     * ```
     * bh.lib.makePublic('param');
     * bh.lib.makePublic('param', false);
     * bh.lib.makePublic({first: true, second: false});
     * ```
     *
     * @param {String|Object<String,Boolean>} param Имя параметра или объект именами параметров в качестве ключей
     * и значениями `true` или `false`
     * @param {Boolean} [flag] Устанавливаемое значение доступности параметра
     */
    glob.makePublic = function(param, flag) {
        if(typeof param === 'object') {
            glob._public = ctxProto.extend(glob._public, param);
            return;
        }

        if(typeof flag === 'undefined') {
            flag = true;
        }

        glob._public[param] = flag;
    };

    /**
     * Проверяет доступен ли параметр в JS.
     *
     * @param {String} param Имя параметра
     * @returns {Boolean} Доступность параметра
     */
    glob.isPublic = function(param) {
        return Boolean(glob._public[param]);
    };

    /**
     * Изменяет локаль.
     *
     * @param {String} tld Код локали, например `ru` или `tr`
     */
    glob.setTld = function(tld) {
        var xYaDomain = tld === 'tr' ? 'yandex.com.tr' : 'yandex.' + tld,
            yaDomain = ['ua', 'by', 'kz'].indexOf(tld) !== -1 ? 'yandex.ru' : xYaDomain;

        glob.tld = tld;
        glob['content-region'] = tld;
        glob['click-host'] = '//clck.' + yaDomain;
        glob['passport-host'] = 'https://passport.' + yaDomain;
        glob['pass-host'] = 'https://pass.' + xYaDomain;
        glob['social-host'] = 'https://social.' + xYaDomain;
        glob['export-host'] = 'https://export.' + xYaDomain;
    };

    ctxProto._iGlobalBackup = {
        _backup: null,
        exists: function() {
            return Boolean(this._backup);
        },
        save: function() {
            this._backup = ctxProto.extend({}, glob);
        },
        restore: function() {
            // Нельзя просто заменить ссылку на i-global, некоторые блоки сохраняют её при инициализации шаблонов.
            // Приходится удалять и перезаписывать содержимое.
            var p;
            for(p in glob) {
                delete glob[p];
            }
            for(p in this._backup) {
                glob[p] = this._backup[p];
            }
        }
    };
});

block('i-global')(
    tag()(''),

    def()(function() {
        var params = this.ctx.params || {},
            iGlobal = this['i-global'];

        // https://st.yandex-team.ru/ISL-1844
        if(!this._iGlobalBackup.exists()) {
            this._iGlobalBackup.save();
        } else if(this.ctx.reset !== false) {
            this._iGlobalBackup.restore();
        }

        // LEGO-7925
        if(params.tld && params.tld !== iGlobal.tld) {
            iGlobal.setTld(params.tld);
        }

        for(var p in params) {
            iGlobal[p] = params[p];
        }

        return '';
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-global/i-global.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/blocks/external/i-global/i-global.bemhtml.js */
oninit(function(exports) {
    exports['i-global'].makePublic('tz');
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/blocks/external/i-global/i-global.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-ua/i-ua.bemhtml.js */
block('i-ua')(
    bem()(false),

    tag()('script'),

    attrs()(function() {
        return {
            nonce: this.ctx.nonce || this['i-global'].nonce
        };
    }),

    content()(function() {
        return [
            ';(function(d,e,c,r){',
                'e=d.documentElement;',
                'c="className";',
                'r="replace";',
                'e[c]=e[c][r]("i-ua_js_no","i-ua_js_yes");',
                'if(d.compatMode!="CSS1Compat")',
                'e[c]=e[c][r]("i-ua_css_standart","i-ua_css_quirks")',
            '})(document);'
        ].join('');
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-ua/i-ua.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-ua/__svg/i-ua__svg.bemhtml.js */
block('i-ua')
    .content()(function() {
        var c = applyNext();

        c += [
                ';(function(d,e,c,n,w,v,f){',
                    'e=d.documentElement;',
                    'c="className";',
                    'n="createElementNS";',
                    'f="firstChild";',
                    'w="http://www.w3.org/2000/svg";',
                    'e[c]+=" i-ua_svg_"+(!!d[n]&&!!d[n](w,"svg").createSVGRect?"yes":"no");',
                    'v=d.createElement("div");',
                    'v.innerHTML="<svg/>";',
                    'e[c]+=" i-ua_inlinesvg_"+((v[f]&&v[f].namespaceURI)==w?"yes":"no");',
                 '})(document);'
             ].join('');

        return c;
    });

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-ua/__svg/i-ua__svg.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/__js/b-page__js.bemhtml.js */
block('b-page').elem('js')(
    bem()(false),

    tag()('script'),

    attrs()(function() {
        return {
            src: this.ctx.url,
            nonce: this.ctx.nonce || this['i-global'].nonce
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/__js/b-page__js.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/__css/b-page__css.bemhtml.js */
block('b-page').elem('css')(
    bem()(false),

    tag()('style'),

    attrs()(function() {
        return {nonce: this.ctx.nonce || this['i-global'].nonce};
    }),

    def().match(function() { return this.ctx.ie !== undefined; })(
        match(function() { return this.ctx.ie === true; })(function() {
            var url = this.ctx.url;
            return applyCtx({
                elem: 'cc',
                condition: 'IE 9',
                content: {
                    elem: 'css',
                    url: /\.css$/.test(url) ? url : url + '.ie9.css' // Deprecated, будет удалено в 5.0
                }
            });
        }),

        match(function() { return this.ctx.ie === false; })(function() {
            return applyCtx({
                elem: 'cc',
                condition: 'gt IE 9',
                others: true,
                content: {
                    elem: 'css',
                    url: this.ctx.url
                }
            });
        }),

        match(function() { return typeof this.ctx.ie === 'string'; })(function() {
            return applyCtx({
                elem: 'cc',
                condition: this.ctx.ie,
                others: this.ctx.ie.indexOf('!') > -1,
                content: {
                    elem: 'css',
                    url: this.ctx.url
                }
            });
        })
    ),

    match(function() { return this.ctx.url; })(
        tag()('link'),
        attrs()(function() {
            return {
                rel: 'stylesheet',
                href: this.ctx.url
            };
        })
    )
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/__css/b-page__css.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/desktop.blocks/b-page/__css/b-page__css.bemhtml.js */
block('b-page').elem('css')(
    def().match(function() { return this.ctx.ie === true; })(function() {
        var url = this.ctx.url;
        return [
            applyCtx({
                elem: 'cc',
                condition: 'IE 8',
                content: {
                    elem: 'css',
                    url: url + '.ie8.css'
                }
            }),
            applyNext()
        ].join(''); // В bem-xjst@next мода `def` ожидает строку или преобразует значение к строке.
                    // По умолчанию массив будет склеен с помощью запятой (['str1', 'str2'].toString() -> 'str1,str2').
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/desktop.blocks/b-page/__css/b-page__css.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-statcounter/__metrika/b-statcounter__metrika.bemhtml.js */
block('b-statcounter').elem('metrika').match(function() { return this.elem; })(
    tag()('img'),

    attrs()(function() {
        return {
            alt: '',
            src: '//mc.yandex.ru/watch/' + this.ctx.counter + (this.ctx._noindex ? '?ut=noindex' : '')
        };
    }),

    bem()(false),

    def()(
        /**
         * Если кода нет, просто удаляем элемент
         */
        match(function() { return !this.ctx.counter; })(function() {
            return '';
        }),

        /**
         * Если пользователь не передал код, пробуем определить заданный по умолчанию для данного сервиса.
         *
         * @deprecated Элемент __services устарел и будет удален, следует всегда явно передавать код счётчика.
         */
        match(function() { return !this.ctx.counter && !this.ctx._haveTriedToGetCounter; })(function() {
            return applyNext({
                'ctx.counter': this._services.metrika[this['i-global'].id],
                'ctx._haveTriedToGetCounter': true
            });
        }),

        /**
         * @see http://help.yandex.ru/metrika/?id=1120714
         */
        match(function() { return this.ctx._noindex === undefined; }).wrap()(function() {
            this.ctx._noindex = this.ctx.js && (this.ctx.js.ut === 'noindex' || this.ctx.js.ut === 0);

            return this.ctx;
        })
    )
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-statcounter/__metrika/b-statcounter__metrika.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-bem/__i18n/_dummy/i-bem__i18n_dummy_yes.bemhtml.js */
/* global oninit */

oninit(function() {
    (function(global, bem_) {
        if(bem_.I18N) {
            return;
        }

        /**
         * Points to global context
         * @global
         */
        global.BEM = bem_;

        /**
         * `BEM.I18N` API stub
         */
        var i18n = bem_.I18N = function(keyset, key) {
            return key;
        };

        i18n.keyset = function() { return i18n };
        i18n.key = function(key) { return key };
        i18n.lang = function() { return };
    })(this, typeof BEM === 'undefined' ? {} : BEM);
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-bem/__i18n/_dummy/i-bem__i18n_dummy_yes.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/awesome-icon/desktop.blocks/awesome-icon/awesome-icon.bemhtml.js */
block('awesome-icon').tag()('span');

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/awesome-icon/desktop.blocks/awesome-icon/awesome-icon.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup2/popup2.bemhtml.js */
block('popup2').js()(function() {
    var ctx = this.ctx;
    return {
        mainOffset: ctx.mainOffset,
        secondaryOffset: ctx.secondaryOffset,
        viewportOffset: ctx.viewportOffset,
        directions: ctx.directions,
        zIndexGroupLevel: ctx.zIndexGroupLevel
    };
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup2/popup2.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/util/__merge/util__merge.bemhtml.js */
/* istanbul ignore next: Тестируется в spec.js. */
oninit(function(exports) {
    var toString = Object.prototype.toString;

    function isObject(something) {
        // Использование typeof отсекает undefined
        return typeof something === 'object' && toString.call(something) === '[object Object]';
    }

    function merge(object, source, customizer) {
        var key, customized;

        object = Object(object);
        source = Object(source);

        for(key in source) {
            customized = customizer && customizer(object[key], source[key], key);

            if(customized !== undefined) {
                object[key] = customized;
            } else if(isObject(object[key]) && isObject(source[key])) {
                object[key] = merge(object[key], source[key], customizer);
            } else {
                object[key] = source[key];
            }
        }

        return object;
    }

    function mergeBemjson(object, source) {
        return merge(object, source, function(left, right, key) {
            if(key === 'mix') {
                return [].concat(left, right);
            }
        });
    }

    exports.BEMContext.prototype.util.merge = merge;
    exports.BEMContext.prototype.util.mergeBemjson = mergeBemjson;
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/util/__merge/util__merge.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup/popup.bemhtml.js */
block('popup')(
    def().match(function() {return !this._popupDefaults;})(function() {
        var ctx = this.ctx,
            mods = this.mods;

        mods.hasOwnProperty('theme') || (mods.theme = 'ffffff');
        mods.hasOwnProperty('autoclosable') || (mods.autoclosable = 'yes');
        mods.hasOwnProperty('adaptive') || (mods.adaptive = 'yes');
        mods.hasOwnProperty('animate') || (mods.animate = 'yes');

        if(ctx.zIndex) {
            var attrs = ctx.attrs || (ctx.attrs = {});
            attrs.style = (attrs.style || '') + ';z-index:' + ctx.zIndex + ';';
        }

        // TODO: https://st.yandex-team.ru/ISL-2551
        // Change to applyNext(...) after dropping bem-xjst@1
        return apply('default', {_popupDefaults: true});
    }),

    content()(function() {
        // NOTE(varankinv@): сбрасываем гард (если он есть),
        // чтобы `default` применилась к вложенным попапам
        delete this._popupDefaults;

        return [
            {elem: 'under', elemMods: this.ctx.underMods},
            this.ctx.content
        ];
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup/popup.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup/__close/popup__close.bemhtml.js */
block('popup').elem('close').tag()('i');

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup/__close/popup__close.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup/__tail/popup__tail.bemhtml.js */
block('popup').elem('tail').tag()('i');

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup/__tail/popup__tail.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button/button.bemhtml.js */
block('button')(
    def()(function() {
        /* jshint ignore:line *//* jscs:ignore */(/*%%%ISLDEBUG%%%*/+0 && console.assert(Object(this.ctx.attrs).target === undefined, 'button: Атрибут target ' +
            'необходимо устанавливать в контексте блока, а не через атрибуты блока.'));
        return applyNext();
    }),

    tag()('button'),

    match(function() { return this.ctx.url; }).tag()('a'),

    js()(true),

    def()(function() {
        this.mods.hasOwnProperty('theme') || (this.mods.theme = 'normal');
        return applyNext();
    }),

    attrs()(
        // Common attributes
        match(function() { return true; })(function() {
            var ctx = this.ctx,
                a = {};

            a.tabindex = ctx.tabindex;

            return a;
        }),

        // Attributes for link variant
        match(function() { return this.ctx.url; })(function() {
            var ctx = this.ctx,
                attrs = ctx.attrs,
                p = applyNext(),
                a = {
                    href: ctx.url,
                    target: ctx.target
                },
                hasRel = Object(attrs).rel !== undefined,
                rel = hasRel ? String(attrs.rel) : '',
                isBlank = a.target === '_blank';

            if(isBlank) {
                a.rel = 'noopener';

                if(rel && rel.indexOf('noopener') === -1) {
                    attrs.rel = rel + ' noopener'; // Пользовательский атрибут имеет больший приоритет в BEMHTML
                }
            }

            return this.extend(p, a);
        }),

        // Attributes for button variant
        match(function() { return !this.ctx.url; })(function() {
            var ctx = this.ctx,
                p = applyNext(),
                a = {
                    type: ctx.type || 'button',
                    autocomplete: 'off', // https://st.yandex-team.ru/ISL-1667
                    name: ctx.name,
                    value: ctx.value
                };

            return this.extend(p, a);
        })
    ),

    content()(function() {
        return {
            elem: 'text',
            tag: 'span',
            content: this.ctx.content
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button/button.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-ua/__input/i-ua__input.bemhtml.js */
block('i-ua')
    .content()(function() {
        var c = applyNext();

        c += [
            ';(function(d,e,p){',
            'e=d.documentElement;',
            'p="placeholder";',
            'e.className+=" i-ua_"+p+(p in d.createElement("input")?"_yes":"_no")',
            '})(document);'
        ].join('');

        return c;
    });

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-ua/__input/i-ua__input.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/mi-helpers/mi-helpers.bemhtml.js */
oninit(function(exports, context) {
    exports.BEMContext.prototype['mi-helpers'] = {
        getDateFromHumanString: function(humanString) {
            var date, dotIndex = Math.abs((~humanString.search(/\./) || ~humanString.search('Z'))),
                parsed = humanString;
            (parsed = parsed.replace(/-/g, ',').replace('T', ',').replace(/:/g, ','));
            (parsed = dotIndex ? parsed.substr(0, (dotIndex - 1)) : parsed);
            (parsed = parsed.split(','));
            (parsed[1] = parsed[1] - 1);
            (date = this['getUTC_YMD'](parsed[0], parsed[1], parsed[2]));
            (parsed[3] && date.setHours(parsed[3]));
            (parsed[4] && date.setMinutes(parsed[4]));
            (parsed[5] && date.setSeconds(parsed[5]));
            return date;
        },
        getUTC_YMD: function(y, m, d) {
            var date = new Date(Date.UTC(2000, 10));
            date.setUTCFullYear(y);
            date.setUTCMonth(m);
            date.setUTCDate(d);
            date.setUTCMinutes((date.getMinutes() + date.getTimezoneOffset()));
            return date;
        },
        getHumanStringFromDate: function(params) {
            var humanString, date = params.date,
                year = date.getFullYear(),
                month = (date.getMonth() + 1).toString(),
                day = date.getDate().toString(),
                hours = date.getHours().toString(),
                minutes = date.getMinutes().toString(),
                seconds = date.getSeconds().toString();
            (month.length === 1 && (month = '0' + month));
            (humanString = year + '-' + month);
            if ((params.needDay !== false)) {
                (day.length === 1 && (day = '0' + day));
                (humanString = humanString + '-' + day);
                if (params.needHours) {
                    (hours.length === 1 && (hours = '0' + hours));
                    (humanString = humanString + 'T' + hours);
                    if (params.needMinutes) {
                        (minutes.length === 1 && (minutes = '0' + minutes));
                        (humanString = humanString + ':' + minutes);
                        if (params.needSeconds) {
                            (seconds.length === 1 && (seconds = '0' + seconds));
                            (humanString = humanString + ':' + seconds);
                        }
                    }
                }
            }
            return humanString;
        },
        htmlSpecialChars: function(text) {
            if ((typeof text === 'string')) {
                return text.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#039;');
            } else {
                return text;
            }
        },
        dateFormat: (function() {
            var token = /d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,
                timezone = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,
                timezoneClip = /[^-+\dA-Z]/g,
                pad = function(val, len) {
                    (val = String(val));
                    (len = len || 2);
                    while ((val.length < len)) {
                        (val = '0' + val);
                    }
                    return val;
                },
                masks = {
                    default: 'd mmm yyyy',
                    shortDate: 'd mmm yyyy',
                    mediumDate: 'mmm d, yyyy',
                    longDate: 'mmmm d, yyyy',
                    fullDate: 'dddd, mmmm d, yyyy',
                    shortTime: 'HH:MM',
                    mediumTime: 'h:MM:ss TT',
                    longTime: 'h:MM:ss TT Z',
                    isoDate: 'yyyy-mm-dd',
                    isoTime: 'HH:MM:ss',
                    dayMonthTime: 'dd.mm hh:mm',
                    isoDateTime: 'yyyy-mm-dd\'T\'HH:MM:ss',
                    isoUtcDateTime: 'UTC:yyyy-mm-dd\'T\'HH:MM:ss\'Z\''
                };
            return function(date, mask, utc) {
                if ((arguments.length == 1 && Object.prototype.toString.call(date) == '[object String]' && !/\d/.test(date))) {
                    (mask = date);
                    (date = undefined);
                }
                try {
                    (date = date ? new Date(date) : new Date());
                    if (isNaN(date)) {
                        throw SyntaxError('invalid date');
                    }(mask = String((masks[mask] || mask || masks['default'])));
                    if ((mask.slice(0, 4) == 'UTC:')) {
                        (mask = mask.slice(4));
                        (utc = true);
                    }
                    var _ = (utc ? 'getUTC' : 'get'),
                        d = date[(_ + 'Date')](),
                        D = date[(_ + 'Day')](),
                        m = date[(_ + 'Month')](),
                        y = date[(_ + 'FullYear')](),
                        H = date[(_ + 'Hours')](),
                        M = date[(_ + 'Minutes')](),
                        s = date[(_ + 'Seconds')](),
                        L = date[(_ + 'Milliseconds')](),
                        o = (utc ? 0 : date.getTimezoneOffset()),
                        flags = {
                            d: d,
                            dd: pad(d),
                            ddd: BEM.I18N('i-tanker__days', ('short' + (D ? D : 7))),
                            dddd: BEM.I18N('i-tanker__days', ('n' + (D ? D : 7))),
                            m: (m + 1),
                            mm: pad((m + 1)),
                            mmm: BEM.I18N('i-tanker__months', ('short' + (m + 1))),
                            mmmm: BEM.I18N('i-tanker__months', ('g' + (m + 1))),
                            yy: String(y).slice(2),
                            yyyy: y,
                            h: (H % 12 || 12),
                            hh: pad((H % 12 || 12)),
                            H: H,
                            HH: pad(H),
                            M: M,
                            MM: pad(M),
                            s: s,
                            ss: pad(s),
                            l: pad(L, 3),
                            L: pad((L > 99 ? Math.round((L / 10)) : L)),
                            t: (H < 12 ? 'a' : 'p'),
                            tt: (H < 12 ? 'am' : 'pm'),
                            T: (H < 12 ? 'A' : 'P'),
                            TT: (H < 12 ? 'AM' : 'PM'),
                            Z: (utc ? 'UTC' : (String(date).match(timezone) || ['']).pop().replace(timezoneClip, '')),
                            o: ((o > 0 ? '-' : '+') + pad((Math.floor((Math.abs(o) / 60)) * 100 + Math.abs(o) % 60), 4)),
                            S: ['th', 'st', 'nd', 'rd'][(d % 10 > 3 ? 0 : (d % 100 - d % 10 != 10) * d % 10)]
                        };
                    return mask.replace(token, function($0) {
                        return ($0 in flags ? flags[$0] : $0.slice(1, ($0.length - 1)));
                    });
                } catch (error) {} finally {
                    undefined;
                };
            };
        })()
    };
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/mi-helpers/mi-helpers.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button2/button2.bemhtml.js */
block('button2')(
    def()(function() {
        // В Opera 12 ссылки по умолчанию не участвуют в taborder. В других браузерах участвуют.
        // В качестве нормализации по дефолту выставляем всем кнопкам tabindex:0.
        if(this.ctx.tabindex === undefined) {
            this.ctx.tabindex = '0';
        }
        return applyNext();
    }),

    // В BEMHTML нельзя задать tag из BEMJSON, если он определен в шаблоне на блок.
    // В button2 это нужно, поэтому делаем такую возможность руками.
    match(function() { return this.ctx.tag === undefined; }).tag()('button'),

    js()(function() {
        // Блок control использует параметр _tabindex при манипуляциях с _disabled.
        return {_tabindex: this.ctx.tabindex};
    }),

    attrs()(function() {
        var ctx = this.ctx,
            isDisabled = Boolean(this.mods.disabled);

        return {
            type: 'button', // По умолчанию браузеры выставляют у <button> тип submit.
            autocomplete: 'off', // https://st.yandex-team.ru/ISL-1667
            id: ctx.id,
            title: ctx.title,
            name: ctx.name,
            value: ctx.val,
            tabindex: isDisabled ? undefined : ctx.tabindex,
            disabled: isDisabled ? 'disabled' : undefined,
            'aria-disabled': isDisabled ? 'true' : undefined
       };
    }),

    // Порядок важен для правильного применения стилей.
    // Элементы icon должны идти раньше, чем text.
    match(function() { return !this.ctx.content; }).content()(function() {
        var ctx = this.ctx;

        return [
            ctx.icon && {
                elem: 'icon',
                icon: ctx.icon
            },
            ctx.iconLeft && {
                elem: 'icon',
                elemMods: {side: 'left'},
                icon: ctx.iconLeft
            },
            ctx.iconRight && {
                elem: 'icon',
                elemMods: {side: 'right'},
                icon: ctx.iconRight
            },
            // Текст может быть пустой строкой.
            (ctx.text !== undefined) && (this.isSimple(ctx.text)
                ? {elem: 'text', content: this.xmlEscape(ctx.text)}
                : this.extend(ctx.text, {elem: 'text'}))
        ].filter(Boolean); // Удаляем все undefined в массиве.
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button2/button2.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/paranja/paranja.bemhtml.js */
/* istanbul ignore next: deprecated */
block('paranja')
    .def()(function() {
        // Состояние и тема по умолчанию
        return applyNext({
            'mods.state': this.mods.state || 'close',
            'mods.theme': this.mods.theme || 'normal'
        });
    });

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/paranja/paranja.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-services/i-services.bemhtml.js */
oninit(function(exports) {
    var iServices = exports['i-services'] = exports.BEMContext.prototype['i-services'] = {},
        iGlobal = exports['i-global'];

    /**
     * @param {String} [id]
     * @returns {String}
     */
    iServices.serviceName = function(id) {
        return BEM.I18N('i-services', (id || iGlobal.id));
    };

    /**
     * @param {String} [id]
     * @param {String} [region]
     * @returns {String}
     */
    iServices.serviceUrl = function(id, region) {
        var global = iGlobal;

        id || (id = global.id);
        region || (region = global['content-region']);

        return iServices._data[id](region);
    };
});

block('i-services').def()(
    elem('name')(function() {
        return applyCtx(this['i-services'].serviceName(this.ctx.id));
    }),

    elem('url')(function() {
        return applyCtx(this['i-services'].serviceUrl(this.ctx.id, this.ctx.region));
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-services/i-services.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-services/__uri/i-services__uri.bemhtml.js */
                              /*      ((   ))     *\
(@)                          / |\      ))_((     /| \
|-|                         /  | \    (/\|/\)   / |  \                          (@)
| | -----------------------/---|-voV---\`|'/--Vov-|---\-------------------------|-|
|-|                              '^`   (o o)  '^`                               | |
| |                                    `\Y/'                                    |-|
|-| Этот файл сгенерирован автоматически. Вручную править не нужно!             | |
| | Чтобы обновить шаблоны, внесите правки в i-services__uri.assets/source.js   |-|
|-| и запустите i-services__uri.assets/generator.js                             |-|
|_|_____________________________________________________________________________| |
(@)                     l   /\ /       ( (        \ /\   l                    `\|-|
                        l /   V         \ \        V   \ l                      (@)
                        l/              _) )_           \I
                                         \*/
oninit(function(exports) {
    exports['i-services']._data = {
        404: function(reg) {
            switch(reg) {
                case 'ua': return 'http://404.yandex.ua';
                case 'by': return 'http://404.yandex.by';
                case 'kz': return 'http://404.yandex.kz';
                case 'com': return 'http://404.yandex.com';
                case 'tr': return 'http://404.yandex.com.tr';
                default: return 'http://404.yandex.ru';
            }
        },
        adresa: function() {
            return 'http://adresa.yandex.ru';
        },
        advertising: function(reg) {
            switch(reg) {
                case 'ua': return 'https://advertising.yandex.ua';
                case 'by': return 'https://advertising.yandex.by';
                case 'kz': return 'https://advertising.yandex.kz';
                case 'com': return 'https://advertising.yandex.com';
                default: return 'https://advertising.yandex.ru';
            }
        },
        afisha: function(reg) {
            switch(reg) {
                case 'ua': return 'https://afisha.yandex.ua';
                case 'by': return 'https://afisha.yandex.by';
                case 'kz': return 'https://afisha.yandex.kz';
                default: return 'https://afisha.yandex.ru';
            }
        },
        all: function(reg) {
            switch(reg) {
                case 'ua': return '//yandex.ua/all';
                case 'by': return '//yandex.by/all';
                case 'kz': return '//yandex.kz/all';
                case 'com': return '//yandex.com/all';
                case 'tr': return '//yandex.com.tr/all';
                default: return '//yandex.ru/all';
            }
        },
        api: function(reg) {
            switch(reg) {
                case 'com': return 'http://api.yandex.com';
                default: return 'http://api.yandex.ru';
            }
        },
        appsearch: function() {
            return '//appsearch.yandex.ru';
        },
        auto: function(reg) {
            switch(reg) {
                case 'ua': return 'https://auto.yandex.ua';
                default: return 'https://auto.yandex.ru';
            }
        },
        autoru: function() {
            return 'https://auto.ru';
        },
        avia: function(reg) {
            switch(reg) {
                case 'ua': return 'https://avia.yandex.ua';
                default: return 'https://avia.yandex.ru';
            }
        },
        aziada: function() {
            return 'http://aziada2011.yandex.kz';
        },
        ba: function(reg) {
            switch(reg) {
                case 'ua': return 'https://ba.yandex.ua';
                case 'by': return 'https://ba.yandex.by';
                case 'kz': return 'https://ba.yandex.kz';
                case 'com': return 'https://ba.yandex.com';
                default: return 'https://ba.yandex.ru';
            }
        },
        backapv: function() {
            return 'http://backapv.yandex.ru';
        },
        balance: function() {
            return 'https://balance.yandex.ru';
        },
        bar: function(reg) {
            switch(reg) {
                case 'ua': return 'http://bar.yandex.ua';
                case 'by': return 'http://bar.yandex.by';
                case 'kz': return 'http://bar.yandex.kz';
                case 'tr': return 'http://bar.yandex.com.tr';
                default: return 'http://bar.yandex.ru';
            }
        },
        'bar-ie': function(reg) {
            switch(reg) {
                case 'ua': return 'http://bar.yandex.ua/ie';
                case 'by': return 'http://bar.yandex.by/ie';
                case 'kz': return 'http://bar.yandex.kz/ie';
                case 'com': return 'http://bar.yandex.com/ie';
                case 'tr': return 'http://bar.yandex.com.tr/ie';
                default: return 'http://bar.yandex.ru/ie';
            }
        },
        'bar-ie9': function(reg) {
            switch(reg) {
                case 'ua': return 'http://bar.yandex.ua/ie';
                case 'by': return 'http://bar.yandex.by/ie';
                case 'kz': return 'http://bar.yandex.kz/ie';
                case 'com': return 'http://bar.yandex.com/ie';
                case 'tr': return 'http://bar.yandex.com.tr/ie';
                default: return 'http://bar.yandex.ru/ie';
            }
        },
        bayan: function() {
            return 'http://bayan.yandex.ru';
        },
        blogs: function(reg) {
            switch(reg) {
                case 'ua': return 'https://blogs.yandex.ua';
                case 'by': return 'https://blogs.yandex.by';
                case 'kz': return 'https://blogs.yandex.kz';
                default: return 'https://blogs.yandex.ru';
            }
        },
        books: function() {
            return 'http://books.yandex.ru';
        },
        browser: function(reg) {
            switch(reg) {
                case 'ua': return 'https://browser.yandex.ua';
                case 'by': return 'https://browser.yandex.by';
                case 'kz': return 'https://browser.yandex.kz';
                case 'com': return 'https://browser.yandex.com';
                case 'tr': return 'https://browser.yandex.com.tr';
                default: return 'https://browser.yandex.ru';
            }
        },
        calendar: function() {
            return 'https://calendar.yandex.ru';
        },
        catalogwdgt: function() {
            return 'https://www.yandex.ru/catalog';
        },
        chrome: function() {
            return 'http://chrome.yandex.ru';
        },
        city: function(reg) {
            switch(reg) {
                case 'ua': return 'https://gorod.yandex.ua';
                case 'by': return 'https://gorod.yandex.by';
                case 'kz': return 'https://gorod.yandex.kz';
                case 'com': return 'https://city.yandex.com';
                case 'tr': return 'https://city.yandex.com.tr';
                default: return 'https://gorod.yandex.ru';
            }
        },
        cityday: function() {
            return 'http://cityday.yandex.ru';
        },
        collection: function() {
            return 'https://collection.yandex.ru';
        },
        company: function(reg) {
            switch(reg) {
                case 'com': return 'https://company.yandex.com';
                case 'tr': return 'https://company.yandex.com.tr';
                default: return 'https://company.yandex.ru';
            }
        },
        contest: function(reg) {
            switch(reg) {
                case 'com': return 'https://contest.yandex.com';
                default: return 'https://contest.yandex.ru';
            }
        },
        desktop: function() {
            return 'http://desktop.yandex.ru';
        },
        direct: function(reg) {
            switch(reg) {
                case 'ua': return 'https://direct.yandex.ua';
                case 'by': return 'https://direct.yandex.by';
                case 'kz': return 'https://direct.yandex.kz';
                case 'com': return 'https://direct.yandex.com';
                default: return 'https://direct.yandex.ru';
            }
        },
        'direct.market': function() {
            return 'https://partner.market.yandex.ru/yandex.market/';
        },
        disk: function(reg) {
            switch(reg) {
                case 'ua': return 'https://disk.yandex.ua';
                case 'by': return 'https://disk.yandex.by';
                case 'kz': return 'https://disk.yandex.kz';
                case 'com': return 'https://disk.yandex.com';
                case 'tr': return 'https://disk.yandex.com.tr';
                default: return 'https://disk.yandex.ru';
            }
        },
        display: function(reg) {
            switch(reg) {
                case 'tr': return 'https://display.yandex.com.tr';
                default: return 'https://display.yandex.ru';
            }
        },
        ege: function(reg) {
            switch(reg) {
                case 'ua': return 'https://zno.yandex.ua';
                default: return 'https://ege.yandex.ru';
            }
        },
        expert: function() {
            return 'http://expert.yandex.ru';
        },
        feedback: function(reg) {
            switch(reg) {
                case 'ua': return 'http://feedback.yandex.ua';
                case 'by': return 'http://feedback.yandex.by';
                case 'kz': return 'http://feedback.yandex.kz';
                case 'com': return 'http://feedback.yandex.com';
                case 'tr': return 'http://contact.yandex.com.tr';
                default: return 'http://feedback.yandex.ru';
            }
        },
        feedback2: function(reg) {
            switch(reg) {
                case 'ua': return '//feedback2.yandex.ua';
                case 'by': return '//feedback2.yandex.by';
                case 'kz': return '//feedback2.yandex.kz';
                case 'com': return '//feedback2.yandex.com';
                case 'tr': return '//contact2.yandex.com.tr';
                default: return '//feedback2.yandex.ru';
            }
        },
        ff: function() {
            return 'http://ff.yandex.ru';
        },
        fotki: function() {
            return 'https://fotki.yandex.ru';
        },
        fresh: function(reg) {
            switch(reg) {
                case 'ua': return 'https://yandex.ua';
                case 'by': return 'https://yandex.by';
                case 'kz': return 'https://yandex.kz';
                case 'com': return 'https://yandex.com';
                case 'tr': return 'https://yandex.com.tr';
                default: return 'https://yandex.ru';
            }
        },
        fx: function(reg) {
            switch(reg) {
                case 'ua': return 'https://fx.yandex.ua';
                case 'tr': return 'https://fx.yandex.com.tr';
                default: return 'https://fx.yandex.ru';
            }
        },
        games: function() {
            return 'http://games.yandex.ru';
        },
        geocontext: function() {
            return 'https://geocontext.yandex.ru';
        },
        goroda: function() {
            return 'http://goroda.yandex.ru';
        },
        help: function(reg) {
            switch(reg) {
                case 'ua': return 'https://help.yandex.ua';
                case 'com': return 'https://help.yandex.com';
                case 'tr': return 'https://yardim.yandex.com.tr';
                default: return 'https://help.yandex.ru';
            }
        },
        i: function() {
            return 'http://i.yandex.ru';
        },
        ie: function(reg) {
            switch(reg) {
                case 'ua': return 'https://ie.yandex.ua';
                case 'tr': return 'https://ie.yandex.com.tr';
                default: return 'https://ie.yandex.ru';
            }
        },
        images: function(reg) {
            switch(reg) {
                case 'ua': return 'https://yandex.ua/images/';
                case 'by': return 'https://yandex.by/images/';
                case 'kz': return 'https://yandex.kz/images/';
                case 'com': return 'https://yandex.com/images/';
                case 'tr': return 'https://yandex.com.tr/gorsel/';
                default: return 'https://yandex.ru/images/';
            }
        },
        'images-com': function() {
            return 'https://yandex.com/images/';
        },
        interests: function() {
            return 'http://interests.yandex.ru';
        },
        internet: function(reg) {
            switch(reg) {
                case 'com': return '//internet.yandex.com';
                case 'tr': return '//internet.yandex.com.tr';
                default: return '//internet.yandex.ru';
            }
        },
        kassa: function() {
            return 'https://kassa.yandex.ru';
        },
        keyboard: function() {
            return 'http://www.yandex.ru/index_engl_qwerty.html';
        },
        kraski: function() {
            return 'http://kraski.yandex.ru';
        },
        kuda: function() {
            return 'http://kuda.yandex.ru';
        },
        large: function() {
            return 'http://large.yandex.ru';
        },
        legal: function(reg) {
            switch(reg) {
                case 'ua': return 'https://yandex.ua/legal';
                case 'com': return 'https://yandex.com/legal';
                case 'tr': return 'https://yandex.com.tr/legal';
                default: return 'https://yandex.ru/legal';
            }
        },
        lenta: function() {
            return 'http://lenta.yandex.ru';
        },
        literacy: function() {
            return 'https://literacy.yandex.ru';
        },
        local: function() {
            return 'http://local.yandex.ru';
        },
        lost: function() {
            return 'http://lost.yandex.ru';
        },
        love: function() {
            return 'http://love.yandex.ru';
        },
        mail: function(reg) {
            switch(reg) {
                case 'ua': return 'https://mail.yandex.ua';
                case 'by': return 'https://mail.yandex.by';
                case 'kz': return 'https://mail.yandex.kz';
                case 'com': return 'https://mail.yandex.com';
                case 'tr': return 'https://mail.yandex.com.tr';
                default: return 'https://mail.yandex.ru';
            }
        },
        maps: function(reg) {
            switch(reg) {
                case 'ua': return 'https://maps.yandex.ua';
                case 'com': return 'https://maps.yandex.com';
                case 'tr': return 'https://harita.yandex.com.tr';
                default: return 'https://maps.yandex.ru';
            }
        },
        'maps-com': function() {
            return 'https://maps.yandex.com';
        },
        'maps-wiki': function() {
            return 'http://nk.yandex.ru';
        },
        market: function(reg) {
            switch(reg) {
                case 'ua': return 'https://market.yandex.ua';
                case 'by': return 'https://market.yandex.by';
                case 'kz': return 'https://market.yandex.kz';
                case 'tr': return 'https://market.yandex.com.tr';
                default: return 'https://market.yandex.ru';
            }
        },
        'market.advertising': function() {
            return 'https://welcome.advertising.yandex.ru/market/';
        },
        master: function() {
            return 'https://master.yandex.ru';
        },
        metrika: function(reg) {
            switch(reg) {
                case 'ua': return 'https://metrika.yandex.ua';
                case 'by': return 'https://metrika.yandex.by';
                case 'kz': return 'https://metrika.yandex.kz';
                case 'com': return 'https://metrica.yandex.com';
                case 'tr': return 'https://metrica.yandex.com.tr';
                default: return 'https://metrika.yandex.ru';
            }
        },
        metro: function() {
            return 'https://metro.yandex.ru';
        },
        mobile: function(reg) {
            switch(reg) {
                case 'ua': return 'https://mobile.yandex.ua';
                case 'tr': return 'https://mobil.yandex.com.tr';
                default: return 'https://mobile.yandex.ru';
            }
        },
        moikrug: function() {
            return 'http://moikrug.ru';
        },
        money: function() {
            return 'https://money.yandex.ru';
        },
        museums: function() {
            return 'http://18.yandex.ru';
        },
        music: function(reg) {
            switch(reg) {
                case 'ua': return 'https://music.yandex.ua';
                case 'by': return 'https://music.yandex.by';
                case 'kz': return 'https://music.yandex.kz';
                default: return 'https://music.yandex.ru';
            }
        },
        'music-partner': function() {
            return 'http://music-partner.yandex.ru';
        },
        nahodki: function(reg) {
            switch(reg) {
                case 'ua': return 'https://nahodki.yandex.ua';
                case 'kz': return 'https://nahodki.yandex.kz';
                default: return 'https://nahodki.yandex.ru';
            }
        },
        nano: function() {
            return 'http://nano.yandex.ru';
        },
        news: function(reg) {
            switch(reg) {
                case 'ua': return 'https://news.yandex.ua';
                case 'by': return 'https://news.yandex.by';
                case 'kz': return 'https://news.yandex.kz';
                case 'tr': return 'https://haber.yandex.com.tr';
                default: return 'https://news.yandex.ru';
            }
        },
        'news-com': function() {
            return 'https://news.yandex.com';
        },
        notifications: function(reg) {
            switch(reg) {
                case 'ua': return 'https://notifications.yandex.ua';
                case 'by': return 'https://notifications.yandex.by';
                case 'kz': return 'https://notifications.yandex.kz';
                case 'com': return 'https://notifications.yandex.com';
                case 'tr': return 'https://notifications.yandex.com.tr';
                default: return 'https://notifications.yandex.ru';
            }
        },
        oauth: function(reg) {
            switch(reg) {
                case 'com': return 'https://oauth.yandex.com';
                default: return 'https://oauth.yandex.ru';
            }
        },
        online: function() {
            return 'http://online.yandex.ru';
        },
        openid: function() {
            return 'http://openid.yandex.ru';
        },
        opera: function(reg) {
            switch(reg) {
                case 'tr': return 'https://opera.yandex.com.tr';
                default: return 'https://opera.yandex.ru';
            }
        },
        opinion: function() {
            return 'http://opinion.yandex.ru';
        },
        partners: function(reg) {
            switch(reg) {
                case 'ua': return 'http://partner.yandex.ua';
                case 'by': return 'http://partner.yandex.by';
                case 'kz': return 'http://partner.yandex.kz';
                case 'com': return 'http://partner.yandex.com';
                default: return 'http://partner.yandex.ru';
            }
        },
        partnersearch: function() {
            return 'http://yandex.ru';
        },
        passport: function(reg) {
            switch(reg) {
                case 'ua': return 'https://passport.yandex.ua';
                case 'by': return 'https://passport.yandex.by';
                case 'kz': return 'https://passport.yandex.kz';
                case 'com': return 'https://passport.yandex.com';
                case 'tr': return 'https://passport.yandex.com.tr';
                default: return 'https://passport.yandex.ru';
            }
        },
        pdd: function() {
            return 'https://pdd.yandex.ru';
        },
        peoplesearch: function(reg) {
            switch(reg) {
                case 'ua': return 'http://people.yandex.ua';
                default: return 'http://people.yandex.ru';
            }
        },
        perevod: function() {
            return 'https://perevod.yandex.ru';
        },
        probki: function(reg) {
            switch(reg) {
                case 'ua': return 'http://probki.yandex.ua';
                default: return 'http://probki.yandex.ru';
            }
        },
        pulse: function(reg) {
            switch(reg) {
                case 'ua': return 'http://blogs.yandex.ua/pulse';
                case 'by': return 'http://blogs.yandex.by/pulse';
                case 'kz': return 'http://blogs.yandex.kz/pulse';
                default: return 'http://blogs.yandex.ru/pulse';
            }
        },
        punto: function() {
            return 'https://punto.yandex.ru';
        },
        pvo: function() {
            return 'http://ask.yandex.ru';
        },
        rabota: function(reg) {
            switch(reg) {
                case 'ua': return 'https://rabota.yandex.ua';
                case 'by': return 'https://rabota.yandex.by';
                case 'kz': return 'https://rabota.yandex.kz';
                default: return 'https://rabota.yandex.ru';
            }
        },
        rasp: function(reg) {
            switch(reg) {
                case 'ua': return 'https://rasp.yandex.ua';
                case 'by': return 'https://rasp.yandex.by';
                case 'kz': return 'https://rasp.yandex.kz';
                case 'tr': return 'https://seferler.yandex.com.tr';
                default: return 'https://rasp.yandex.ru';
            }
        },
        realty: function(reg) {
            switch(reg) {
                case 'ua': return 'https://realty.yandex.ua';
                case 'by': return 'https://realty.yandex.by';
                case 'kz': return 'https://realty.yandex.kz';
                default: return 'https://realty.yandex.ru';
            }
        },
        referats: function() {
            return 'https://referats.yandex.ru';
        },
        review: function(reg) {
            switch(reg) {
                case 'ua': return 'https://yandex.ua';
                case 'by': return 'https://yandex.by';
                case 'kz': return 'https://yandex.kz';
                case 'com': return 'https://yandex.com';
                case 'tr': return 'https://yandex.com.tr';
                default: return 'https://yandex.ru';
            }
        },
        rk: function() {
            return 'http://rk.yandex.ru';
        },
        root: function() {
            return 'https://root.yandex.ru';
        },
        school: function() {
            return 'http://school.yandex.ru';
        },
        search: function(reg) {
            switch(reg) {
                case 'ua': return 'https://yandex.ua';
                case 'by': return 'https://yandex.by';
                case 'kz': return 'https://yandex.kz';
                case 'com': return 'https://yandex.com';
                case 'tr': return 'https://yandex.com.tr';
                default: return 'https://yandex.ru';
            }
        },
        serp: function(reg) {
            switch(reg) {
                case 'ua': return 'https://yandex.ua';
                case 'by': return 'https://yandex.by';
                case 'kz': return 'https://yandex.kz';
                case 'com': return 'https://yandex.com';
                case 'tr': return 'https://yandex.com.tr';
                default: return 'https://yandex.ru';
            }
        },
        server: function() {
            return 'http://company.yandex.ru/technology/server/';
        },
        shtrafi: function() {
            return 'https://money.yandex.net/debts';
        },
        site: function(reg) {
            switch(reg) {
                case 'ua': return 'https://site.yandex.ua';
                case 'tr': return 'https://ozel.yandex.com.tr';
                default: return 'https://site.yandex.ru';
            }
        },
        slovari: function(reg) {
            switch(reg) {
                case 'ua': return 'https://slovari.yandex.ua';
                case 'by': return 'https://slovari.yandex.by';
                case 'kz': return 'https://slovari.yandex.kz';
                default: return 'https://slovari.yandex.ru';
            }
        },
        so: function() {
            return 'http://so.yandex.ru';
        },
        social: function(reg) {
            switch(reg) {
                case 'ua': return 'https://social.yandex.ua';
                case 'by': return 'https://social.yandex.by';
                case 'kz': return 'https://social.yandex.kz';
                case 'com': return 'https://social.yandex.ru';
                case 'tr': return 'https://social.yandex.com.tr';
                default: return 'https://social.yandex.ru';
            }
        },
        soft: function(reg) {
            switch(reg) {
                case 'ua': return 'https://soft.yandex.ua';
                case 'tr': return 'https://soft.yandex.com.tr';
                default: return 'https://soft.yandex.ru';
            }
        },
        sport: function(reg) {
            switch(reg) {
                case 'ua': return 'http://sport.yandex.ua';
                case 'by': return 'http://sport.yandex.by';
                case 'kz': return 'http://sport.yandex.kz';
                case 'tr': return 'http://spor.yandex.com.tr';
                default: return 'http://sport.yandex.ru';
            }
        },
        sprav: function(reg) {
            switch(reg) {
                case 'ua': return 'https://sprav.yandex.ua';
                case 'by': return 'https://sprav.yandex.by';
                case 'kz': return 'https://sprav.yandex.kz';
                case 'tr': return 'https://rehber.yandex.com.tr';
                default: return 'https://sprav.yandex.ru';
            }
        },
        start: function(reg) {
            switch(reg) {
                case 'ua': return 'https://help.yandex.ua/start/';
                case 'com': return 'https://help.yandex.com/start/';
                case 'tr': return 'https://yardim.yandex.com.tr/start';
                default: return 'https://help.yandex.ru/start/';
            }
        },
        stat: function(reg) {
            switch(reg) {
                case 'ua': return 'https://stat.yandex.ua';
                case 'by': return 'https://stat.yandex.by';
                default: return 'https://stat.yandex.ru';
            }
        },
        subs: function() {
            return 'https://subs.yandex.ru';
        },
        taxi: function() {
            return 'https://taxi.yandex.ru';
        },
        terms: function() {
            return 'http://terms.yandex.ru';
        },
        tests: function() {
            return 'http://tests.yandex.ru';
        },
        ticket: function() {
            return 'http://ticket.yandex.ru';
        },
        time: function(reg) {
            switch(reg) {
                case 'ua': return 'https://time.yandex.ua';
                case 'by': return 'https://time.yandex.by';
                case 'kz': return 'https://time.yandex.kz';
                case 'com': return 'https://time.yandex.com';
                case 'tr': return 'https://saat.yandex.com.tr';
                default: return 'https://time.yandex.ru';
            }
        },
        toster: function() {
            return 'http://toster.yandex.ru';
        },
        translate: function(reg) {
            switch(reg) {
                case 'ua': return 'https://translate.yandex.ua';
                case 'by': return 'https://translate.yandex.by';
                case 'kz': return 'https://translate.yandex.kz';
                case 'com': return 'https://translate.yandex.com';
                case 'tr': return 'https://ceviri.yandex.com.tr';
                default: return 'https://translate.yandex.ru';
            }
        },
        tune: function(reg) {
            switch(reg) {
                case 'ua': return 'https://tune.yandex.ua';
                case 'by': return 'https://tune.yandex.by';
                case 'kz': return 'https://tune.yandex.kz';
                case 'com': return 'https://tune.yandex.com';
                case 'tr': return 'https://tune.yandex.com.tr';
                default: return 'https://tune.yandex.ru';
            }
        },
        tv: function(reg) {
            switch(reg) {
                case 'ua': return 'https://tv.yandex.ua';
                case 'by': return 'https://tv.yandex.by';
                case 'kz': return 'https://tv.yandex.kz';
                default: return 'https://tv.yandex.ru';
            }
        },
        uslugi: function() {
            return 'http://uslugi.yandex.ru';
        },
        video: function(reg) {
            switch(reg) {
                case 'ua': return 'http://yandex.ua/video/';
                case 'by': return 'http://yandex.by/video/';
                case 'kz': return 'http://yandex.kz/video/';
                case 'com': return 'https://yandex.com/video/';
                case 'tr': return 'http://yandex.com.tr/video/';
                default: return 'http://yandex.ru/video/';
            }
        },
        'video-com': function() {
            return 'https://yandex.com/video/';
        },
        vno: function() {
            return 'https://zno.yandex.ua';
        },
        wdgt: function(reg) {
            switch(reg) {
                case 'ua': return 'https://wdgt.yandex.ua';
                case 'by': return 'https://wdgt.yandex.by';
                case 'kz': return 'https://wdgt.yandex.kz';
                case 'tr': return 'https://wdgt.yandex.com.tr';
                default: return 'https://wdgt.yandex.ru';
            }
        },
        weather: function(reg) {
            switch(reg) {
                case 'ua': return 'https://pogoda.yandex.ua';
                case 'by': return 'https://pogoda.yandex.by';
                case 'kz': return 'https://pogoda.yandex.kz';
                case 'tr': return 'https://hava.yandex.com.tr';
                default: return 'https://pogoda.yandex.ru';
            }
        },
        webmaster: function(reg) {
            switch(reg) {
                case 'ua': return 'https://webmaster.yandex.ua';
                case 'com': return 'https://webmaster.yandex.com';
                case 'tr': return 'https://webmaster.yandex.com.tr';
                default: return 'https://webmaster.yandex.ru';
            }
        },
        'webmaster-api': function(reg) {
            switch(reg) {
                case 'com': return 'https://tech.yandex.com/webmaster/';
                case 'tr': return 'https://tech.yandex.com/webmaster/';
                default: return 'https://tech.yandex.ru/webmaster/';
            }
        },
        widgets: function(reg) {
            switch(reg) {
                case 'ua': return 'https://widgets.yandex.ua';
                case 'by': return 'https://widgets.yandex.by';
                case 'kz': return 'https://widgets.yandex.kz';
                case 'tr': return 'https://widgets.yandex.com.tr';
                default: return 'https://widgets.yandex.ru';
            }
        },
        wordstat: function() {
            return 'https://wordstat.yandex.ru';
        },
        wow: function() {
            return 'http://my.ya.ru';
        },
        www: function(reg) {
            switch(reg) {
                case 'ua': return 'https://yandex.ua';
                case 'by': return 'https://yandex.by';
                case 'kz': return 'https://yandex.kz';
                case 'com': return 'https://yandex.com';
                case 'tr': return 'https://yandex.com.tr';
                default: return 'https://yandex.ru';
            }
        },
        xmlsearch: function(reg) {
            switch(reg) {
                case 'ua': return 'https://xml.yandex.ua';
                case 'by': return 'https://xml.yandex.by';
                case 'kz': return 'https://xml.yandex.kz';
                case 'com': return 'https://xml.yandex.com';
                case 'tr': return 'https://xml.yandex.com.tr';
                default: return 'https://xml.yandex.ru';
            }
        },
        yaca: function(reg) {
            switch(reg) {
                case 'ua': return 'https://yaca.yandex.ua';
                case 'by': return 'https://yaca.yandex.by';
                default: return 'https://yaca.yandex.ru';
            }
        },
        yamb: function() {
            return 'https://yamb.yandex.ru';
        },
        zakladki: function() {
            return 'http://zakladki.yandex.ru';
        }
    };
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/i-services/__uri/i-services__uri.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/link/link.bemhtml.js */
block('link')(
    def()(function() {
        var mods = this.mods;

        /* jshint ignore:line *//* jscs:ignore */(/*%%%ISLDEBUG%%%*/+0 && console.assert(
            mods.outer || mods.pseudo || mods.theme,
            'link: В islands 5.0 модификатор theme_normal больше не выставляется по умолчанию'));
        /* jshint ignore:line *//* jscs:ignore */(/*%%%ISLDEBUG%%%*/+0 && console.assert(!mods.outer, 'link: В islands 5.0 модификатор outer будет удалён. Используйте theme_outer.'));
        /* jshint ignore:line *//* jscs:ignore */(/*%%%ISLDEBUG%%%*/+0 && console.assert(
            !mods.pseudo,
            'link: В islands 5.0 модификатор theme_pseudo больше не выставляется по умолчанию при наличии pseudo_yes'));
        /* jshint ignore:line *//* jscs:ignore */(/*%%%ISLDEBUG%%%*/+0 && console.assert(Object(this.ctx.attrs).target === undefined, 'link: Атрибут target необходимо устанавливать ' +
            'в контексте блока, а не через атрибуты блока.'));

        // DEPRECATED: Для совместимости. Оторвать в 5.0. Тема должна быть указана в BEMJSON. Всегда.
        if(!mods.theme && !this.ctx.notheme) {
            mods.theme = (mods.outer && 'outer') || (mods.pseudo && 'pseudo') || 'normal';
        }

        // В Opera 12 ссылки по умолчанию не участвуют в taborder. В других браузерах участвуют.
        // В качестве нормализации по дефолту выставляем всем ссылкам tabindex:0.
        if(this.ctx.tabindex === undefined) {
            this.ctx.tabindex = '0';
        }

        return applyNext();
    }),

    tag()(function() {
        return (this.ctx.url !== undefined) ? 'a' : 'span';
    }),

    js()(function() {
        return {
            _tabindex: this.ctx.tabindex,
            origTabindex: this.ctx.tabindex // DEPRECATED: Удалить в 5.0. Параметр должен называться _tabindex.
        };
    }),

    match(function() { return this.ctx.target === '_blank'; }).attrs()(function() {
        var ctx = this.ctx,
            attrs = ctx.attrs,
            hasRel = Object(attrs).rel !== undefined,
            rel = hasRel ? String(attrs.rel) : '';

        if(rel && rel.indexOf('noopener') === -1) {
            attrs.rel = rel + ' noopener'; // Пользовательский атрибут имеет больший приоритет в BEMHTML
        }

        return this.extend(applyNext(), {
            rel: 'noopener'
        });
    }),

    attrs()(function() {
        var ctx = this.ctx,
            url = ctx.url,
            hasURL = (url !== undefined),
            isDisabled = Boolean(this.mods.disabled); // https://github.com/bem/bem-xjst/issues/97

        return this.extend(applyNext(), {
            id: ctx.id,
            name: ctx.name,
            title: ctx.title,
            target: ctx.target,
            tabindex: isDisabled ? undefined : ctx.tabindex,
            href: hasURL ? (this.isSimple(url) ? url : this.reapply(url)) : undefined, // Могут передать BEMJSON с I18N.
            role: hasURL ? undefined : 'button',
            'aria-disabled': isDisabled ? 'true' : undefined
        });
    }),

    match(function() { return this.ctx.content === undefined; }).content()(function() {
        var ctx = this.ctx,
            hasText = Boolean(ctx.text),
            hasIcon = Boolean(ctx.icon);

        return [
            hasIcon && this.util.mergeBemjson({
                block: 'icon',
                mix: {block: 'link', elem: 'icon'}
            }, ctx.icon),

            hasText && (this.isSimple(ctx.text)
                ? hasIcon
                    ? {elem: 'inner', content: this.xmlEscape(ctx.text)}
                    : this.xmlEscape(ctx.text)
                : ctx.text.block
                    ? this.util.mergeBemjson({mix: {block: 'link', elem: 'inner'}}, ctx.text)
                    : this.extend({block: 'link', elem: 'inner'}, ctx.text))
        ];
    }),

    elem('inner').tag()('span')
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/link/link.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup/_has-close/popup_has-close_yes.bemhtml.js */
block('popup').mod('has-close', 'yes')
    .content()(function() {
        return [
            applyNext(),
            {elem: 'close'}
        ];
    });

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/popup/_has-close/popup_has-close_yes.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button/_disabled/button_disabled_yes.bemhtml.js */
block('button').mod('disabled', 'yes')
    .attrs()(function() {
        var ctx = this.ctx,
            a = {};

        if(ctx.url) {
            a['aria-disabled'] = 'true';
        } else {
            a.disabled = 'disabled';
        }

        return this.extend(applyNext(), a);
    });

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button/_disabled/button_disabled_yes.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/input.bemhtml.js */
block('input')(
    tag()('span'),

    mode('live')(false),

    mode('getLive')(function() {
        var live = apply('live'),
            js = this.ctx.js,
            mods = this.ctx.mods,
            noLive = {autofocus: 'yes', width: 'content', 'tap-ahead': 'yes'};

        if(js) {
            if(js.autoFocus && js.live) {
                // Ошибка появляется только если оба live и autofocus явно выставлены в
                // bemjson
                throw new Error('input block can\'t have both "live" and "autoFocus" enabled');
            }

            if(js.live !== undefined) {
                live = js.live;
            }

            var noLiveMods = Object.keys(noLive)
                .some(function(key) {
                    return mods[key] === noLive[key];
                });

            if(noLiveMods || js.autoFocus) {
                // В случае, когда шаблон доопределен таким образом, чтобы все поля ввода
                // по умолчанию инициализировались лениво иногда надо отключать ленивую
                // live-инициализацию (для совместимости с прошлыми версиями)
                live = false;
            }
        }
        return live;
    }),

    js()(function() {
        return {live: this._live};
    }),

    def()(function() {
        var value = apply('value', {ctx: this.ctx.value}),
            id = this.ctx.id || this.generateId(),
            mods = this.ctx.mods || {},
            live = apply('getLive', {}),
            ctxPlaceholder = this.ctx.placeholder,
            placeholder;

        mods.theme = mods.theme || 'normal';

        if(this.ctx.hasOwnProperty('placeholder')) {
            placeholder = this.isSimple(ctxPlaceholder) ? ctxPlaceholder : this.reapply(ctxPlaceholder);
        }

        return applyNext({
            _inputId: id,
            _labelId: 'label' + id,
            _hintId: 'hint' + id,
            _name: this.ctx.name || '',
            _value: value,
            _inputLink: true,
            _iconLeft: this.ctx.icon || this.ctx.iconLeft,
            _iconRight: this.ctx.iconRight,
            _disabled: this.mods && this.mods.disabled,
            _live: live,
            _placeholder: placeholder,
            'ctx.mods': mods
        });
    }),

    mode('value')(
        '',

        match(function() { return this.ctx; })(function() {
            return this.reapply(this.ctx);
        }),

        match(function() { return this.isSimple(this.ctx); })(function() {
            return this.ctx;
        })
    )
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/input.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/__clear/input__clear.bemhtml.js */
block('input').elem('clear')(
    tag()('span'),

    attrs()(function() {
        // Нужен для того чтобы элемент не выкидывал события focusin и focusout в IE 9+,
        // вызывающие проблемы когда input используется вместе с блоком slider
        // см. http://st/ISLCOMPONENTS-566
        return {unselectable: 'on'};
    }),

    // &nbsp; — fixed bug FF/Linux.
    // After text selection left-click on an item that has no content, the buffer is cleared
    // Delete &nbsp; for fix bug with text selection.
    // I think we don't need anymore FF-3 on linux with X11 ;)
    content().match(function() { return !this.ctx.content; })('')
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/__clear/input__clear.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/__hint/input__hint.bemhtml.js */
block('input').elem('hint')(
    tag()('label'),

    attrs()(function() {
        return {
            id: this._hintId,
            'for': this._inputId,
            'aria-hidden': 'true'
        };
    }),

    def()(function() {
        if(this._iconLeft) {
            this.elemMods.lpad = 'yes';
        }
        if(this._iconRight) {
            this.elemMods.rpad = 'yes';
        }
        if(!this._value && this._value !== 0) {
            this.elemMods.visibility = 'visible';
        }
        return applyNext();
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/__hint/input__hint.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/m-suggest-item.bemhtml.js */
block('m-suggest-item')(
    js()(function() {
        return {
            inputData: this.ctx.inputData,
            inSearchHeader: this.ctx.inSearchHeader,
            fullData: this.ctx.data
        };
    }),
    elem('selected').tag()('b'),
    elem('black')(
        tag()('span'),
        attrs()({
            style: 'color: black;'
        })
    )
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/m-suggest-item.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_department.bemhtml.js */
block('m-suggest-item').mod('type', 'department')(
    js()(function() {
        var data = this.ctx.data;
        return this.extend(applyNext(), {
            value: data.name
        });
    }),
    content()(function() {
        var before, after, name = this.ctx.data.name,
            indexOfInputText = name.indexOf(this.ctx.inputData.text),
            content;
        if (indexOfInputText !== -1) {
            before = name.substr(0, indexOfInputText);
            after = name.substr((indexOfInputText + this.ctx.inputData.text.length));
            content = [this['mi-helpers'].htmlSpecialChars(before), {
                elem: 'selected',
                content: this['mi-helpers'].htmlSpecialChars(this.ctx.inputData.text)
            }, this['mi-helpers'].htmlSpecialChars(after)];
        } else {
            content = this['mi-helpers'].htmlSpecialChars(name);
        }
        return {
            elem: 'info-wrapper',
            content: content
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_department.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_maillist.bemhtml.js */
block('m-suggest-item').mod('type', 'maillist')(
    js()(function() {
        var data = this.ctx.data;
        return this.extend(applyNext(), {
            value: (data.email || data.name)
        });
    }),
    content()(function() {
        var before, after, name, mail, indexOfInputText, content;
        if (this.ctx.data.email === this.ctx.data.name) {
            mail = this.ctx.data.email.replace(/(.*@)/, '');
            name = this.ctx.data.email.replace(name, '');
        } else {
            name = this.ctx.data.name + (this.ctx.data.email && '@');
            mail = this.ctx.data.email.replace(name, '');
        }
        indexOfInputText = (name + mail).indexOf(this.ctx.inputData.text);
        if (indexOfInputText !== -1) {
            before = name.substr(0, indexOfInputText);
            after = name.substr((indexOfInputText + this.ctx.inputData.text.length));
            content = [this['mi-helpers'].htmlSpecialChars(before), {
                elem: 'selected',
                content: this['mi-helpers'].htmlSpecialChars(this.ctx.inputData.text)
            }, this['mi-helpers'].htmlSpecialChars(after)];
        } else {
            content = this['mi-helpers'].htmlSpecialChars(name);
        }
        return {
            elem: 'info-wrapper',
            content: [{
                elem: 'black',
                content: content
            }, mail]
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_maillist.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_group.bemhtml.js */
block('m-suggest-item').mod('type', 'group')(
    js()(function() {
        var data = this.ctx.data;
        return this.extend(applyNext(), {
            value: data.name
        });
    }),
    content()(function() {
        var before, after, name = this.ctx.data.name,
            indexOfInputText = name.indexOf(this.ctx.inputData.text),
            content;
        if (indexOfInputText !== -1) {
            before = name.substr(0, indexOfInputText);
            after = name.substr((indexOfInputText + this.ctx.inputData.text.length));
            content = [this['mi-helpers'].htmlSpecialChars(before), {
                elem: 'selected',
                content: this['mi-helpers'].htmlSpecialChars(this.ctx.inputData.text)
            }, this['mi-helpers'].htmlSpecialChars(after)];
        } else {
            content = this['mi-helpers'].htmlSpecialChars(name);
        }
        return {
            elem: 'info-wrapper',
            content: content
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_group.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_table.bemhtml.js */
block('m-suggest-item').mod('type', 'table')(
    js()(function() {
        var data = this.ctx.data;
        return this.extend(applyNext(), {
            value: data.name
        });
    }),
    content()(function() {
        var before, after, data = this.ctx.data,
            office = data['office_name'],
            name = data.id + ', ' + data['status_display'],
            indexOfInputText = name.indexOf(this.ctx.inputData.text),
            mainInfo, content;
        if (parseInt(data['floor_display']) >= 0) {
            office += (', ' + data['floor_display'].replace('floor', BEM.I18N('m-suggest-item', 'floor')));
        }
        if (indexOfInputText !== -1) {
            before = name.substr(0, indexOfInputText);
            after = name.substr((indexOfInputText + this.ctx.inputData.text.length));
            content = [this['mi-helpers'].htmlSpecialChars(before), {
                elem: 'selected',
                content: this['mi-helpers'].htmlSpecialChars(this.ctx.inputData.text)
            }, this['mi-helpers'].htmlSpecialChars(after)];
        } else {
            content = this['mi-helpers'].htmlSpecialChars(name);
        }
        mainInfo = [{
            elem: 'info-wrapper',
            content: [{
                elem: 'table',
                content: content
            }, {
                elem: 'office',
                content: office
            }]
        }];
        return mainInfo;
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_table.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_equipment.bemhtml.js */
block('m-suggest-item').mod('type', 'equipment')(
    js()(function() {
        var data = this.ctx.data;
        return this.extend(applyNext(), {
            value: data.name
        });
    }),
    content()(function() {
        var before, after, data = this.ctx.data,
            office = data['office_name'],
            name = data.name + ', ' + data['type_display'],
            indexOfInputText = name.indexOf(this.ctx.inputData.text),
            mainInfo, content;
        if (parseInt(data['floor_display']) >= 0) {
            office += (', ' + data['floor_display'].replace('floor', BEM.I18N('m-suggest-item', 'floor')));
        }
        if (indexOfInputText !== -1) {
            before = name.substr(0, indexOfInputText);
            after = name.substr((indexOfInputText + this.ctx.inputData.text.length));
            content = [this['mi-helpers'].htmlSpecialChars(before), {
                elem: 'selected',
                content: this['mi-helpers'].htmlSpecialChars(this.ctx.inputData.text)
            }, this['mi-helpers'].htmlSpecialChars(after)];
        } else {
            content = this['mi-helpers'].htmlSpecialChars(name);
        }
        mainInfo = [{
            elem: 'info-wrapper',
            content: [{
                elem: 'equipment',
                content: content
            }, {
                elem: 'office',
                content: office
            }]
        }];
        return mainInfo;
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_equipment.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_simple.bemhtml.js */
block('m-suggest-item').mod('type', 'simple')(
    js()(function() {
        var data = this.ctx.data,
            baseJS = applyNext();
        baseJS.value = data.text;
        return baseJS;
    }),
    content()(function() {
        var content, text = this.ctx.data.text || '',
            indexOfInputText = text.indexOf(this.ctx.inputData.text);
        if (indexOfInputText !== -1) {
            content = [text.substr(0, indexOfInputText), {
                elem: 'selected',
                content: this.ctx.inputData.text
            }, text.substr((indexOfInputText + this.ctx.inputData.text.length))];
        } else {
            content = text;
        }
        return content;
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_simple.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_room.bemhtml.js */
block('m-suggest-item').mod('type', 'room')(
    js()(function() {
        var data = this.ctx.data;
        return this.extend(applyNext(), {
            value: data.name
        });
    }),
    content()(function() {
        var data = this.ctx.data,
            helpers = this['mi-helpers'],
            name = (data.name ? (data.name + ', ') : '') + data['type_display'],
            office = data['office_name'],
            content = [];

        function highlightSearch(input, search, regular, highlighted) {
            if (!search) {
                regular(input);
            } else {
                var lastIndex = 0;
                input.replace(new RegExp(search, 'gi'), function(match, index) {
                    if ((lastIndex != index)) {
                        regular(input.slice(lastIndex, index));
                    }
                    highlighted(match);
                    (lastIndex = (index + match.length));
                });
                if (input.length > lastIndex) {
                    regular(input.substr(lastIndex));
                }
            }
        };
        highlightSearch(name, this.ctx.inputData.text, function(str) {
            content.push(helpers.htmlSpecialChars(str));
        }, function(str) {
            content.push({
                elem: 'selected',
                content: helpers.htmlSpecialChars(str)
            });
        });
        return [{
            elem: 'info-wrapper',
            content: [{
                elem: 'room',
                content: content
            }, {
                elem: 'office',
                content: office
            }]
        }];
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_room.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-group/m-suggest-group.bemhtml.js */
block('m-suggest-group').content()(function() {
    var res = this.ctx.content;
    if (this.ctx.groupLabel) {
        res = [{
            elem: 'group-label',
            content: (this.ctx.groupLabel && BEM.I18N('m-suggest-item', this.ctx.groupLabel))
        }, res];
    }
    return res;
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-group/m-suggest-group.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button2/_type/button2_type_submit.bemhtml.js */
block('button2').mod('type', 'submit')
    .attrs()(function() {
        return this.extend(applyNext(), {
            type: 'submit'
        });
    });

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/button2/_type/button2_type_submit.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-user/m-head-user.bemhtml.js */
block('m-head-user')(
    js()(true),
    content()(function() {
        var content, customLinks = this.ctx.customUserLinks,
            my = (customLinks && customLinks.my) || false,
            settings = (customLinks && customLinks.settings) || false;
        content = [{
            block: 'm-userpic',
            mix: [{
                block: this.blockName,
                elem: 'icon'
            }],
            login: this.ctx.user,
            size: 100
        }, {
            block: 'popup2',
            mix: {
                block: this.block,
                elem: 'popup'
            },
            mods: {
                target: 'anchor',
                autoclosable: 'yes',
                theme: 'normal'
            },
            directions: ['bottom-right'],
            mainOffset: 0,
            secondaryOffset: 0,
            content: [{
                block: 'm-head-services',
                mods: {
                    column: 'mono',
                    type: 'user'
                },
                content: {
                    elem: 'list',
                    content: [{
                        block: 'link',
                        mix: [{
                            block: 'awesome-icon',
                            mods: {
                                icon: 'user'
                            }
                        }],
                        url: ((my && my.url) || '//staff.yandex-team.ru/'),
                        content: ((my && my.text) || BEM.I18N('m-head-user', 'staff'))
                    }, {
                        block: 'link',
                        mix: [{
                            block: 'awesome-icon',
                            mods: {
                                icon: 'cog'
                            }
                        }],
                        url: ((settings && settings.url) || '//staff.yandex-team.ru/settings/'),
                        content: ((settings && settings.text) || BEM.I18N('m-head-user', 'options'))
                    }, {
                        block: 'link',
                        mix: [{
                            block: 'awesome-icon',
                            mods: {
                                icon: 'sign-out'
                            }
                        }],
                        url: '//passport.yandex-team.ru/passport?mode=logout',
                        content: BEM.I18N('m-head-user', 'logout')
                    }]
                }
            }]
        }];
        return content;
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-user/m-head-user.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/bundles/static/blocks/cab-page/__content/cab-page__content.bemhtml.js */
block('cab-page').elem('content').content()(function() {
    var code = String(_.get(this.ctx, 'data.error.code', ''));
    var message = String(_.get(this.ctx, 'data.error.message', ''));

    if (!message && code) {
        message = BEM.I18N('cab-error', code);
    }

    return {
        block: 'cab-error',
        mods: {theme: 'page'},
        content: [
            code && {
                elem: 'code',
                content: code
            },
            message && {
                elem: 'message',
                content: message
            }
        ]
    };
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/bundles/static/blocks/cab-page/__content/cab-page__content.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/footer/__link/footer__link.bemhtml.js */
block('footer').elem('link')
    .def()(function() {
        var ctx = this.extend(this.ctx, {
            block: 'link',
            mix: [{
                block: this.block,
                elem: this.elem,
                elemMods: this.elemMods
            }]
        });

        this.ctx.mix && (ctx.mix = ctx.mix.concat(this.ctx.mix));

        delete ctx.elem;
        delete ctx.elemMods;

        return applyCtx(ctx);
    });

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/footer/__link/footer__link.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/b-page.bemhtml.js */
block('b-page')(
    elem('root').attrs()(function() {
        return {
            lang: this['i-global'].lang || 'ru'
        };
    }),

    mode('js-params')(function() {
        var glob = this['i-global'],
            js = {},
            block = {block: 'i-global', js: js};

        // (NOTE): наполняем параметры передаваемые в JS
        Object.keys(glob).forEach(function(param) {
            if(glob.isPublic(param)) {
                js[param] = glob[param];
            }
        });

        return block;
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/b-page/b-page.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/desktop.blocks/b-page/b-page.bemhtml.js */
block('b-page')(
    mode('doctype')(function() {
        return this.ctx.doctype || '<!DOCTYPE html>';
    }),

    mode('xUACompatible')(function() {
        return this.ctx['x-ua-compatible'] === false ? false : {
            tag: 'meta',
            attrs: {
                'http-equiv': 'X-UA-Compatible',
                content: (this.ctx['x-ua-compatible'] || 'IE=edge')
            }
        };
    }),

    once().def()(function() {
        var ctx = this.ctx,
            dtype = apply('doctype'),
            xUA = apply('xUACompatible'),
            buf = [
                dtype,
                {
                    elem: 'root',
                    content: [
                        {
                            elem: 'head',
                            content: [
                                ctx.csp && this.extend(ctx.csp, {elem: 'csp'}),
                                {
                                    tag: 'meta',
                                    attrs: {charset: 'utf-8'}
                                },
                                xUA,
                                (ctx.title !== undefined) && {
                                    tag: 'title',
                                    content: ctx.title
                                },
                                ctx.favicon ? {
                                    elem: 'favicon',
                                    url: ctx.favicon
                                } : '',
                                ctx.meta,
                                {
                                    block: 'i-ua',
                                    nonce: ctx.nonce // TODO: @deprecated, удалить в 4x
                                },
                                ctx.head
                            ]
                        },
                        ctx
                    ]
                }
            ];

        return applyCtx(buf);
    }),

    tag()('body'),

    elem('root')(
        bem()(false),
        tag()('html'),
        cls()('i-ua_js_no i-ua_css_standard')
    ),

    elem('head')(
        bem()(false),
        tag()('head')
    ),

    elem('meta')(
        bem()(false),
        tag()('meta'),
        attrs()(function() {
            return this.ctx.attrs;
        })
    ),

    elem('favicon').def()(function() {
        return applyCtx({
            elem: 'link',
            rel: 'shortcut icon',
            url: this.ctx.url
        });
    }),

    // (NOTE, varankinv@): после LEGO-8149 в `b-page` нет элемента `__body`,
    // сам блок используется для отрисовки `<body>`
    // (XXX): пустой элемент `__body` для сервисов самостоятельно
    // расширяющих блок (2.10.5 fallback)
    // (TODO): оторвать в 2.11
    content()(function() {
        return {
            elem: 'body',
            content: this.ctx.content
        };
    }),

    elem('body').tag()(''),

    mix()(function() {
        return [].concat(applyNext(), [
            {elem: 'body'},
            apply('js-params'),
            {block: 'i-ua', js: true}
        ]);
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/desktop.blocks/b-page/b-page.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/link/_pseudo/link_pseudo_yes.bemhtml.js */
block('link').mod('pseudo', 'yes')(
    content().match(function() { return !this.mods.inner; })(function() {
        return {
            elem: 'inner',
            content: applyNext()
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/link/_pseudo/link_pseudo_yes.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-action/m-head-action.bemhtml.js */
block('m-head-action')(
    def()(function() {
        var ctx = this.ctx;
        if (ctx.action && ctx.action.items) {
            ctx.mods = this.extend(ctx.mods, {
                with: 'popup'
            });
        }
        return applyNext();
    }),
    content()(function() {
        var action = this.ctx.action,
            isObject = typeof action === 'object';
        return {
            block: 'button',
            mods: {
                size: 'm'
            },
            url: (isObject ? action.url : false),
            content: (isObject ? action.content : action)
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-action/m-head-action.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_staff.bemhtml.js */
block('m-suggest-item').mod('type', 'staff')(
    js()(function() {
        var data = this.ctx.data,
            baseJS = applyNext();
        baseJS.value = data.valueField ? data[data.valueField] : (data.title || data._text);
        return baseJS;
    }),
    content()(function() {
        var data = this.ctx.data,
            department = data['department__name'] || data.department,
            phone = data.phone || data['work_phone'],
            indexOfInputText = data.login.indexOf(this.ctx.inputData.text),
            mainInfo, content;
        if (indexOfInputText !== -1) {
            content = [data.login.substr(0, indexOfInputText), {
                elem: 'selected',
                content: this.ctx.inputData.text
            }, data.login.substr((indexOfInputText + this.ctx.inputData.text.length))];
        } else {
            content = data.login;
        }
        mainInfo = [{
            elem: 'info-wrapper',
            content: [{
                elem: 'general-info',
                elemMods: {
                    short: (phone ? 'yes' : '')
                },
                content: [{
                    elem: 'fullname',
                    content: (this['mi-helpers'].htmlSpecialChars((data.title || data._text)) + ', ')
                }, {
                    elem: 'brief',
                    content: [content, '@']
                }]
            }, {
                elem: 'phone',
                content: (phone ? [{
                    block: 'awesome-icon',
                    mods: {
                        icon: 'phone'
                    }
                }, (' ' + phone)] : '')
            }, {
                elem: 'info',
                content: this['mi-helpers'].htmlSpecialChars(department)
            }]
        }, {
            block: 'm-userpic',
            size: '50',
            login: data.login
        }];
        return mainInfo;
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_type/m-suggest-item_type_staff.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_labels/m-suggest-item_labels_yes.bemhtml.js */
block('m-suggest-item').mod('labels', 'yes').content()(function() {
    return [{
        elem: 'item-label',
        content: BEM.I18N('m-suggest-item', this.ctx.mods.type)
    }, applyNext()];
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_labels/m-suggest-item_labels_yes.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_link/m-suggest-item_link_yes.bemhtml.js */
block('m-suggest-item').mod('link', 'yes')(
    js()(function() {
        var baseJS = applyNext();
        baseJS.href = this.ctx.data.href + '?from=suggest';
        return baseJS;
    }),
    tag()('a'),
    attrs()(function() {
        return {
            href: (this.ctx.data.href + '?from=suggest'),
            target: this.ctx.data.target
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest-item/_link/m-suggest-item_link_yes.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/_type/input_type_textarea.bemhtml.js */
block('input').mod('type', 'textarea').elem('control')(
    tag()('textarea'),

    attrs()(function() {
        var a = applyNext({_value: null});
        return this.extend(a, {rows: 10, cols: 10});
    }),

    content()(function() {
        return this.xmlEscape(this._value || this.ctx.content || '');
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/islands/common.blocks/input/_type/input_type_textarea.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/blocks/desktop/cab-page/cab-page.bemhtml.js */
block('cab-page')(
    mode('head')(function() {
        var bundle = String(this.ctx.bundle);
        var bundlePath = '/media/_/' + bundle + '/' + bundle;

        return [
            {
                elem: 'css',
                url: '//yastatic.net/tools-wf/1.57.10/v-3/purewf.css'
            },
            {
                elem: 'css',
                url: bundlePath + '.css'
            },
            {
                elem: 'js',
                url: '//yastatic.net/jquery/2.2.3/jquery.min.js'
            },
            {
                elem: 'js',
                url: '//yastatic.net/lodash/4.10.0/lodash.min.js'
            },
            {
                elem: 'js',
                url: bundlePath + '.js'
            },
            {
                elem: 'js',
                url: bundlePath + '.bemhtml.js'
            },
            {
                elem: 'js',
                url: bundlePath + '.lang.' + _.get(this.ctx, 'data.lang') + '.js'
            },
            {
                elem: 'js',
                url: '//yastatic.net/tools-wf/1.57.10/v-3/purewf.js'
            },
            {
                elem: 'link',
                rel: 'icon',
                type: 'image/png',
                url: '/favicon-16.png',
                sizes: '16x16'
            },
            {
                elem: 'link',
                rel: 'icon',
                type: 'image/png',
                url: '/favicon-32.png',
                sizes: '32x32'
            },
            {
                elem: 'link',
                rel: 'icon',
                type: 'image/png',
                url: '/favicon-64.png',
                sizes: '64x64'
            },
            {
                elem: 'link',
                type: 'image/png',
                rel: 'apple-touch-icon',
                mods: {type: 'apple'},
                url: '/favicon-64.png',
                sizes: '60x60'
            }
        ];
    }),
    mode('title')(function() {
        return BEM.I18N(this.block, 'page.' + this.mods.type);
    }),
    replace()(function() {
        return {
            block: 'b-page',
            mods: {lang: _.get(this.ctx, 'data.lang')},
            mix: {
                block: this.block,
                mods: this.mods,
                js: apply('js') || true
            },
            title: apply('title'),
            head: apply('head'),
            content: [
                ['head', 'content', 'foot'].map(function(elem) {
                    return {
                        block: this.block,
                        mods: this.mods,
                        elem: elem,
                        data: this.ctx.data
                    };
                }, this),
                {
                    block: 'b-statcounter',
                    content: [
                        {
                            elem: 'metrika',
                            elemMods: {type: 'js'},
                            counter: 156784
                        }
                    ]
                }
            ]
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/blocks/desktop/cab-page/cab-page.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/bundles/static/blocks/cab-page/cab-page.bemhtml.js */
block('cab-page')(
    def()(function() {
        this.mods.code = _.get(this.ctx, 'data.error.code');

        return applyNext();
    }),
    mode('title')(function() {
        var title = apply('title');
        var code = String(_.get(this.ctx, 'data.error.code', ''));

        return title + (code ? (' ' + code) : '');
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/bundles/static/blocks/cab-page/cab-page.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-arrow/m-head-arrow.bemhtml.js */
block('m-head-arrow').content()(function() {
    return [{
        block: 'awesome-icon',
        mods: {
            icon: 'reorder'
        }
    }, {
        elem: 'home',
        tag: 'span',
        mix: [{
            block: 'i-font',
            mods: {
                face: 'textbook'
            }
        }],
        content: this.ctx.title
    }, {
        block: 'popup2',
        mods: {
            target: 'position',
            theme: 'normal',
            autoclosable: 'yes'
        },
        mix: {
            block: 'm-head-arrow',
            elem: 'popup'
        },
        directions: ['bottom-left'],
        content: ''
    }];
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-arrow/m-head-arrow.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-menu/m-head-menu.bemhtml.js */
block('m-head-menu').mod('type', 'main')(
    tag()('menu'),
    js()(true),
    content()(function() {
        return [{
            elem: 'list',
            menuItems: this.ctx.menuItems
        }, {
            block: 'popup',
            mix: {
                block: this.block,
                mods: {type: this.ctx.headTypeMod},
                elem: 'popup'
            },
            mods: {
                animate: 'no',
                'has-close': 'yes'
            },
            js: {
                directions: {
                    to: 'bottom',
                    axis: 'left',
                    offset: {
                        top: (-54),
                        left: (-17)
                    }
                }
            },
            content: [{
                elem: 'content',
                content: ''
            }]
        }];
    })
);

block('m-head-menu').elem('list').content()(function() {
    return this.ctx.menuItems.map(function(item) {
        var listElem;
        if (item.more) {
            (listElem = {
                elem: 'more',
                content: [{
                    block: 'link',
                    mods: {
                        type: 'more'
                    },
                    content: '…'
                }, {
                    block: 'popup',
                    mix: {
                        block: 'm-head-menu',
                        elem: 'more-popup'
                    },
                    mods: {
                        theme: 'ffffff',
                        animate: 'yes'
                    },
                    js: {
                        directions: {
                            to: 'bottom',
                            axis: 'left',
                            offset: {
                                top: (-10),
                                left: (-11)
                            }
                        }
                    },
                    content: [{
                        elem: 'tail'
                    }, {
                        elem: 'content',
                        content: {
                            block: 'm-head-menu',
                            mods: {
                                type: 'open',
                                mode: 'more'
                            },
                            content: [{
                                elem: 'item',
                                content: [{
                                    elem: 'list',
                                    menuItems: item.subs
                                }]
                            }]
                        }
                    }]
                }]
            });
        } else {
            (listElem = {
                elem: 'item',
                elemMods: {},
                content: [{
                    block: 'link',
                    mods: (item.mods ? item.mods : false),
                    mix: (item.mix || ''),
                    url: (!item.subs && item.url),
                    content: item.name
                }]
            });
        }
        if ((item.subs && !item.more)) {
            (listElem.elemMods.hassub = 'yes');
            (listElem.attrs = {
                'data-content': JSON.stringify({
                    block: 'm-head-menu',
                    mods: {
                        type: 'open'
                    },
                    content: [{
                        elem: 'item',
                        elemMods: {
                            hassub: 'yes'
                        },
                        content: [{
                            block: 'link',
                            mods: {
                                menu: 'title'
                            },
                            content: [item.name, {
                                block: 'awesome-icon',
                                mods: {
                                    icon: 'chevron-down'
                                }
                            }]
                        }, {
                            elem: 'list',
                            menuItems: item.subs
                        }]
                    }]
                })
            });
            (listElem.content[0].mods = {
                pseudo: 'yes'
            });
            (listElem.content[0].content = [listElem.content[0].content, {
                block: 'awesome-icon',
                mods: {
                    icon: 'chevron-down'
                }
            }]);
        }
        if (item.current) {
            (listElem.elemMods.current = 'yes');
        }
        if (item.customParams) {
            (listElem.customParams = item.customParams);
        }
        return listElem;
    }, this);
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-menu/m-head-menu.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest/m-suggest.bemhtml.js */
block('m-suggest')(
    def()(
        match(function() {
            return !this.ctx.mods;
        })(function() {
            var ctx = this.ctx;
            ctx.mods = {
                size: 's'
            };
            return applyNext();
        }),
        match(function() {
            return !this.mods.size;
        })(function() {
            this.mods.size = 's';
            return applyNext();
        }),
        match(function() {
            return !this.ctx.inputMods || !this.ctx.inputMods.size;
        })(function() {
            var ctx = this.ctx;
            ctx.inputMods = this.extend(ctx.inputMods, {
                size: ((ctx.mods && ctx.mods.size) || 's')
            });
            return applyNext();
        })
    ),
    js()(function() {
        return {
            types: (this.ctx.types || ['staff']),
            labels: this.ctx.labels,
            inHeader: this.ctx.inHeader,
            inSearchHeader: this.ctx.inSearchHeader,
            multiple: this.ctx.multiple,
            url: this.ctx.url,
            dataKey: this.ctx.dataKey,
            textKey: this.ctx.textKey,
            maxCount: this.ctx.maxCount,
            target: this.ctx.target
        };
    }),
    content()(function() {
        var hint = {
                elem: 'hint',
                content: this.ctx.hint
            },
            found = {
                elem: 'found',
                content: this.ctx.found
            };
        return [{
            block: 'input',
            mods: this.ctx.inputMods,
            content: [(this.ctx.found ? found : ''), (this.ctx.hint ? hint : ''), {
                elem: 'control',
                attrs: this.extend({
                    name: 'text',
                    autocomplete: 'off'
                }, this.ctx.inputAttrs)
            }],
            value: this.ctx.value
        }];
    }),
    elem('popup-items').tag()('ul')
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-suggest/m-suggest.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-orange-actions/m-orange-actions.bemhtml.js */
block('m-orange-actions').content()(function() {
    var content;
    if (this.ctx.answer && this.ctx.answer > 1) {
        if (this.ctx.answer == 2) {
            content = [{
                block: 'awesome-icon',
                mods: {
                    icon: 'check'
                }
            }, BEM.I18N('m-orange-actions', 'accepted')];
        } else {
            content = [{
                block: 'awesome-icon',
                mods: {
                    icon: 'remove'
                }
            }, BEM.I18N('m-orange-actions', 'declined')];
        }
    } else {
        content = [{
            block: 'button',
            mods: {
                size: 's',
                theme: 'action',
                action: 'accept'
            },
            content: [{
                block: 'awesome-icon',
                mods: {
                    icon: 'check'
                }
            }, BEM.I18N('m-orange-actions', 'accept')]
        }, {
            block: 'button',
            mods: {
                size: 's',
                action: 'decline'
            },
            content: [{
                block: 'awesome-icon',
                mods: {
                    icon: 'remove'
                }
            }, BEM.I18N('m-orange-actions', 'decline')]
        }];
    }
    if (this.ctx.userComment) {
        content.push({
            elem: 'comment-text',
            content: (BEM.I18N('m-orange-actions', 'comment') + ': ' + BEM.I18N('m-orange-actions', 'laquo') + this.ctx.userComment + BEM.I18N('m-orange-actions', 'raquo'))
        });
    }
    if (this.ctx.comment && this.ctx.answer == 1) {
        content.push({
            block: this.block,
            elem: 'comment',
            mix: [{
                block: 'm-orange-item',
                elem: 'comment'
            }],
            content: [{
                block: 'input',
                mods: {
                    type: 'textarea'
                },
                content: {
                    elem: 'control',
                    controlAttrs: {
                        placeholder: BEM.I18N('m-orange-actions', 'comment_placeholder')
                    }
                }
            }, {
                block: this.block,
                elem: 'comment-submit',
                content: {
                    block: 'button',
                    mods: {
                        size: 's',
                        theme: 'action',
                        disabled: 'yes'
                    },
                    content: BEM.I18N('m-orange-actions', 'done')
                }
            }]
        });
    }
    return content;
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-orange-actions/m-orange-actions.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-footer/m-footer.bemhtml.js */
block('m-footer')(
    def()(function() {
        var ctx = this.ctx;
        ctx.additionalData = ctx.additionalData || [];
        ctx.additionalData = ctx.additionalData.map(function(item) {
            if ((typeof item === 'string')) {
                return {
                    elem: 'addon-text',
                    content: item
                };
            } else {
                return {
                    elem: 'link',
                    url: item.url,
                    content: item.title
                };
            }
        });
        ctx.additionalData.unshift({
            block: 'link',
            mods: {
                type: 'mailto'
            },
            url: ('mailto:' + ctx.email || 'tools@yandex-team.ru'),
            content: BEM.I18N('m-footer', 'feedback')
        });
        return applyNext();
    }),
    content()(function() {
        return {
            block: 'footer',
            content: [{
                elem: 'column',
                content: this.ctx.additionalData
            }, {
                elem: 'column',
                elemMods: {
                    side: 'right'
                },
                content: [{
                    elem: 'info',
                    content: [{
                        elem: 'link',
                        url: '//wiki.yandex-team.ru/nda',
                        content: BEM.I18N('m-footer', 'confidential')
                    }, (this.ctx.vodstvo && {
                        elem: 'link',
                        url: this.ctx.vodstvo,
                        content: BEM.I18N('m-footer', 'guide')
                    }), (this.ctx.about && {
                        elem: 'link',
                        url: this.ctx.about,
                        content: BEM.I18N('m-footer', 'about')
                    }), {
                        elem: 'info-text',
                        content: BEM.I18N('m-footer', 'yandex_info')
                    }]
                }, {
                    elem: 'right',
                    content: [(this.ctx.mobile && {
                        elem: 'link',
                        elemMods: {
                            type: 'mobile'
                        },
                        url: this.ctx.mobile,
                        content: BEM.I18N('m-footer', 'mobile')
                    }), {
                        block: 'copyright',
                        start: 2003
                    }]
                }]
            }]
        };
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-footer/m-footer.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-orange/m-orange.bemhtml.js */
block('m-orange').content()([{
    elem: 'icon',
    tag: 'span',
    mix: [{
        block: 'awesome-icon',
        mods: {
            icon: 'list'
        }
    }]
}, {
    elem: 'counter',
    tag: 'strong'
}]);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-orange/m-orange.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/blocks/desktop/cab-page/__foot/cab-page__foot.bemhtml.js */
block('cab-page').elem('foot').replace()(function() {
    return {
        block: 'm-footer',
        email: 'tools@yandex-team.ru',
        mix: _.pick(this, 'block', 'elem', 'elemMods')
    };
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/blocks/desktop/cab-page/__foot/cab-page__foot.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-search/m-head-search.bemhtml.js */
block('m-head-search')(
    content()(function() {
        return {
            elem: 'search',
            attrs: {
                action: ((this.ctx.search && this.ctx.search.action) || 'https://search.yandex-team.ru/search'),
                autocomplete: 'off'
            },
            content: [
                {
                    block: 'm-suggest',
                    mods: {
                        type: 'intranet-suggest',
                        size: 's'
                    },
                    mix: {
                        block: this.block,
                        elem: 'field'
                    },
                    inputMods: {size: 'm'},
                    hint: (this.ctx.search.hint || BEM.I18N('m-head-search', 'hint')),
                    inHeader: true,
                    types: ['staff']
                },
                {
                    block: 'button2',
                    mix: {
                        block: this.block,
                        elem: 'button'
                    },
                    mods: {
                        size: 'm',
                        theme: 'normal',
                        type: 'submit',
                        pin: 'clear-round'
                    },
                    tabindex: 2,
                    text: BEM.I18N('m-head-search', 'find')
                },
                (this.ctx.search && this.ctx.search.formParams && {
                    elem: 'form-params',
                    params: this.ctx.search.formParams
                })
            ]
        };
    }),
    elem('search').tag()('form'),
    elem('form-params').content()(function() {
        var params = this.ctx.params;
        return Object.keys(params).map(function(key) {
            return {
                elem: 'form-param',
                key: key,
                value: params[key]
            };
        });
    }),
    elem('form-param')(
        tag()('input'),
        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.key,
                value: this.ctx.value
            };
        })
    )
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head-search/m-head-search.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head/m-head.bemhtml.js */
block('m-head')(
    mix().match(function() {
        return this.ctx.orange !== false;
    })({
        mods: {
            orange: 'yes'
        }
    }),
    tag()('header'),
    js()(true),
    content()(function() {
        return [{
            block: 'm-head-arrow',
            mix: [{
                block: 'm-head',
                elem: 'min'
            }],
            js: {
                type: (this.ctx.service || 'none'),
                host: this.ctx.navigationApiHost
            },
            title: (this.ctx.title || 'Service Name')
        }, {
            block: this.blockName,
            elem: 'main',
            content: (this.ctx.menuItems && {
                block: 'm-head-menu',
                mods: {
                    type: 'main'
                },
                headTypeMod: (this.ctx.mods && this.ctx.mods.type),
                menuItems: this.ctx.menuItems
            })
        }, (this.ctx.action && {
            block: 'm-head-action',
            mix: [{
                block: 'm-head',
                elem: 'min'
            }],
            action: this.ctx.action
        }), (this.ctx.search && {
            block: 'm-head-search',
            mix: [{
                block: 'm-head',
                elem: 'min'
            }],
            search: this.ctx.search
        }), (this.ctx.orange !== false && {
            block: this.blockName,
            elem: 'orange',
            mix: [{
                block: 'm-head',
                elem: 'min'
            }],
            content: {
                block: 'm-orange',
                js: {
                    parentOffset: 'm-head',
                    api: ((this.ctx.orange && this.ctx.orange.api) || false)
                }
            }
        }), {
            block: 'm-head-user',
            user: this.ctx.user,
            customUserLinks: this.ctx.customUserLinks
        }];
    })
);

/* end: /mnt/c/Users/ertema/workspace/cab-www/node_modules/meccano/desktop.blocks/m-head/m-head.bemhtml.js */
/* begin: /mnt/c/Users/ertema/workspace/cab-www/blocks/desktop/cab-page/__head/cab-page__head.bemhtml.js */
block('cab-page').elem('head').replace()(function() {
    var data = Object(this.ctx.data);

    return {
        block: 'm-head',
        mods: {type: 'staff'},
        mix: {
            block: this.block,
            elem: this.elem,
            elemMods: this.elemMods,
            mods: this.mods
        },
        title: BEM.I18N(this.block, 'caption.arrow'),
        user: data.login,
        search: true
    };
});

/* end: /mnt/c/Users/ertema/workspace/cab-www/blocks/desktop/cab-page/__head/cab-page__head.bemhtml.js */
oninit(function(exports, context) {
    var BEMContext = exports.BEMContext || context.BEMContext;
    // Provides third-party libraries from different modular systems
    BEMContext.prototype.require = function(lib) {
       return __bem_xjst_libs__[lib];
    };
});;
});
api.exportApply(exports);
/// -------------------------------------
/// ------ BEM-XJST User-code End -------
/// -------------------------------------


        return exports;
    };



    var defineAsGlobal = true;

    // Provide with CommonJS
    if (typeof module === 'object' && typeof module.exports === 'object') {
        exports['BEMHTML'] = buildBemXjst({

}
);
        defineAsGlobal = false;
    }

    // Provide to YModules
    if (typeof modules === 'object') {
        modules.define(
            'BEMHTML',
            [],
            function(
                provide

                ) {
                    provide(buildBemXjst({

}
));
                }
            );

        defineAsGlobal = false;
    }

    // Provide to global scope
    if (defineAsGlobal) {
        BEMHTML = buildBemXjst({

}
);
        global['BEMHTML'] = BEMHTML;
    }
})(typeof window !== "undefined" ? window : global || this);
