
(function (global) {
    var __i18n__ = (function () {
var __bem__ = {};
(function (BEM) {
/* global BEM, i18n */
(function(global_, bem_, undefined) {

// Check if BEM.I18N was already initialized
if(typeof bem_.I18N === 'function' && bem_.I18N._proto) {
    return bem_.I18N;
}

/**
 * Support tanker-like syntax of keys in `i-bem__i18n`
 * @example
 *  i18n['prj']['keyset']['key'](params)
 */
if(typeof i18n === 'undefined') {
    /* jshint -W020 */
    i18n = {};
    /* jshint +W020 */
}

/* jshint -W020 */
BEM = bem_;
/* jshint +W020 */

var MOD_DELIM = '_',
    ELEM_DELIM = '__',
    DEFAULT_LANG = 'ru',
    cache = {},
    // {String[]} A stack used for restoring context of dynamic keysets
    stack = [],
    debug = false,
    // @see http://whattheheadsaid.com/2011/04/internet-explorer-9s-problematic-console-object
    hasConsole = typeof console !== 'undefined' && typeof console.log === 'function';

function log() {
    if(debug && hasConsole) {
        console.log.apply(console, arguments);
    }
}

function bemName(decl) {
    typeof decl === 'string' && (decl = { block: decl });

    return decl.block +
        (decl.elem ? (ELEM_DELIM + decl.elem) : '') +
        (decl.modName ? MOD_DELIM + decl.modName + MOD_DELIM + decl.modVal : '');
}

function bemParse(name) {
    var bemitem = {};

    name.split(ELEM_DELIM).forEach(function(item, i) {
        var keys = [ i ? 'elem' : 'block', 'mod', 'val' ];

        item.split(MOD_DELIM).forEach(function(part, j) {
            bemitem[keys[j]] = part;
        });
    });

    return bemitem;
}

function _pushStack(name) {
    if(!name) return false;
    return stack.push(name);
}

function _popStack() {
    return stack.length && stack.pop();
}


/**
 * @constructor
 */
function _i18n() {
    this._lang = '';
    this._prj = 'lego'; // FIXME: bem-bl?
    this._keyset = '';
    this._key = '';
}

_i18n.prototype = {

    lang : function(name) {
        this._lang = name;
        return this;
    },

    project : function(name) {
        this._prj = name;
        return this;
    },

    keyset : function(name, saveCtx) {
        saveCtx && _pushStack(this._keyset);

        this._keyset = bemName(name);
        return this;
    },

    key : function(name) {
        this._key = name;
        return this;
    },

    /**
     * FIXME: Move legacy-syntax support into separat method
     * @param {Object|Function} v
     */
    decl : function(v) {
        var bemitem = bemParse(this._keyset),
            // tanker legacy syntax
            prj = bemitem.block === 'i-tanker' ? 'tanker' : this._prj,
            keyset = bemitem.elem || this._keyset,
            key = this._key;

        prj = i18n[prj] || (i18n[prj] = {});
        keyset = prj[keyset] || (prj[keyset] = {});
        keyset[key] = typeof v === 'function' ? v : (function(p) { return (v); });

        // `BEM.I18N` syntax
        var l = cache[this._lang] || (cache[this._lang] = {}),
            k = l[this._keyset] || (l[this._keyset] = {});

        k[key] = v;
    },

    val : function(params, ctx) {
        var value = cache[this._lang] && cache[this._lang][this._keyset],
            debugString = 'keyset: ' + this._keyset + ' key: ' + this._key + ' (lang: ' + this._lang + ')';

        if(!value) {
            log('[I18N_NO_KEYSET] %s', debugString);
            return '';
        }

        value = value[this._key];

        var valtype = typeof value;
        if(valtype === 'undefined') {
            log("[I18N_NO_VALUE] %s", debugString);
            return '';
        }

        if(valtype === 'string') {
            return value;
        }

        ctx || (ctx = this);
        // TODO: try/catch
        return value.call(ctx, params);
    },

    _cache : function() { return cache; }

};

/**
 * @namespace
 * @lends BEM.I18N
 */
bem_.I18N = (function(base) {

    /**
     * Shortcut to get key value
     *
     * @param {String|Object} keyset
     * @param {String} key
     * @param {Object} [params]
     * @returns {String}
     */
    var klass = function(keyset, key, params) {
        return klass.keyset(keyset).key(key, params);
    };

    klass._proto = base;

    /**
     * @param {String} name
     * @returns {BEM.I18N}
     */
    klass.project = function(name) {
        this._proto.project(name);
        return this;
    };

    /**
     * @param {String} name
     * @returns {BEM.I18N}
     */
    klass.keyset = function(name) {
        this._proto.keyset(name, true);
        return this;
    };

    /**
     * @param {String} name Key name
     * @param {Object} params
     * @returns {String}
     */
    klass.key = function(name, params) {
        var proto = this._proto,
            result,
            ksetRestored;

        proto.lang(this._lang).key(name);

        // TODO: kiss
        result = proto.val.call(proto, params, klass);

        // restoring keyset's context
        // NOTE: should not save current ctx, `saveCtx = false`
        ksetRestored = _popStack();
        ksetRestored && proto.keyset(ksetRestored, false);

        return result;
    };

    /**
     * Declaration of translations
     *
     * @param {String|Object} bemitem
     * @param {Object} keysets
     * @param {Object} [params] declaration params
     * @returns {BEM.I18N}
     */
    klass.decl = function(bemitem, keysets, params) {
        var proto = this._proto,
            k;

        params || (params = {});
        params.lang && proto.lang(params.lang);

        proto.keyset(bemitem);

        for(k in keysets) {
            if(keysets.hasOwnProperty(k)) {
                proto.key(k).decl(keysets[k]);
            }
        }

        return this;
    };

    /**
     * Get/set current language
     *
     * @param {String} [lang]
     * @returns {String}
     */
    klass.lang = function(lang) {
        typeof lang !== 'undefined' && (this._lang = lang);
        return this._lang;
    };

    klass.debug = function(flag) {
        debug = !!flag;
    };

    klass.lang(DEFAULT_LANG);

    return klass;

}(new _i18n()));

})(this, typeof BEM === 'undefined' ? {} : BEM);


}(__bem__));
var i18n = __bem__.I18N;
i18n.decl('b-statcounter__metrika', {
"JSERR_incorrectID":"Incorrect ID has been passed."
}, { "lang": "en" });
i18n.decl('cab-error', {
"400":"Bad request",
"403":"No rights",
"404":"Page not found",
"500":"Internal server error",
"502":"Bad Gateway"
}, { "lang": "en" });
i18n.decl('cab-page', {
"caption.arrow":"Staff",
"caption.private_mode":"Private data",
"page.error":"Error",
"page.index":"Staff",
"title.private_mode":"The display control wages / premiums / levels / assessments on review, and other personnel information"
}, { "lang": "en" });
i18n.decl('copyright', {
"link":function(params) { return params["content"] },
"yandex":"Yandex"
}, { "lang": "en" });
i18n.decl('footer', {
"about":"About Yandex",
"about-url":"//company.yandex.com/",
"advert":"Advertisement",
"advert-url":"//advertising.yandex.ru/kupislova.xml?advertising",
"apps":"Mobile apps",
"apps-url":"//mobile.yandex.ru",
"stat":"Statistics",
"termsofuse":"Terms and Conditions",
"termsofuse-url":"//legal.yandex.ru/termsofuse/"
}, { "lang": "en" });
i18n.decl('i-services', {
"404":"404",
"adresa":"Addresses",
"advertising":"Advertising",
"afisha":"Afisha",
"all":"All services",
"api":"API",
"appsearch":"Apps",
"auto":"Auto",
"autoru":"auto.ru",
"avia":"Flights",
"aziada":"Азиада",
"ba":"Bayan",
"backapv":"Партнер Я.Карт",
"balance":"Balance",
"bar":"Bar",
"bar-ie":"Бар для ИЕ",
"bar-ie9":"Бар для ИЕ9",
"bayan":"Баннеры Яндекса",
"blogs":"Blogs",
"books":"Books",
"browser":"Browser",
"calendar":"Calendar",
"captcha":"ой...",
"catalogwdgt":"Каталог виджетов",
"chrome":"Хром с поиском Яндекса",
"city":"Cities",
"cityday":"City Day",
"collection":"Collection",
"company":"Company",
"contest":"Contest",
"desktop":"Персональный поиск",
"direct":"Direct",
"direct.market":"Market",
"disk":"Disk",
"display":"Display",
"ege":"Russian Grade School State Exams",
"expert":"Эксперт",
"feedback":"Contact us",
"feedback2":"Contact us",
"ff":"ФФ с поиском Яндекса",
"fotki":"Photos",
"fresh":"Recent",
"games":"Games",
"geocontext":"Геоконтекст",
"goroda":"Города",
"help":"Help",
"i":"Мои сервисы",
"ie":"ИЕ с поиском Яндекса",
"images":"Images",
"images-com":"Images",
"interests":"Interests",
"internet":"Интернет",
"kassa":"Payment Solution",
"keyboard":"Клавиатура",
"kraski":"Краски",
"kuda":"Where",
"large":"Яндекс для слабовидящих",
"legal":"Legal documents",
"lenta":"Feeds",
"libra":"Library",
"literacy":"Неделя борьбы за грамотность",
"local":"Local Network",
"lost":"Незабудки",
"love":"День взаимного тяготения — 13 августа",
"mail":"Mail",
"maps":"Maps",
"maps-wiki":"Народная карта",
"market":"Market",
"market.advertising":"Market",
"master":"Yandex.Master",
"metrika":"Metrica",
"metro":"Метро",
"mobile":"Mobile",
"moikrug":"Moi Krug",
"money":"Money",
"museums":"Дни исторического и культурного наследия",
"music":"Music",
"music-partner":"Музыка: статистика",
"nahodki":"My Findings",
"nano":"Nano",
"newhire":"Newhire",
"news":"News",
"notifications":"Notifications panel",
"oauth":"OAuth",
"online":"Online",
"openid":"OpenID",
"opera":"Opera Software",
"opinion":"Цитаты",
"partners":"Advertising Network",
"partnersearch":"Поиск для партнеров",
"passport":"Passport",
"pdd":"Mail for Domains",
"peoplesearch":"People search",
"perevod":"Translate",
"probki":"Probki",
"pulse":"блоги: пульс",
"punto":"Punto switcher",
"pvo":"Ask",
"rabota":"Jobs",
"ramazan":"",
"rasp":"Timetables",
"realty":"Недвижимость",
"referats":"Рефераты",
"rk":"Есть вопросы?",
"root":"Yandex.Olympiad for Unix administrators",
"school":"Школьная морда",
"search":"Web",
"server":"Server",
"shtrafi":"Штрафы",
"site":"Site search",
"slovari":"Dictionaries",
"so":"Самооборона",
"social":"Социализм",
"soft":"Programs",
"sport":"Sport",
"sprav":"Directory",
"start":"Стартовая страница",
"stat":"Статистика",
"subs":"Subscriptions",
"taxi":"Taxi",
"terms":"Разговорник",
"tests":"Тесты и опросы",
"tickets":"Tickets",
"time":"Yandex.Time",
"toster":"Тосты",
"translate":"Translate",
"tune":"Tune",
"tv":"TV",
"uslugi":"Services",
"video":"Video",
"video-com":"Video",
"vno":"ZNO",
"wdgt":"Widgets",
"weather":"Weather",
"webmaster":"Webmaster",
"webmaster-api":"Webmaster API",
"widgets":"Widgets",
"wordstat":"Statistics",
"wow":"Ya.ru",
"www":"Web",
"xmlsearch":"XML",
"yaca":"Catalog",
"yamb":"Media Banners",
"zakladki":"Bookmarks"
}, { "lang": "en" });
i18n.decl('i-tanker__days', {
"acc1":"on Monday",
"acc2":"on Tuesday",
"acc3":"on Wednesday",
"acc4":"on Thursday",
"acc5":"on Friday",
"acc6":"on Saturday",
"acc7":"on Sunday",
"n1":"Monday",
"n2":"Tuesday",
"n3":"Wednesday",
"n4":"Thursday",
"n5":"Friday",
"n6":"Saturday",
"n7":"Sunday",
"name":function(params) { return (function(params) {
       return i18n['tanker']['days'][(params['short'] ? 'short' : 'n') + params.day]();
    }).call(this, params) },
"short1":"Mon",
"short2":"Tue",
"short3":"Wed",
"short4":"Thu",
"short5":"Fri",
"short6":"Sat",
"short7":"Sun",
"today":"today",
"tomorrow":"tomorrow",
"yesterday":"yesterday"
}, { "lang": "en" });
i18n.decl('i-tanker__months', {
"g1":"January",
"g10":"October",
"g11":"November",
"g12":"December",
"g2":"February",
"g3":"March",
"g4":"April",
"g5":"May",
"g6":"June",
"g7":"July",
"g8":"August",
"g9":"September",
"n1":"January",
"n10":"October",
"n11":"November",
"n12":"December",
"n2":"February",
"n3":"March",
"n4":"April",
"n5":"May",
"n6":"June",
"n7":"July",
"n8":"August",
"n9":"September",
"name":function(params) { return (function(params) {
       var month = i18n['tanker']['months'][(params['case'] || 'n') + params.month]();
       return Boolean(params.lowercase) ? month.toLowerCase() : month;
    }).call(this, params) },
"short1":"Jan",
"short10":"Oct",
"short11":"Nov",
"short12":"Dec",
"short2":"Feb",
"short3":"Mar",
"short4":"Apr",
"short5":"May",
"short6":"Jun",
"short7":"Jul",
"short8":"Aug",
"short9":"Sep"
}, { "lang": "en" });
i18n.decl('m-footer', {
"feedback":"Feedback",
"confidential":"Confidential",
"guide":"Guide",
"about":"About",
"yandex_info":"Trade secrets of Yandex LLC. 16, Lev Tolstoy Str., Moscow, Russia, 119021",
"mobile":"Mobile version"
}, { "lang": "en" });
i18n.decl('m-head-arrow', {
"error":"Could not get the list of services."
}, { "lang": "en" });
i18n.decl('m-head-search', {
"hint":"intranet search",
"find":"Find"
}, { "lang": "en" });
i18n.decl('m-head-user', {
"staff":"Staff",
"options":"Options",
"logout":"Logout"
}, { "lang": "en" });
i18n.decl('m-orange', {
"old_messages":"Old notifications",
"load_error":"Can't load notifications",
"repeat_request":"Repeat request",
"no_new_messages":"No new messages",
"center":"Notification Center",
"we_will":"We will notify you about important events."
}, { "lang": "en" });
i18n.decl('m-orange-actions', {
"accepted":"Accepted",
"accept":"Accept",
"declined":"Declined",
"decline":"Decline",
"comment":"Comment",
"laquo":"‘",
"raquo":"’",
"comment_placeholder":"Comment required",
"done":"Done"
}, { "lang": "en" });
i18n.decl('m-orange-item', {
"error":"Error occured. Try again, please.",
"already_answered":"Allready answered by another responsible"
}, { "lang": "en" });
i18n.decl('popup', {
"add":"Add",
"cancel":"Cancel",
"revert":"Cancel",
"apply":"Apply"
}, { "lang": "en" });
i18n.lang('en');
return i18n;
}()),
        defineAsGlobal = true;

    // CommonJS
    if (typeof exports === "object") {
        module.exports = __i18n__;

    }

    // YModules
    if (typeof modules === "object") {
        modules.define("i18n", function (provide) {
            provide(__i18n__);
        });

    }

    if (defineAsGlobal) {

        (global.BEM || (global.BEM = {})).I18N = __i18n__;
    }
})(typeof window !== "undefined" ? window : global);
