
(function (global) {
    var __i18n__ = (function () {
var __bem__ = {};
(function (BEM) {
/* global BEM, i18n */
(function(global_, bem_, undefined) {

// Check if BEM.I18N was already initialized
if(typeof bem_.I18N === 'function' && bem_.I18N._proto) {
    return bem_.I18N;
}

/**
 * Support tanker-like syntax of keys in `i-bem__i18n`
 * @example
 *  i18n['prj']['keyset']['key'](params)
 */
if(typeof i18n === 'undefined') {
    /* jshint -W020 */
    i18n = {};
    /* jshint +W020 */
}

/* jshint -W020 */
BEM = bem_;
/* jshint +W020 */

var MOD_DELIM = '_',
    ELEM_DELIM = '__',
    DEFAULT_LANG = 'ru',
    cache = {},
    // {String[]} A stack used for restoring context of dynamic keysets
    stack = [],
    debug = false,
    // @see http://whattheheadsaid.com/2011/04/internet-explorer-9s-problematic-console-object
    hasConsole = typeof console !== 'undefined' && typeof console.log === 'function';

function log() {
    if(debug && hasConsole) {
        console.log.apply(console, arguments);
    }
}

function bemName(decl) {
    typeof decl === 'string' && (decl = { block: decl });

    return decl.block +
        (decl.elem ? (ELEM_DELIM + decl.elem) : '') +
        (decl.modName ? MOD_DELIM + decl.modName + MOD_DELIM + decl.modVal : '');
}

function bemParse(name) {
    var bemitem = {};

    name.split(ELEM_DELIM).forEach(function(item, i) {
        var keys = [ i ? 'elem' : 'block', 'mod', 'val' ];

        item.split(MOD_DELIM).forEach(function(part, j) {
            bemitem[keys[j]] = part;
        });
    });

    return bemitem;
}

function _pushStack(name) {
    if(!name) return false;
    return stack.push(name);
}

function _popStack() {
    return stack.length && stack.pop();
}


/**
 * @constructor
 */
function _i18n() {
    this._lang = '';
    this._prj = 'lego'; // FIXME: bem-bl?
    this._keyset = '';
    this._key = '';
}

_i18n.prototype = {

    lang : function(name) {
        this._lang = name;
        return this;
    },

    project : function(name) {
        this._prj = name;
        return this;
    },

    keyset : function(name, saveCtx) {
        saveCtx && _pushStack(this._keyset);

        this._keyset = bemName(name);
        return this;
    },

    key : function(name) {
        this._key = name;
        return this;
    },

    /**
     * FIXME: Move legacy-syntax support into separat method
     * @param {Object|Function} v
     */
    decl : function(v) {
        var bemitem = bemParse(this._keyset),
            // tanker legacy syntax
            prj = bemitem.block === 'i-tanker' ? 'tanker' : this._prj,
            keyset = bemitem.elem || this._keyset,
            key = this._key;

        prj = i18n[prj] || (i18n[prj] = {});
        keyset = prj[keyset] || (prj[keyset] = {});
        keyset[key] = typeof v === 'function' ? v : (function(p) { return (v); });

        // `BEM.I18N` syntax
        var l = cache[this._lang] || (cache[this._lang] = {}),
            k = l[this._keyset] || (l[this._keyset] = {});

        k[key] = v;
    },

    val : function(params, ctx) {
        var value = cache[this._lang] && cache[this._lang][this._keyset],
            debugString = 'keyset: ' + this._keyset + ' key: ' + this._key + ' (lang: ' + this._lang + ')';

        if(!value) {
            log('[I18N_NO_KEYSET] %s', debugString);
            return '';
        }

        value = value[this._key];

        var valtype = typeof value;
        if(valtype === 'undefined') {
            log("[I18N_NO_VALUE] %s", debugString);
            return '';
        }

        if(valtype === 'string') {
            return value;
        }

        ctx || (ctx = this);
        // TODO: try/catch
        return value.call(ctx, params);
    },

    _cache : function() { return cache; }

};

/**
 * @namespace
 * @lends BEM.I18N
 */
bem_.I18N = (function(base) {

    /**
     * Shortcut to get key value
     *
     * @param {String|Object} keyset
     * @param {String} key
     * @param {Object} [params]
     * @returns {String}
     */
    var klass = function(keyset, key, params) {
        return klass.keyset(keyset).key(key, params);
    };

    klass._proto = base;

    /**
     * @param {String} name
     * @returns {BEM.I18N}
     */
    klass.project = function(name) {
        this._proto.project(name);
        return this;
    };

    /**
     * @param {String} name
     * @returns {BEM.I18N}
     */
    klass.keyset = function(name) {
        this._proto.keyset(name, true);
        return this;
    };

    /**
     * @param {String} name Key name
     * @param {Object} params
     * @returns {String}
     */
    klass.key = function(name, params) {
        var proto = this._proto,
            result,
            ksetRestored;

        proto.lang(this._lang).key(name);

        // TODO: kiss
        result = proto.val.call(proto, params, klass);

        // restoring keyset's context
        // NOTE: should not save current ctx, `saveCtx = false`
        ksetRestored = _popStack();
        ksetRestored && proto.keyset(ksetRestored, false);

        return result;
    };

    /**
     * Declaration of translations
     *
     * @param {String|Object} bemitem
     * @param {Object} keysets
     * @param {Object} [params] declaration params
     * @returns {BEM.I18N}
     */
    klass.decl = function(bemitem, keysets, params) {
        var proto = this._proto,
            k;

        params || (params = {});
        params.lang && proto.lang(params.lang);

        proto.keyset(bemitem);

        for(k in keysets) {
            if(keysets.hasOwnProperty(k)) {
                proto.key(k).decl(keysets[k]);
            }
        }

        return this;
    };

    /**
     * Get/set current language
     *
     * @param {String} [lang]
     * @returns {String}
     */
    klass.lang = function(lang) {
        typeof lang !== 'undefined' && (this._lang = lang);
        return this._lang;
    };

    klass.debug = function(flag) {
        debug = !!flag;
    };

    klass.lang(DEFAULT_LANG);

    return klass;

}(new _i18n()));

})(this, typeof BEM === 'undefined' ? {} : BEM);


}(__bem__));
var i18n = __bem__.I18N;
i18n.decl('b-statcounter__metrika', {
"JSERR_incorrectID":"Incorrect ID has been passed."
}, { "lang": "ru" });
i18n.decl('cab-error', {
"400":"Ошибка в запросе",
"403":"Недостаточно прав",
"404":"Страница не найдена",
"500":"Внутренняя ошибка сервера",
"502":"Bad Gateway"
}, { "lang": "ru" });
i18n.decl('cab-page', {
"caption.arrow":"Стафф",
"caption.private_mode":"Приватные данные",
"page.error":"Ошибка ",
"page.index":"Стафф",
"title.private_mode":"Управление отображением зарплат / премий / уровней / оценок на ревью, а также другой кадровой информации"
}, { "lang": "ru" });
i18n.decl('copyright', {
"link":function(params) { return "ООО «" + params["content"] + "»" },
"yandex":"Яндекс"
}, { "lang": "ru" });
i18n.decl('footer', {
"about":"О компании",
"about-url":"//company.yandex.ru",
"advert":"Реклама",
"advert-url":"//advertising.yandex.ru/kupislova.xml?advertising",
"apps":"Мобильные приложения",
"apps-url":"//mobile.yandex.ru",
"stat":"Статистика",
"termsofuse":"Лицензия на поиск",
"termsofuse-url":"//legal.yandex.ru/termsofuse/"
}, { "lang": "ru" });
i18n.decl('i-services', {
"404":"404",
"adresa":"Адреса",
"advertising":"Реклама",
"afisha":"Афиша",
"all":"Все сервисы",
"api":"API",
"appsearch":"Приложения",
"auto":"Авто",
"autoru":"Авто.ру",
"avia":"Авиабилеты",
"aziada":"Азиада",
"ba":"Баян",
"backapv":"Партнер Я.Карт",
"balance":"Баланс",
"bar":"Бар",
"bar-ie":"Бар для ИЕ",
"bar-ie9":"Бар для ИЕ9",
"bayan":"Баннеры Яндекса",
"blogs":"Блоги",
"books":"Книги",
"browser":"Браузер",
"calendar":"Календарь",
"captcha":"ой...",
"catalogwdgt":"Каталог виджетов",
"chrome":"Хром с поиском Яндекса",
"city":"Города",
"cityday":"День города",
"collection":"Коллекция",
"company":"Компания",
"contest":"Contest",
"desktop":"Персональный поиск",
"direct":"Директ",
"direct.market":"Маркет",
"disk":"Диск",
"display":"Дисплей",
"ege":"ЕГЭ",
"expert":"Эксперт",
"feedback":"Обратная связь",
"feedback2":"Обратная связь",
"ff":"ФФ с поиском Яндекса",
"fotki":"Фотки",
"fresh":"Свежее",
"games":"Игрушки",
"geocontext":"Геоконтекст",
"goroda":"Города",
"help":"Помощь",
"i":"Мои сервисы",
"ie":"ИЕ с поиском Яндекса",
"images":"Картинки",
"images-com":"Картинки",
"interests":"Интересы",
"internet":"Интернет",
"kassa":"Касса",
"keyboard":"Клавиатура",
"kraski":"Краски",
"kuda":"Куда все идут",
"large":"Яндекс для слабовидящих",
"legal":"Правовые документы",
"lenta":"Лента",
"libra":"Библиотека",
"literacy":"Неделя борьбы за грамотность",
"local":"Локальная сеть",
"lost":"Незабудки",
"love":"День взаимного тяготения — 13 августа",
"mail":"Почта",
"maps":"Карты",
"maps-wiki":"Народная карта",
"market":"Маркет",
"market.advertising":"Маркет",
"master":"Мастер",
"metrika":"Метрика",
"metro":"Метро",
"mobile":"Мобильный",
"moikrug":"Мой Круг",
"money":"Деньги",
"museums":"Дни исторического и культурного наследия",
"music":"Музыка",
"music-partner":"Музыка: статистика",
"nahodki":"Мои находки",
"nano":"Нано",
"newhire":"Наниматор",
"news":"Новости",
"notifications":"Нотификационная панель",
"oauth":"Авторизация",
"online":"Онлайн",
"openid":"OpenID",
"opera":"Opera Software",
"opinion":"Цитаты",
"partners":"Рекламная сеть",
"partnersearch":"Поиск для партнеров",
"passport":"Паспорт",
"pdd":"Почта для домена",
"peoplesearch":"Люди",
"perevod":"Переводчик",
"probki":"Пробки",
"pulse":"блоги: пульс",
"punto":"Punto switcher",
"pvo":"Ответы",
"rabota":"Работа",
"ramazan":"",
"rasp":"Расписания",
"realty":"Недвижимость",
"referats":"Рефераты",
"rk":"Есть вопросы?",
"root":"Яндекс.Олимпиада для Unix администраторов",
"school":"Школа",
"search":"Поиск",
"server":"Сервер",
"shtrafi":"Штрафы",
"site":"Поиск для сайта",
"slovari":"Словари",
"so":"Самооборона",
"social":"Социализм",
"soft":"Программы",
"sport":"Спорт",
"sprav":"Справочник",
"start":"Стартовая страница",
"stat":"Статистика",
"subs":"Подписки",
"taxi":"Такси",
"terms":"Разговорник",
"tests":"Тесты и опросы",
"tickets":"Билеты",
"time":"Яндекс.Время",
"toster":"Тосты",
"translate":"Переводчик",
"tune":"Настройки",
"tv":"ТВ",
"uslugi":"Услуги",
"video":"Видео",
"video-com":"Видео",
"vno":"ВНО",
"wdgt":"Виджеты",
"weather":"Погода",
"webmaster":"Вебмастер",
"webmaster-api":"API Вебмастера",
"widgets":"Виджеты",
"wordstat":"Статистика",
"wow":"Я.ру",
"www":"Поиск",
"xmlsearch":"XML",
"yaca":"Каталог",
"yamb":"Медийные баннеры",
"zakladki":"Закладки"
}, { "lang": "ru" });
i18n.decl('i-tanker__days', {
"acc1":"в понедельник",
"acc2":"во вторник",
"acc3":"в среду",
"acc4":"в четверг",
"acc5":"в пятницу",
"acc6":"в субботу",
"acc7":"в воскресенье",
"n1":"понедельник",
"n2":"вторник",
"n3":"среда",
"n4":"четверг",
"n5":"пятница",
"n6":"суббота",
"n7":"воскресенье",
"name":function(params) { return (function(params) {
       return i18n['tanker']['days'][(params['short'] ? 'short' : 'n') + params.day]();
    }).call(this, params) },
"short1":"пн",
"short2":"вт",
"short3":"ср",
"short4":"чт",
"short5":"пт",
"short6":"сб",
"short7":"вс",
"today":"сегодня",
"tomorrow":"завтра",
"yesterday":"вчера"
}, { "lang": "ru" });
i18n.decl('i-tanker__months', {
"g1":"Января",
"g10":"Октября",
"g11":"Ноября",
"g12":"Декабря",
"g2":"Февраля",
"g3":"Марта",
"g4":"Апреля",
"g5":"Мая",
"g6":"Июня",
"g7":"Июля",
"g8":"Августа",
"g9":"Сентября",
"n1":"Январь",
"n10":"Октябрь",
"n11":"Ноябрь",
"n12":"Декабрь",
"n2":"Февраль",
"n3":"Март",
"n4":"Апрель",
"n5":"Май",
"n6":"Июнь",
"n7":"Июль",
"n8":"Август",
"n9":"Сентябрь",
"name":function(params) { return (function(params) {
       var month = i18n['tanker']['months'][(params['case'] || 'n') + params.month]();
       return Boolean(params.lowercase) ? month.toLowerCase() : month;
    }).call(this, params) },
"short1":"янв",
"short10":"окт",
"short11":"ноя",
"short12":"дек",
"short2":"фев",
"short3":"мар",
"short4":"апр",
"short5":"май",
"short6":"июн",
"short7":"июл",
"short8":"авг",
"short9":"сен"
}, { "lang": "ru" });
i18n.decl('m-footer', {
"feedback":"Обратная связь",
"confidential":"Конфиденциально",
"guide":"Водство",
"about":"О сервисе",
"yandex_info":"Коммерческая тайна ООО «Яндекс», 119021, Россия, г. Москва, ул. Льва Толстого, д. 16",
"mobile":"Мобильная версия"
}, { "lang": "ru" });
i18n.decl('m-head-arrow', {
"error":"Не удалось получить список сервисов."
}, { "lang": "ru" });
i18n.decl('m-head-search', {
"hint":"поиск по интранету",
"find":"Найти"
}, { "lang": "ru" });
i18n.decl('m-head-user', {
"staff":"Я на Стаффе",
"options":"Настройки",
"logout":"Выход"
}, { "lang": "ru" });
i18n.decl('m-orange', {
"old_messages":"Старые уведомления",
"load_error":"Не удалось загрузить уведомления",
"repeat_request":"Повторить запрос",
"no_new_messages":"Новых сообщений нет",
"center":"Уведомления и согласования",
"we_will":"Здесь будут появляться уведомления о важных событиях."
}, { "lang": "ru" });
i18n.decl('m-orange-actions', {
"accepted":"Принято",
"accept":"Принять",
"declined":"Отклонено",
"decline":"Отклонить",
"comment":"Комментарий",
"laquo":"«",
"raquo":"»",
"comment_placeholder":"Обязательно оставьте комментарий",
"done":"Готово"
}, { "lang": "ru" });
i18n.decl('m-orange-item', {
"error":"Произошла ошибка, повторите, пожалуйста, действие",
"already_answered":"Запрос был согласован другим ответственным"
}, { "lang": "ru" });
i18n.decl('m-suggest-item', {
"staff":"Сотрудник",
"maillist":"Рассылка",
"department":"Отдел",
"table":"Стол",
"equipment":"Оборудование",
"floor":"этаж",
"group":"Группа"
}, { "lang": "ru" });
i18n.decl('popup', {
"add":"Добавить",
"cancel":"Отмена",
"revert":"Вернуть",
"apply":"Применить"
}, { "lang": "ru" });
i18n.lang('ru');
return i18n;
}()),
        defineAsGlobal = true;

    // CommonJS
    if (typeof exports === "object") {
        module.exports = __i18n__;

    }

    // YModules
    if (typeof modules === "object") {
        modules.define("i18n", function (provide) {
            provide(__i18n__);
        });

    }

    if (defineAsGlobal) {

        (global.BEM || (global.BEM = {})).I18N = __i18n__;
    }
})(typeof window !== "undefined" ? window : global);
