FROM registry.yandex.net/tools/raw-ubuntu:18.04

EXPOSE 80

COPY deps/debian-build.txt /
RUN apt-get update -qq \
    && cat debian-build.txt | xargs apt-get install -y \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/*

COPY deps/python-main.txt /
RUN pip install --disable-pip-version-check -i https://pypi.yandex-team.ru/simple/ wheel==0.30.0
RUN pip install --disable-pip-version-check -i https://pypi.yandex-team.ru/simple/ -r python-main.txt

RUN cat /usr/local/lib/python2.7/dist-packages/requests/cacert.pem >> /etc/cacerts.pem \
    && cat /usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt >> /etc/cacerts.pem \
    && chown www-data:www-data /etc/cacerts.pem
ENV REQUESTS_CA_BUNDLE=/etc/cacerts.pem

COPY media/ media/

COPY setup.py src/
COPY uwsgiconf.ini /
COPY login_linker/ src/login_linker/
RUN pip install /src/

CMD uwsgi --ini=/uwsgiconf.ini

