#!/usr/bin/env node
var ajv = new (require('ajv'))({allErrors: true});
var cli = require('cli');
var yaml = require('yaml-js');
var fs = require('fs');
var endsWith = require('lodash.endswith');

var opts = cli.parse({
    schema: [ 's', 'JSON Schema', 'file', false ]
});

cli.withStdin(function(file) {
    var schema = fs.readFileSync('./'+opts.schema, {encoding: 'utf-8', flag: 'r'});
    var parsedSchema = {};
    if (endsWith(opts.schema, '.yml') || endsWith(opts.schema, '.yaml')) {
        parsedSchema = yaml.load(schema);
    } else {
        parsedSchema = JSON.parse(schema);
    }

    var validate = ajv.compile(parsedSchema);

    if (!validate(JSON.parse(file))) {
        console.dir(validate.errors, {depth: 10, colors: true});
    }

});

