import attr
from abc import ABCMeta, abstractmethod


@attr.s
class BaseDto:
    def to_dict(self, **kwargs):
        return attr.asdict(self, **kwargs)


class CustomSerialization(metaclass=ABCMeta):
    @abstractmethod
    def serialize(self):
        """
        Must return appropriate
        value for serialization
        """

    def __eq__(self, other):
        return self.serialize() == other.serialize()

