import attr
from attr.validators import instance_of

from .base import BaseDto


@attr.s
class Result(BaseDto):
    data = attr.ib()
    completed = attr.ib(default=True, validator=instance_of(bool))

    def to_dict(self, **kwargs):
        return {'data': {url: response.to_dict() for url, response in self.data.items()}}
