import attr

from .base import BaseDto
from attr.validators import instance_of, optional


@attr.s(hash=True)
class UrlObject(BaseDto):
    url = attr.ib()
    split_result = attr.ib()
    hostname_match = attr.ib()
    path_match = attr.ib()
    fragment_match = attr.ib()
    query_match = attr.ib()
    worker_class_file = attr.ib()
    hide_ref = attr.ib(validator=optional(instance_of(bool)), default=False)

    def __hash__(self):
        return hash(self.url)

    def __eq__(self, other):
        return self.url == other.url
