import yenv

from ..dto import MatchOptions


def compile_match_options(worker):
    hostname_regex = worker.HOSTNAME_REGEX
    path_regex = worker.PATH_REGEX
    fragment_regex = worker.FRAGMENT_REGEX
    query_regex = worker.QUERY_REGEX
    return MatchOptions(hostname_regex.get(yenv.type,
                                           hostname_regex.get('default')),
                        path_regex,
                        fragment_regex,
                        query_regex,
                        )
