import os

from django.conf import settings

from .base import StaffForBusinessMixin
from ..base import HttpBulkWorker
from ..mixins.staff_user import StaffUserMixin


class Worker(StaffForBusinessMixin, StaffUserMixin, HttpBulkWorker):
    HOSTNAME_REGEX = {'production': '^staff.yandex.(ru|com)$',
                      'preprod': '^staff.yandex.(ru|com)$',
                      'testing': '^team.test.yandex.(ru|com)$',
                      'development': '^team.test.yandex.(ru|com)$',
                      }
    PATH_REGEX = r'^/(?P<login>([a-z0-9_\-][a-z0-9\._\-]{0,28}[a-z0-9\-]|[a-z0-9_\-]))/?$'

    PATH = os.path.abspath(__file__)

    FIELDS = 'name', 'nickname'

    TVM2_DESTINATION_CLIENT_ID = settings.DIR_TVM2_CLIENT_ID

    def get_request_url(self):
        return '{url}/v10/users/?fields={fields}&nickname={nicknames}'.format(url=settings.DIR_HOST,
                                                                             fields=','.join(self.FIELDS),
                                                                             nicknames=','.join(self.nicknames),
                                                                             )

    @property
    def nicknames(self):
        return (url_object.path_match.group('login')
                for url_object in self.url_objects)

    def get_prepared_data(self, response):
        return {user_data['nickname']: user_data
                for user_data in response['result']}

    def get_user_title(self, user_name_data, prepared_data=None):
        return '{} {}'.format(user_name_data['first'],
                              user_name_data['last'],
                              )
