import logging

from django.conf import settings

from .base import StartrekForBusinessMixin
from ..intranet.startrek_issue import Worker as IntranetWorker
from ...dto import User

logger = logging.getLogger(__name__)


class Worker(StartrekForBusinessMixin, IntranetWorker):
    HOSTNAME_REGEX = {'production': r'^(demo\.)?tracker.yandex.(ru|com)$',
                      'preprod': r'^tracker.preprod.yandex.(ru|com)$',
                      'testing': r'^(demo\.)?tracker.test.yandex.(ru|com)$',
                      'development': r'^(demo\.)?tracker.test.yandex.(ru|com)$',
                      }

    @property
    def demo(self):
        url_object = next(iter(self.url_objects))
        return 'demo' in url_object.split_result.netloc

    @property
    def api_url(self):
        if self.demo:
            return settings.STARTREK_DEMO_API_URL
        return settings.STARTREK_API_URL

    def add_assignee(self, data, url_object, url_data):
        """
        Внешнее API трекера отдает uid вместо логина, раньше
        мы ходили в блекбокс для получения логинов по uid, но
        после появления федеративных пользователей мы не можем
        этого делать, т.к. блекбокс ничего не знает про таких
        пользователей, теперь возвращаем просто имя пользователя
        """
        assignee_data = url_data.get('assignee')
        if assignee_data is not None:
            data[url_object.url].value.append(User(login=assignee_data['display']))
