import os

from ..base import HttpSingleWorker
from ...dto.types import List, String, Image, BinaryResource


class Worker(HttpSingleWorker):
    HOSTNAME_REGEX = {'default': '^yadi.sk$',
                      }
    PATH_REGEX = r'/(?P<id>.+)$'

    PATH = os.path.abspath(__file__)
    COUNT_IMAGE = BinaryResource('count.ico', PATH)

    FAVICON = BinaryResource('favicon.ico', PATH)
    FAVICON_TEXT = 'Disk'

    TTL_MAP = {'default': 300,  # 5 минут
               'fail': 60,
               }

    def get_request_url(self, url_object, api_name=None):
        url = 'https://cloud-api.yandex.net/v1/disk/public/resources?public_key={}&preview_size={}'
        return url.format(url_object.url, 'XL')

    def handle_successful_response(self, url_object, response):
        preview_url = response.get('preview', '')
        name = response['name']
        views = response['views_count']
        owner = response['owner']['login']

        result = List(
            ttl=self.get_ttl(),
            value=[
                List(ttl=self.get_ttl(),
                     value=[
                         Image(
                             src=self.FAVICON,
                             text=self.FAVICON_TEXT,
                         )],
                     action={
                               "event": "click",
                               "type": "halfscreenpreview",
                               "url": preview_url,
                           },
                     ),
                String(value=name,),
                String(value='@{}'.format(owner)),
                Image(
                    src=self.COUNT_IMAGE,
                    text='Count',
                ),
                String(value=views,),
            ]
        )

        return result
