import os

from ..base import BaseWorker
from ..mixins.simple_case import NetworkLessMixin
from ...dto.types import List, String, Image, BinaryResource


class Worker(NetworkLessMixin, BaseWorker):
    HOSTNAME_REGEX = {'production': r'^.*\.at\.yandex-team\.ru$',
                      'testing': r'^.*\.at\.test\.tools\.yandex-team\.ru$',
                      'development': r'^.*\.at\.yandex-team\.ru$',
                      }
    PATH_REGEX = '(?P<path>.*)$'

    TTL_MAP = {
        'default': 604800,  # 1 неделя
    }

    PATH = os.path.abspath(__file__)

    FAVICON = BinaryResource('favicon.ico', PATH)
    FAVICON_TEXT = 'Atushka'

    def get_post_name(self, host_path, post_path):
        if post_path and post_path != '/':
            return '{}{}'.format(host_path, post_path)
        return host_path

    def get_url_object_data(self, url_object):
        post_path = url_object.path_match.group('path')
        host_path = url_object.hostname_match.group()
        result = List(
            ttl=self.get_ttl(),
            value=[
                Image(
                    src=self.FAVICON,
                    text=self.FAVICON_TEXT,
                ),
                String(value=self.get_post_name(host_path, post_path)),
            ]
        )
        return result
