from ..base import HttpBulkWorker
from ..mixins.femida import FemidaBulkMixin
from ..mixins.person_ticket import PersonTicketMixin
from ...dto import List, String


class Worker(FemidaBulkMixin, PersonTicketMixin, HttpBulkWorker):

    RESOURCE = 'candidates'
    PATH_REGEX = r'^/(?P<resource>{})/(?P<id>\d+)/?$'.format(RESOURCE)
    FIELDS = ('first_name', 'last_name')

    def handle_item(self, item):
        return List(
            ttl=self.get_ttl(key=self.RESOURCE),
            value=[
                self.favicon,
                String(value='{first_name} {last_name}'.format(**item)),
            ],
        )
