import os

from ..base import BaseWorker
from ...dto.types import List, String, Image, BinaryResource
from ..mixins.simple_case import NetworkLessMixin


class Worker(NetworkLessMixin, BaseWorker):
    HOSTNAME_REGEX = {'production': '^lunapark.yandex-team.ru$',
                      'testing': '^lunapark.test.yandex-team.ru$',
                      'development': '^lunapark.yandex-team.ru$',
                      }
    PATH_REGEX = '/(?P<id>.*)$'

    PATH = os.path.abspath(__file__)

    FAVICON = BinaryResource('favicon.ico', PATH)
    FAVICON_TEXT = 'Lunapark'

    TTL_MAP = {
        'default': 604800,  # 1 неделя
    }

    def get_response_string(self, url_object):
        shoot_id = url_object.path_match.group('id')
        if shoot_id:
            return shoot_id
        return url_object.url

    def get_url_object_data(self, url_object):
        result = List(
                ttl=self.get_ttl(),
                value=[
                    Image(
                        src=self.FAVICON,
                        text=self.FAVICON_TEXT,
                    ),
                    String(value=self.get_response_string(url_object)),

                ])
        return result
