import os

from ..base import BaseWorker
from ...dto.types import List, String, Image, BinaryResource
from ..mixins.simple_case import NetworkLessMixin


class Worker(NetworkLessMixin, BaseWorker):
    HOSTNAME_REGEX = {'production': '^help-otrs.yandex-team.ru$',
                      'testing': '^help-otrs.test.yandex-team.ru$',
                      'development': '^help-otrs.yandex-team.ru$',
                      }
    PATH_REGEX = '/~(?P<id>.*)$'

    PATH = os.path.abspath(__file__)

    FAVICON = BinaryResource('favicon.ico', PATH)
    FAVICON_TEXT = 'OTRS'

    TTL_MAP = {
        'default': 259200,  # 3 дня
    }

    def get_url_object_data(self, url_object):
        ticket_id = url_object.path_match.group('id')
        if ticket_id:
            result = List(
                separator='',
                ttl=self.get_ttl(),
                value=[
                    Image(
                        src=self.FAVICON,
                        text=self.FAVICON_TEXT,
                    ),
                    String(value=ticket_id),

                    ]
            )
            return result
