import os

from ..mixins.simple_case import NetworkLessMixin
from ...dto.types import List, String, Image, BinaryResource
from ..base import BaseWorker


class Worker(NetworkLessMixin, BaseWorker):
    HOSTNAME_REGEX = {'production': '^paste.yandex-team.ru$',
                      'testing': '^paste.test.yandex-team.ru$',
                      'development': '^paste.yandex-team.ru$',
                      }

    PATH_REGEX = '^/(?P<id>\d+)/?$'

    PATH = os.path.abspath(__file__)

    FAVICON = BinaryResource('favicon.ico', PATH)
    FAVICON_TEXT = 'Paste'

    TTL_MAP = {
        'default': 3600,  # 1 час
    }

    def get_represent_sting(self, url_object, paste_id):
        return '{}/{}'.format(url_object.split_result.netloc,
                              paste_id,
                              )

    def get_url_object_data(self, url_object):
        paste_id = url_object.path_match.group('id')
        if paste_id:
            represent_string = self.get_represent_sting(url_object, paste_id)
            result = List(
                ttl=self.get_ttl(),
                value=[
                    Image(
                        src=self.FAVICON,
                        text=self.FAVICON_TEXT,
                    ),
                    String(value=represent_string,
                           action={
                               "event": "click",
                               "type": "halfscreenpreview",
                               "url": url_object.url
                           }
                           ),
                ]
            )
            return result

