from ..base import HttpBulkWorker
from ..mixins.sandbox import SandboxMixin


class Worker(SandboxMixin, HttpBulkWorker):
    SANDBOX_TYPE = 'resource'
    PATH_REGEX = '^/resource/(?P<key>\d+)/?.*$'
    STATUS_FIELD_NAME = 'state'

    STATUS_COLOR_MAP = {
        'BROKEN': '#FD0D1B',
        'DELETED': '#b28060',
        'NOT_READY': '#f7bf41',
        'READY': '#18a651',
    }
