from ..base import HttpBulkWorker
from ..mixins.sandbox import SandboxMixin


class Worker(SandboxMixin, HttpBulkWorker):
    SANDBOX_TYPE = 'scheduler'
    PATH_REGEX = '^/scheduler/(?P<key>\d+)/?.*$'

    STATUS_COLOR_MAP = {
        'FAILURE': '#FD0D1B',
        'DELETED': '#b28060',
        'STOPPED': '#FD0D1B',
        'WAITING': '#ABABAB',
        'WATCHING': '#1DAFF0',
    }

    def get_description(self, url_data):
        return url_data.get('task', {}).get('description', '')
