from django.utils.functional import cached_property

from ..base import HttpBulkWorker
from ..mixins.sandbox import SandboxMixin


class Worker(SandboxMixin, HttpBulkWorker):
    SANDBOX_TYPE = 'task'
    PATH_REGEX = '^/task/(?P<key>\d+)/?.*$'

    STATUS_FIELD_NAME = 'status'

    FIELDS = 'owner', 'description', STATUS_FIELD_NAME,

    STATUS_COLOR_MAP = {
        'FAILURE': '#FD0D1B',
        'DELETED': '#b28060',
        'DELETING': '#b28060',
        'DRAFT': '#b28060',
        'SUCCESS': '#18A651',
        'ENQUEUED': '#ABABAB',
        'ENQUEUING': '#ABABAB',
        'EXCEPTION': '#FD0D1B',
        'EXECUTING': '#1DAFF0',
        'FINISHING': '#1DAFF0',
        'NOT_RELEASED': '#FD0D1B',
        'NO_RES': '#FD0D1B',
        'PREPARING': '#1DAFF0',
        'RELEASED': '#18A651',
        'RELEASING': '#18A651',
        'STOPPED': '#FD0D1B',
        'STOPPING': '#FD0D1B',
        'SUSPENDED': '#1DAFF0',
        'SUSPENDING': '#1DAFF0',
        'TEMPORARY': '#ABABAB',
        'TIMEOUT': '#FD0D1B',
        'WAIT_OUT': '#ABABAB',
        'WAIT_RES': '#ABABAB',
        'WAIT_TASK': '#ABABAB',
        'WAIT_TIME': '#ABABAB',
    }

    def get_request_url(self):
        url = super().get_request_url()
        return '{url}&fields={fields}&children=true&hidden=true&status=ALL'.format(url=url,
                                                                                   fields=self.fields,
                                                                                   )

    @cached_property
    def fields(self):
        return ','.join(self.FIELDS)
