import os
import itertools

from ids.registry import registry

from ..base import IdsBulkWorker
from ..mixins.staff_user import StaffUserMixin


class Worker(StaffUserMixin, IdsBulkWorker):
    HOSTNAME_REGEX = {'production': '^staff.yandex-team.ru$',
                      'testing': '^staff.test.yandex-team.ru$',
                      'development': '^staff.yandex-team.ru$',
                      }

    PATH = os.path.abspath(__file__)

    async def get_repository(self):
        token = await self.get_token()
        return registry.get_repository('staff', 'person', user_agent=self.get_user_agent(),
                                       oauth_token=token, **self.get_request_params())

    def get_lookup_data(self):
        return {
            'login': ','.join(self.get_logins()),
            '_fields': 'login,name.last,name.first,language.ui',
        }

    def get_logins(self):
        logins_from_urls = (url_object.path_match.group('login')
                            for url_object in self.url_objects)
        requester_login = (self.request.yauser.login, )
        return itertools.chain(logins_from_urls, requester_login)

    def get_response_language(self, response_data):
        return response_data[self.request.yauser.login]['language']['ui']

    def get_user_title(self, user_name_data, prepared_data):
        response_language = self.get_response_language(prepared_data)
        return '{} {}'.format(user_name_data['first'][response_language],
                              user_name_data['last'][response_language],
                              )

    def get_prepared_data(self, response):
        return {user_data['login']: user_data
                for user_data in response}
